
use "$inputdata/percfactor.dta", clear

label var percfactor1 "Strategy A1: Observed percentile Income-Consumption ratio"
label var percfactor2 "Strategy A2: Floor ratio = 1"
label var percfactor3 "Strategy A0: Mean between floor and observed"
label var perc "Percentile"
replace perc=round(perc*1000)

gen Percentile=perc/1000000
graph twoway (connected percfactor1 percfactor2 percfactor3 Percentile), ///
ytitle ("Ratio of percentile average income over" "consumption") yscale(titlegap(*5)) ///
graphregion(color(white)) legend(size(vsmall)) ///
yscale(r(0(.25)1.75)) ytick(0(.25)1.75) ylabel(0(.25)1.75, grid gstyle(dot)) yscale(titlegap(*2)) ///
xscale(r(0(20)100)) xtick(0(20)100) xlabel(0(20)100, grid gstyle(dot))  xscale(titlegap(*10)) 



graph export "$user/WID_India/Graphs/Appendix4.png", replace

keep percfactor1 percfactor2 percfactor3 Percentile
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix4-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix4") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix4.png")
