
// Main dofile for WID India 2017 series (1922-2015)





// TABLE OF CONTENT

// 0 Misc
// 1 Set global variables
// 2 Select strategies
/// 2.1 Set benchmark strategy
/// 2.2 Loop over all strategies
// 3 Import and prepare raw tax data
/// 3.1 Prepare raw tax for gpinter step 1
/// 3.2 Correct erroneous years
/// 3.3 Prepare for gpinter step 2
/// 3.4 Merge all tax series
// 4 Import and prepare NSS data
/// 4.1 Prepare post 1983 NSS data for gpinter
/// 4.2 Prepare pre 1983 NSS data for gpinter
/// 4.3 Prepare pre 1983 NSS data for gpinter
// 5 Rescale surveys to move from consumption to income
/// 5.1 Generate percentile profile
/// 5.2 Rescale post 1983 
/// 5.3 Rescale pre 1983
/// 5.4 Sum Stats
// 6 Combine Tax and Survey Data
/// 6.1 Prepare Tax Data for junction
/// 6.2 Prepare Survey Data for junction 
/// 6.3 Find Empirical p2 junction point
/// 6.4 Range 1 junction : p1=p90
/// 6.5 Range 2 junction : p1=p95
/// 6.6 Range 3 junction : p1=p80
/// 6.7 Remaining_Junction_Graphs.do
// 7 Finalise series
/// 7.1 Final series - current values
/// 7.2 Final series - constant values
/// 7.3 Export for Global GIC 




// 0 Misc

set more off
*ssc install wid

// 1 Set global variables

	local dir `c(pwd)'
	if substr("`dir'",1,11) == "/Users/iluc"{
		global user "/Users/iLucas/Dropbox"
	}
	local dir `c(pwd)'
	if substr("`dir'",1,11) == "/Users/luca"{
		global user "/Users/lucaschancel/Dropbox"
	}
global pathway "$user/WID_India/Codes"
global inputdata "$user/WID_India/Data/Input"
global outputdata "$user/WID_India/Data/Results"

/*
global survey "$user/India_2016/Data/NSS/Consumer_Expenditure_Data"
global input_WID "$user/India_2016/ICPSR"
global figures "$user/India_2016/Paper/Figures"
global work_dir "$user/India_2016"
global data "$work_dir/Data"
global data1 "$work_dir/Data/New Codes/BP Paper replicating"
*/

global SurveyInterpResults "$inputdata/SurveyInterpResults"
global results_interp_1 "$inputdata/TaxInterpResults"
global genfiles "$inputdata/TaxForInterp"
global adult_pop "$inputdata/India_pop.dta" 
global RawTaxData "$inputdata/Raw_Tax_Data_2.xls"

* Is tax data already processed?
global taxdone yes


//NB: Gross income selected [see Import_Raw_Tax_Data]


// 2 Set strategy

/// 2.1 Set benchmark strategy

global strategyA A0
global strategyB B1
global strategyC C1
global strategyD D1



/// 2.2 Loop over all strategies (54 combinations)
foreach varA in 0 1 2 {
global strategyA A`varA'

foreach varB in 1 2 {
global strategyB B`varB'

foreach varC in 1 2 3 {
global strategyC C`varC'

foreach varD in 1 2 3 {
global strategyD D`varD'

disp "$strategyA$strategyB$strategyC$strategyD"

 

// 3 Import and prepare raw tax data

local taxdone="$taxdone"
if "`taxdone'"=="no"{


/// 3.1 Prepare raw tax for gpinter step 1

// Creation of xls files for Indian fiscal data to feed gpinter
// These files revise both INCOME & POPULATION controls used in BP

do "$pathway/Import_Raw_Tax_Data.do"
// Then Run gpinter with all the files created (wid.word/gpinter)
//Interpolation results to be saved in  "$inputdata/TaxInterpResults/"

/// 3.2 Correct erroneous years

do "$pathway/Minor_Corrections_Raw_Tax.do"

/// 3.3 Prepare for gpinter step 2

*pause on
*pause Check whether 1995 to 1998 files are interpolated a second time
*pause off
//Re-run gpinter for years 1995 to 1998 (from "$genfiles/")
//Interpolation results to be saved in  "$inputdata/SurveyInterpResults/"


* Interpolation is completed

/// 3.4 Merge all tax series

do "$pathway/Merge_Interp_Data.do"

// 4 Import and prepare NSS data

/// 4.1 Prepare post 1983 NSS data for gpinter

do "$pathway/Prepare_Post1983_Interp.do"

/// 4.2 Prepare pre 1983 NSS data for gpinter

do "$pathway/Prepare_Pre1983.do"
//[NB: alternative using NSS obtained from WIID, not as precise] 
//Interpolation results to be saved in  "$inputdata/SurveyInterpResults/"


// 5 Rescale surveys to move from consumption to income

/// 5.1 Generate percentile profile
//do "$pathway/IHDS_percfactor.do"

/// 5.2 Rescale post 1983
do "$pathway/Rescale_Post1983.do"

/// 5.3 Rescale pre 1983

do "$pathway/Rescale_Pre1983.do"

}

// 6 Combine Tax and Survey Data

/// 6.1 Prepare Tax Data for junction

quietly do "$pathway/Prepare_Tax_All_Years.do"

/// 6.2 Prepare Survey Data for junction 

* Strategy A and B selected here

quietly do "$pathway/Prepare_Survey_All_Years.do"

/// 6.3 FIND EMPIRICAL TOP JUNCTION POINT 

quietly do "$pathway/Empirical_p2.do"


/// 6.4 RANGE 1 JUNCTION: p1=p90


local strategyC="$strategyC"
if "`strategyC'"=="C1"{
quietly do "$pathway/Junction_Range_1.do"
}


/// 6.5 RANGE 2 JUNCTION: p1=p95


local strategyC="$strategyC"
if "`strategyC'"=="C2"{
quietly do "$pathway/Junction_Range_2.do"
}

/// 6.6 RANGE 2 JUNCTION: p1=p80

local strategyC="$strategyC"
if "`strategyC'"=="C3"{
quietly do "$pathway/Junction_Range_3.do"
}

/// 6.7 Remaining_Junction_Graphs.do

// 7 Finalise series

/// 7.1 Ensure consistency of estimates, harmonize to current values

quietly do "$pathway/Final_Current.do"


/// 7.2 Final series - constant values

* Strategy D here

quietly do "$pathway/Final_Constant.do"

* Global loops end here

}
}
}
}
*

/// 7.3 Export for Global GIC 

// do "$pathway/Export_Global_GIC.do"


// 8. Graphs 
/// 5.4 Sum Stats

quietly do "$pathway/Final_Prepare_Graphs.do"

quietly do "$pathway/NSS_SumStats.do"

