import excel using "$user/WID_India/Data/Input/MarginalIncomeTaxRates/Maximum Marginal Rate.xls", sheet(Results) clear
keep B F
drop in 1/2
destring B, replace

rename B Year
rename F TopTaxRate
replace TopTaxRate=TopTaxRate*100
drop if TopTaxRate==.

egen avg6585=mean(TopTaxRate) if Year>=1966 & Year<=1985

graph twoway (connected TopTaxRate Year, msize(vsmall) msymbol(S)), graphregion (color(white)) ytitle (Top marginal income tax rate (%)) yscale(titlegap(*5)) ///
xtitle("") ///
ylabel(, grid gstyle(dot)) xlabel(, grid gstyle(dot)) xlabel (1940(10)2010) xscale (r(1940(10)2010)) ///
legend (off)

graph export "$user/WID_India/Graphs/Figure13.png", replace

keep TopTaxRate Year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Figure13-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Figure13") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Figure13.png")

