//UNSNA vs WB growth rates


clear
import excel using "$inputdata/ComparingWB_UNgrowth.xlsx", sheet(Data)


gen WB=C*100
gen UN=D*100

local tick 1960 1970 1980 1990 2000 2010 
local lab  1960 "1960-1969" 1970 "1970-1979" 1980 "1980-1989" 1990 "1990-1999" 2000 "2000-2009" 2010 "2010-2015" 

graph twoway (connected WB UN A), graphregion (color(white)) ///
ytitle (Annual per adult real GDP growth (%)) yscale(titlegap(*5)) xtitle("") ///
yscale(r(-2(1)7)) yscale(titlegap(*2)) ///
ytick(-2(1)7) ylabel(-2(1)7, grid gstyle(dot)) ///
xscale(r(1958(10)2015))  xscale(titlegap(*10)) ///
yline(0, lcol(black) lwidth(vthin) lpattern(solid)) ///
legend(off) ///
xlab(`lab', labsize(small) grid gstyle(dot)) ///
plotregion(margin(right)) ///
legend(off) ///
xline(`tick', lpattern(dot) lcol(grey))


graph export "$user/WID_India/Graphs/Appendix1.png", replace

preserve
keep A UN WB
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix1-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix1") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix1.png")

restore
