use "$inputdata/Combined_NSS_data.dta", clear

gen total_cons=mpce30*HH_Size*365/30
replace Num_Adults=Adultsge20yrs if Adultsge20yrs!=.
gen adult_cons=total_cons/Num_Adults
drop Adultsge20yrs
drop if Num_Adults==0

drop if comb_wt==.
gen weight=round(comb_wt)
gen double adults_weight=round(comb_wt*Num_Adults)
bys year: egen adults_weight_total=total(adults_weight)
gen double share_weight=100*(adults_weight/adults_weight_total)


keep year share_weight adult_cons

// We assume survey corresponds to end year
replace year="1988" if year=="1987-88"
replace year="1994" if year=="1993-1994"
replace year="2000" if year=="1999-2000"
replace year="2005" if year=="2004-2005"
replace year="2010" if year=="2009-2010"
destring year, replace
levelsof year, clean
global years=r(levels)

save "$inputdata/Combined_NSS_data2.dta", replace

 
//levelsof year, clean
//global surveyyearlist=r(levels)

foreach year in 1983 1988 1994 2000 2005 2010{
use "$inputdata/Combined_NSS_data2.dta", clear
keep if year==`year'
drop year
save "$inputdata/SurveyForInterp/RawDataFromSurvey_`year'.dta", replace
} 




foreach year in 1983 1988 1994 2000 2005 2010{

use "$inputdata/SurveyForInterp/RawDataFromSurvey_`year'.dta", clear

global income adult_cons
ren share_weight pop_obs_sh 
global year `year'
global country India



foreach var of global income{
preserve
bysort  `var' : egen pop_rep_obs_sh=sum(pop_obs_sh)
keep `var' pop_rep_obs_sh
duplicates drop

xtile xtile_MIX=`var' [aw=pop_rep_obs_sh], nq(25)

sort `var'
gen cumul_pop_rep_obs_sh=sum(pop_rep_obs_sh)

forv i=0(1)9{
replace xtile_MIX =9`i' if (90+`i')<=cumul_pop_rep_obs_sh & cumul_pop_rep_obs_sh<(91+`i')
} 
*

gen cumul_pop_rep_obs_sh_2=cumul_pop_rep_obs_sh
tostring cumul_pop_rep_obs_sh_2, replace force
tostring xtile_MIX, replace force
replace xtile_MIX=substr(cumul_pop_rep_obs_sh_2, 1, 4) if cumul_pop_rep_obs_sh>=99
destring xtile_MIX, replace force
drop cumul_pop_rep_obs_sh_2
replace xtile_MIX=99.9 if cumul_pop_rep_obs_sh==100

gen bracketavg=.
forv i=1(1)23{
quietly : sum `var' [aw=pop_rep_obs_sh] if xtile_MIX==`i'
replace bracketavg=r(mean) if xtile_MIX==`i'
} 
*

forv i=90(1)99{
quietly : sum `var' [aw=pop_rep_obs_sh] if xtile_MIX==`i'
replace bracketavg=r(mean) if xtile_MIX==`i'
} 
*

tostring xtile_MIX, replace force
*replace xtile_MIX=trim(xtile_MIX)
forv i=1(1)9{
quietly : sum `var' [aw=pop_rep_obs_sh] if xtile_MIX=="99.`i'"
replace bracketavg=r(mean) if xtile_MIX=="99.`i'"
} 
*

bysort xtile_MIX : egen pct_pop_MIX=sum(pop_rep_obs_sh)
destring xtile_MIX, replace force
sort xtile_MIX `var'
bysort xtile_MIX : gen order_MIX=_n
keep if order_MIX==1
drop order_MIX pop_rep_obs_sh xtile_MIX

gen p_100=sum(pct_pop_MIX)
gen p=p_100[_n-1]

gen average=.
sum bracketavg [aw=pct_pop_MIX], d
replace average=r(mean) in 2
replace p=p/100
drop p_100 pct_pop_MIX
ren `var' thr 

gen year=.
replace year=$year in 2

gen country="" 
replace country="$country" in 2

order year country average p thr bracketavg 
drop cumul_pop_rep_obs_sh
drop in 1

drop if p==1

export excel using "$inputdata/SurveyForInterp/RawDataFromSurvey_`year'.xlsx", first(var) replace

restore
}
*

}
