
global outputdata "$user/WID_India/Data/Results"
global firstyear 1980
global lastyear 2014

// ------------ GLOBALS
clear all

// Do

foreach var in 1 2 3 4 5 6 7 8 9 10 {
if `var'==1{
global firstyear 1951
global lastyear 1980
disp "$firstyear-$lastyear"
}

if `var'==2{
global firstyear 1951
global lastyear 1959
disp "$firstyear-$lastyear"
}

if `var'==3{
global firstyear 1960
global lastyear 1969
disp "$firstyear-$lastyear"
}

if `var'==4{
global firstyear 1970
global lastyear 1979
disp "$firstyear-$lastyear"
}

if `var'==5{
global firstyear 1980
global lastyear 1989
disp "$firstyear-$lastyear"
}

if `var'==6{
global firstyear 1990
global lastyear 1999
disp "$firstyear-$lastyear"
}


if `var'==7{
global firstyear 2000
global lastyear 2009
disp "$firstyear-$lastyear"
}

if `var'==8{
global firstyear 2000
global lastyear 2014
disp "$firstyear-$lastyear"
}

if `var'==9{
global firstyear 2010
global lastyear 2014
disp "$firstyear-$lastyear"
}

if `var'==10{
global firstyear 1980
global lastyear 2014
disp "$firstyear-$lastyear"
}


import delimited "$outputdata/India_benchmark_19222014_constant.csv", delim(";") clear

// Globals
global incvar aptinc992j
global topsharevar sptinc992j
global popvar npopul992i

// Subset and rename
keep if inlist(year, $firstyear , $lastyear )
rename $incvar ainc
rename $topsharevar topsh
rename $popvar npop

// Population
gen pop=0.01
replace pop=0.001 if inrange(p,99000,99800)
replace pop=0.0001 if inrange(p,99900,99980)
replace pop=0.00001 if inrange(p,99990,99999)

// Total income
bys year: gen tot=pop*ainc
bys year: egen totinc=sum(tot)

// Keep
keep year p pop ainc totinc topsh npop

// Reshape
reshape wide ainc totinc topsh npop, i(p pop) j(year)

cleanchars, in($firstyear) out(1) vname
cleanchars, in($lastyear) out(2) vname

* Total growth rates
gen growth = 100 * (( ainc2 - ainc1 ) / ainc1) if ainc1 > 0
replace growth = - (100 * (( ainc2 - ainc1 ) / ainc1)) if ainc1 < 0

* Annual growth rates
local diffinc=$lastyear - $firstyear
gen annualgrowth = 100 * ((( ainc2/ ainc1)^(1/`diffinc'))-1)

sort p pop, stable

* SHAREDY: share of total growth captured by the percentile in its country (per cap version)
gen shareDY= (ainc2 * pop - ainc1 * pop)/(totinc2 - totinc1)
replace shareDY = 100*shareDY

* NEW AXIS: CUMULATED GROWTH RATE
gen sumshareDY=sum(shareDY)

* Inverted cumulated new axis
gsort -p
gen invsumshareDY=sum(shareDY)
sort p, stable

* Round last values to 100
replace sumshareDY=round(sumshareDY,1) if _n==_N
assert sumshareDY[_N]==100

* Generate years
gen years="$firstyear" + "-" + "$lastyear"

save "$outputdata/GIC/gic-india-$firstyear-$lastyear.dta", replace


use "$outputdata/GIC/gic-india-$firstyear-$lastyear.dta", clear


// ----------------------------- PREPARE
format topsh1 npop1 ainc1 totinc1 topsh2 npop2 ainc2 totinc2 growth annualgrowth shareDY sumshareDY invsumshareDY %12.0g

*** Generate average incomes of percentiles groups
foreach i in 1 2{
replace topsh`i'=topsh`i'/100
}

foreach i in 1 2{
gen aa=1-topsh`i' if p==50000 //  bottom 50
egen bot50share`i'=mean(aa)
drop aa
gen long bot50Y`i'=bot50share`i'*totinc`i'/(0.5)

gen aa=1-topsh`i' if p==90000 // middle 40
egen mid40share`i'=mean(aa)
replace mid40share`i'=mid40share`i'-bot50share`i'
drop aa
gen long mid40Y`i'=mid40share`i'*totinc`i'/(0.4)

gen aa=topsh`i' if p==90000 // top 10
egen top10share`i'=mean(aa)
drop aa
gen long top10Y`i'=top10share`i'*totinc`i'/(0.1)

gen aa=topsh`i' if p==99000 // top 1
egen top1share`i'=mean(aa)
drop aa
gen long top1Y`i'=top1share`i'*totinc`i'/(0.01)

gen aa=topsh`i' if p==99900 // top 0.1
egen top01share`i'=mean(aa)
drop aa
gen long top01Y`i'=top01share`i'*totinc`i'/(0.001)

gen aa=topsh`i' if p==99990 // top 0.01
egen top001share`i'=mean(aa)
drop aa
gen long top001Y`i'=top001share`i'*totinc`i'/(0.0001)

gen aa=topsh`i' if p==99999 // top 0.001
egen top0001share`i'=mean(aa)
drop aa
gen long top0001Y`i'=top0001share`i'*totinc`i'/0.00001
}

* Generate growth and average growth
local diffinc=$lastyear - $firstyear
foreach var in totinc bot50Y mid40Y top10Y top1Y top01Y top001Y top0001Y{
gen `var'growth=100*((`var'2/`var'1)-1)
gen `var'agrowth=100*((`var'2/`var'1)^(1/`diffinc')-1) // average annual growth rate
}

* Generate shares of growth captured by country
egen bot40Yshare=sum(shareDY) if inrange(p,0,39000)
egen bot50Yshare=sum(shareDY) if inrange(p,0,49000)
egen mid40Yshare=sum(shareDY) if inrange(p,50000,89000)
egen top10Yshare=sum(shareDY) if p>=90000
egen next9Yshare=sum(shareDY) if inrange(p,90000,98000)
egen top1Yshare=sum(shareDY) if p>=99000
egen top01Yshare=sum(shareDY) if p>=99900
egen top001Yshare=sum(shareDY) if p>=99990
egen top0001Yshare=sum(shareDY) if p>=99999
foreach var of varlist bot40Yshare bot50Yshare mid40Yshare top10Yshare next9Yshare top1Yshare top01Yshare top001Yshare top0001Yshare {
egen `var'2=mean(`var')
drop `var'
rename `var'2 `var'
}


// -------------------------------------- RESHAPE TO GENERATE TABLE

keep totinc* bot50Y* mid40Y* top10Y* top1Y* top01Y* top001Y* top0001Y* years
keep if _n==1
gen id=_n
reshape long totinc bot50Y mid40Y top10Y top1Y top01Y top001Y top0001Y, i(id year) j(Y) string
drop id

foreach var in totinc bot50Y mid40Y top10Y top1Y top01Y top001Y top0001Y{
rename `var' x`var'
}

tostring Y, replace
replace Y="IN$firstyear" if Y=="1"
replace Y="IN$lastyear" if Y=="2"

reshape long  x, i(Y years) j(new) string
rename Y v
reshape wide  x, i(new years) j(v) string
renpfix x



// ------------------------------------------- CLEAN AND LABEL
replace new="Average" if new=="totinc"
replace new="Bottom 40%" if new=="bot40Y"
replace new="Bottom 50%" if new=="bot50Y"
replace new="Middle 40%" if new=="mid40Y"
replace new="Top 10%" if new=="top10Y"
replace new="Next 9%" if new=="next9Y"
replace new="Top 1%" if new=="top1Y"
replace new="Top 0.1%" if new=="top01Y"
replace new="Top 0.01%" if new=="top001Y"
replace new="Top 0.001%" if new=="top0001Y"
rename new group
sort group
gen sort=1
replace sort =2 if group=="Bottom 40%"
replace sort =3 if group=="Bottom 50%"
replace sort =4 if group=="Middle 40%"
replace sort =5 if group=="Top 10%"
replace sort =6 if group=="Next 9%"
replace sort =7 if group=="Top 1%"
replace sort =8 if group=="Top 0.1%"
replace sort =9 if group=="Top 0.01%"
replace sort =10 if group=="Top 0.001%"
sort sort
drop sort

cleanchars, in(IN) out(India) vname
lab var India$firstyear "$firstyear"
lab var India$lastyear "$lastyearc"
lab var agrowth "Average growth"
lab var growth "Total growth"
lab var share "Share"

ds years group agrowth share, not
foreach var of varlist `r(varlist)'{
replace `var' = round(`var',1)
}

replace agrowth = round(agrowth,0.01)
replace share = round(share,0.01)

// ------------------------ SAVE

save "$outputdata/table-$firstyear-$lastyear.dta", replace
}
