
use "$inputdata/RawResults/Final_Current_$strategyA$strategyB$strategyC.dta",clear


drop average_tax tax bavg_tax meaninc_tax groupshare_tax topavg_tax beta_tax survey bavg_survey average_cons_survey groupshare_survey topavg_survey beta_survey
rename meaninc_survey survey_mean
drop upfactor* weights*
drop average_NY thr_NY topshare_NY topavg_NY bracketavg_NY

drop _merge
joinby year using "$inputdata/deflator_india.dta", unmatched (both)
drop _merge
joinby year using "$inputdata/adultpop.dta", unmatched (both)
drop _merge

gen anninc992i_constant=mnninc999i/adult
gen anninc992i_current=anninc992i_constant*inyixx999i


local strategyD="$strategyD"
if "`strategyD'"=="D2"{
*foreach var in topshare groupshare meaninc topavg bavg_final thr_final bottom{
*rename `var'_1 `var'
foreach var in 2 3{
drop topshare_`var' groupshare_`var' meaninc_`var' topavg_`var' beta_`var' bavg_final_`var' thr_final_`var' bottom_`var' 
}
foreach name in topshare groupshare  meaninc  topavg  beta   bavg_final  thr_final  bottom {
rename `name'_1 `name'_$strategyA$strategyB$strategyC$strategyD
}
}



local strategyD="$strategyD"
if "`strategyD'"=="D1"{
*foreach var in topshare groupshare meaninc topavg bavg_final thr_final bottom{
*rename `var'_1 `var'
foreach var in 1 3{
drop topshare_`var' groupshare_`var' meaninc_`var' topavg_`var' beta_`var' bavg_final_`var' thr_final_`var' bottom_`var' 
}
foreach name in topshare groupshare  meaninc  topavg  beta   bavg_final  thr_final  bottom {
rename `name'_2 `name'_$strategyA$strategyB$strategyC$strategyD
}
}


local strategyD="$strategyD"
if "`strategyD'"=="D3"{
*foreach var in topshare groupshare meaninc topavg bavg_final thr_final bottom{
*rename `var'_1 `var'
foreach var in 1 2{
drop topshare_`var' groupshare_`var' meaninc_`var' topavg_`var' beta_`var' bavg_final_`var' thr_final_`var' bottom_`var' 
}
foreach name in topshare groupshare  meaninc  topavg  beta   bavg_final  thr_final  bottom {
rename `name'_3 `name'_$strategyA$strategyB$strategyC$strategyD
}
}



// constant values
foreach var in meaninc topavg bavg_final thr_final survey_mean{
gen `var'_constant=`var'/inyixx999i
}

//gen meaninc_survey_constant=meaninc_survey/inyixx999i

label var meaninc_constant "Per adult fiscal income"
label var anninc992i_constant "Per adult national income"


// Gen pre-tax national income estimates

gen aptinc992j_INRconstant=anninc992i_constant*groupshare/pop
gen tptinc992j_INRconstant=thr_final_constant*(anninc992i_constant/meaninc_constant) 
gen aptinc992j_EURPPP2015=aptinc992j_INRconstant/INRtoEUP
gen tptinc992j_EURPPP2015=tptinc992j_INRconstant/INRtoEUP
gen anninc992i_EURPPP2015=anninc992i_constant/INRtoEUP


// test whether new mean is correct
/*
gen newmean_a=aptinc992j_INRconstant*pop
bys year: egen newmean_b=total(newmean_a)
br p year newmean_b bavg_final_1 meaninc_1_constant anninc992i_constant aptinc992j_INRconstant newmean_a
*/




save "$inputdata/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta",replace


local strategyALL="$strategyA$strategyB$strategyC$strategyD"
if "`strategyALL'"=="A0B1C1D1"{

use "$inputdata/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta", clear

keep if year>1950

keep p year aptinc992j_INRconstant tptinc992j_INRconstant anninc992i_constant

save "$inputdata/RawResults/Final_constant_post1950.dta", replace

use "$inputdata/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta", clear


// add pre 1950 macro variables

use "$inputdata/incomecontrol.dta", clear
keep Year mnninc999i_currentLCU
rename Year year
joinby year using "$inputdata/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta"
gen mnninc999i_constant=mnninc999i_currentLCU/inyi
replace mnninc999i=mnninc999i_constant if mnninc999i==.

replace anninc992i_constant=mnninc999i_constant/adult if anninc992i_constant==.

replace pop=.01 if pop==.
replace pop=0.001 if p>=99000 & p<99900 & pop!=0.001
replace pop=0.0001 if p>=99900 & p<99990 & pop!=0.0001
replace pop=0.00001 if p>=99990 & pop!=0.00001


foreach x of numlist 1922/1950{
gsort - year p
replace groupshare_A0B1C1D1=(topshare_A0B1C1D1-topshare_A0B1C1D1[_n+1])/100 if year==`x'
replace groupshare_A0B1C1D1=topshare_A0B1C1D1/100 if year==`x' & p==99999
}


gsort - year p
replace aptinc992j_INRconstant=anninc992i_constant*groupshare/pop if aptinc992j_INRconstant==.

rename topshare_A0B1C1D1 sptinc992j
rename adult npopul992i

keep p aptinc992j_INRconstant anninc992i_constant sptinc992j tptinc992j_INRconstant npopul992i mnninc999i_constant year inyi

rename aptinc992j_INRconstant aptinc992j
rename anninc992i_constant anninc992i
rename mnninc999i_constant mnninc999i
rename tptinc992j_INRconstant tptinc992j

save "$outputdata/India_benchmark_19222014_constant.dta", replace
outsheet using "$outputdata/India_benchmark_19222014_constant.csv", delim(;) replace

// Current for WID export
replace aptinc992j=aptinc992j*inyi
replace anninc992i=anninc992i*inyi
replace mnninc999i=mnninc999i*inyi
replace tptinc992j=tptinc992j*inyi

drop inyi

save "$outputdata/India_benchmark_19222014_current.dta", replace
outsheet using "$outputdata/India_benchmark_19222014_current.csv", delim(;) replace


}

// 


