
// Top graph only, benchmark scenario

use "$inputdata/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta", clear
keep year p bottom_$strategyA$strategyB$strategyC$strategyD topshare_$strategyA$strategyB$strategyC$strategyD
gen abottom50_$strategyA$strategyB$strategyC$strategyD=bottom_$strategyA$strategyB$strategyC$strategyD if p==50000
bys year: egen bottom50_$strategyA$strategyB$strategyC$strategyD=mean(abottom50_$strategyA$strategyB$strategyC$strategyD)
drop abottom50_$strategyA$strategyB$strategyC$strategyD
gen atopshare10_$strategyA$strategyB$strategyC$strategyD=topshare_$strategyA$strategyB$strategyC$strategyD if p==90000
bys year: egen topshare10_$strategyA$strategyB$strategyC$strategyD=mean(atopshare10_$strategyA$strategyB$strategyC$strategyD)
drop atopshare10_$strategyA$strategyB$strategyC$strategyD
gen middle40_$strategyA$strategyB$strategyC$strategyD=100-(bottom50_$strategyA$strategyB$strategyC$strategyD+topshare10_$strategyA$strategyB$strategyC$strategyD)

drop topshare10_ bottom50_

save "$inputdata/RawResults/Final_constant_graphs", replace


use  "$inputdata/RawResults/Final_constant_graphs", clear
// Top 1

graph twoway (connected topshare_A0B1C1D1 year if p==99000, msize(small) msymbol(R)), graphregion (color(white))  ///
xtitle("") ytitle("% of National Income") ///
yscale(r(5(5)25)) ytick(5(5)25) ylabel(5(5)25, grid gstyle(dot)) yscale(titlegap(*2)) ///
xscale(r(1920(10)2010)) xtick(1920(10)2010) xlabel(1920(10)2010, grid gstyle(dot)) xscale(titlegap(*2)) ///
legend (off)

graph export "$user/WID_India/Graphs/Top1.png", replace

preserve
keep if p==99000 
keep p year topshare_A0B1C1D1 
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig6-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig6") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Top1.png")

restore


// Top 0.1
use "$inputdata/RawResults/Final_constant_graphs", clear
graph twoway (connected topshare_A0B1C1D1 year if p==99900, msize(small) msymbol(R)), graphregion (color(white))  ///
xtitle("") ytitle("% of National Income") //////
ylabel(, grid gstyle(dot)) xlabel(1920(10)2010, grid gstyle(dot)) ///
legend (off)
graph export "$user/WID_India/Graphs/Top01.png", replace

preserve
keep if p==99900 
keep p year topshare_A0B1C1D1 
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig7-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig7") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Top01.png")

restore


// Top 0.01
use "$inputdata/RawResults/Final_constant_graphs", clear
graph twoway (connected topshare_A0B1C1D1 year if p==99990, msize(small) msymbol(R)), graphregion (color(white)) ///
xtitle("") ytitle(% of National Income) ///
ylabel(, grid gstyle(dot)) xlabel(1920(10)2010, grid gstyle(dot)) ///
legend (off)
graph export "$user/WID_India/Graphs/Top001.png", replace

preserve
keep if p==99990 
keep p year topshare_A0B1C1D1 
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig8-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig8") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Top001.png")

restore

// Top 10 vs middle 40
use "$inputdata/RawResults/Final_constant_graphs", clear

label var topshare_A0B1C1D1 "Top 10%"
label var middle40_A0B1C1D1 "Middle 40%"


graph twoway (connected topshare_A0B1C1D1 year if p==90000, msize(small) msymbol(R)) (connected middle40_A0B1C1D1 year if p==50000, msize(small) msymbol(R)), graphregion (color(white)) ytitle (% Total income) yscale(titlegap(*5)) ///
ytitle(% of National Income) xtitle("") legend(off) ///
ylabel(, grid gstyle(dot)) xlabel(, grid gstyle(dot)) xscale(titlegap(*10)) ///
xscale(r(1950(20)2015)) xlabel(1950(10)2015) xtick(1950(10)2015) ///
yscale(r(25(5)55)) ylabel(25(5)55) ytick(25(5)55) 

graph export "$user/WID_India/Graphs/Top10Mid40.png", replace

preserve
keep if p==90000 | p==50000
keep p year topshare_A0B1C1D1 middle40_A0B1C1D1
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig9-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig9") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Top10Mid40.png")
restore

use "$inputdata/RawResults/Final_constant_graphs", clear

graph twoway (connected bottom_A0B1C1D1 year if p==50000, msize(small) msymbol(R)), graphregion (color(white)) ytitle (% Total income) yscale(titlegap(*5)) ///
ytitle(% of National Income) xtitle("") ///
ylabel(, grid gstyle(dot)) xlabel(, grid gstyle(dot)) xscale(titlegap(*10)) ///
xscale(r(1950(20)2015)) xlabel(1950(10)2015) xtick(1950(10)2015) ///
yscale(r(10(5)30)) ylabel(15(5)30) ytick(15(5)30)  ///
legend(off)

graph export "$user/WID_India/Graphs/Bot50.png", replace

preserve
keep if p==50000
keep p year bottom_A0B1C1D1
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig10-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig10") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Bot50.png")


