

// NB: Must run "Final_Prepare_Graphs.do" first !


clear all

// Open
use "$outputdata/table-1951-1959.dta", clear
append using "$outputdata/table-1960-1969.dta"
append using "$outputdata/table-1970-1979.dta"
append using "$outputdata/table-1980-1989.dta"
append using "$outputdata/table-1990-1999.dta"
//append using "$outputdata/table-2000-2009.dta"
append using "$outputdata/table-2000-2014.dta"


// Clean
keep year group agrowth

* Group
replace group="avg" if group=="Average"
replace group="bot50" if group=="Bottom 50%"
replace group="mid40" if group=="Middle 40%"
replace group="top10" if group=="Top 10%"
replace group="top1" if group=="Top 1%"
replace group="top01" if group=="Top 0.1%"
replace group="top001" if group=="Top 0.01%"
replace group="top0001" if group=="Top 0.001%"

* Years
replace years="1955" if years=="1951-1959"
replace years="1965" if years=="1960-1969"
replace years="1975" if years=="1970-1979"
replace years="1985" if years=="1980-1989"
replace years="1995" if years=="1990-1999"
//replace years="2005" if years=="2000-2009"
replace years="2005" if years=="2000-2014"
destring years, replace force

* Reshape
reshape wide agrowth, i(years) j(group) string
renpfix agrowth

* Label
lab var avg "Full population"
lab var bot50 "Bottom 50%"
lab var mid40 "Middle 40%"
lab var top0001 "Top 0.001%"
lab var top001 "Top 0.01%"
lab var top01 "Top 0.1%"
lab var top1 "Top 1%"
lab var top10 "Top 10%"

// Graph
* Average and bottom 50
local tick 1955 1965 1975 1985 1995 2005 
local lab  2005 "2000-2015" 1995 "1990-1999" 1985 "1980-1989" 1975 "1970-1979" 1965 "1960-1969" 1955 "1951-1959" 
graph twoway (connected avg bot50 years), graphregion (color(white)) ///
ytitle (Annual per adult real income growth (%)) yscale(titlegap(*5)) xtitle("") ///
yscale(r(0(1)5)) ytick(0(1)5) ylabel(0(1)5, grid gstyle(dot)) yscale(titlegap(*2)) ///
xscale(r(1950(10)2015)) xscale(titlegap(*10)) ///
yline(0, lcol(black) lwidth(vthin) lpattern(solid)) ///
legend(rows(1) region(lcol(white)) position(6)) scheme(s2color) ///
xlab(`lab', labsize(small) grid gstyle(dot)) ///
plotregion(margin(right)) legend(off) ///
xline(`tick', lpattern(dot) lcol(grey)) 

graph export "$user/WID_India/Graphs/1-Fullpop-Bottom50.png", replace

preserve
keep avg bot50 years
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig1a-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig1a", modify)
putexcel (A1)=picture("$user/WID_India/Graphs/1-Fullpop-Bottom50.png")

restore

br avg bot50 years

local tick 1955 1965 1975 1985 1995 2005 
local lab  2005 "2000-2015" 1995 "1990-1999" 1985 "1980-1989" 1975 "1970-1979" 1965 "1960-1969" 1955 "1951-1959" 
* Full pop, top 10, top 1%
graph twoway (connected avg top10 top1 years), graphregion (color(white)) ///
ytitle (Annual per adult real income growth (%)) yscale(titlegap(*5)) xtitle("") ///
yscale(r(-6(2)10)) yscale(titlegap(*2)) ///
ytick(-6(2)10) ylabel(-6(2)10, grid gstyle(dot)) ///
xscale(r(1950(10)2015))  xscale(titlegap(*10)) ///
yline(0, lcol(black) lwidth(vthin) lpattern(solid)) ///
legend(rows(1) region(lcol(white)) position(6)) scheme(s2color) ///
xlab(`lab', labsize(small) grid gstyle(dot)) ///
plotregion(margin(right)) ///
legend(off) ///
xline(`tick', lpattern(dot) lcol(grey))

graph export "$user/WID_India/Graphs/2-Fullpop-Top10-Top1.png", replace

preserve
keep years avg top10 top1
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig1c-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig1c") modify
putexcel (A1)=picture("$user/WID_India/Graphs/2-Fullpop-Top10-Top1.png")
restore


* Average middle 40
local tick 1955 1965 1975 1985 1995 2005 
local lab  2005 "2000-2015" 1995 "1990-1999" 1985 "1980-1989" 1975 "1970-1979" 1965 "1960-1969" 1955 "1951-1959" 
graph twoway (connected avg mid40 years), graphregion (color(white)) ///
ytitle (Annual per adult real income growth (%)) yscale(titlegap(*5)) xtitle("") ///
yscale(r(0(1)5)) ytick(0(1)5) ylabel(0(1)5, grid gstyle(dot)) yscale(titlegap(*2)) ///
xscale(r(1950(10)2015)) xscale(titlegap(*10)) ///
legend(rows(1) region(lcol(white)) position(6)) scheme(s2color) ///
xlab(`lab', labsize(small) grid gstyle(dot)) legend(off) ///
xline(`tick', lpattern(dot) lcol(grey)) 
graph export "$user/WID_India/Graphs/1-Fullpop-Mid40.png", replace

preserve
keep years avg mid40 years
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig1b-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig1b") modify
putexcel (A1)=picture("$user/WID_India/Graphs/1-Fullpop-Mid40.png")
restore



