
local first1 1980
local last1 2015

forval i=1/1{
di "`i'..."
	use "/Users/lucaschancel/Dropbox/WID_India/Data/Input/wir18.dta", clear
	
	// Top shares and bottom shares
	sort iso year p
	by iso year: gen bots=sum(sinc)
	gsort iso year -p
	by iso year: gen tops=sum(sinc)
	renvars bots tops / botsh topsh
	
	// Keep
	keep if inlist(year,`first`i'',`last`i'')
	keep iso p year totinc ainc sinc topsh

	// Reshape
	reshape wide totinc-topsh, i(iso p) j(year)

	// Generate share of growth captured
	gen pop=0.01
	replace pop=0.001 if p>=99000 & p<99900
	replace pop=0.0001 if p>=99900 & p<99990
	replace pop=0.00001 if p>=99990
	gen shareDY= 100 * (ainc`last`i'' * pop - ainc`first`i'' * pop)/(totinc`last`i'' - totinc`first`i'')

	format totinc`first`i''-topsh`last`i'' %12.0g


	*Generate average incomes of percentiles groups
	foreach x in `first`i'' `last`i''{

	by iso: gen aa=1-topsh`x' if p==40000 // average income of bottom 40
	by iso: egen bot40share`x'=mean(aa)
	drop aa
	by iso: gen long bot40Y`x'=bot40share`x'*totinc`x'/(0.4)

	by iso: gen aa=1-topsh`x' if p==50000 //  bottom 50
	by iso: egen bot50share`x'=mean(aa)
	drop aa
	by iso: gen long bot50Y`x'=bot50share`x'*totinc`x'/(0.5)

	by iso: gen aa=1-topsh`x' if p==90000 // middle 40
	by iso: egen mid40share`x'=mean(aa)
	by iso: replace mid40share`x'=mid40share`x'-bot50share`x'
	drop aa
	by iso: gen long mid40Y`x'=mid40share`x'*totinc`x'/(0.4)

	by iso: gen aa=topsh`x' if p==90000 // top 10
	by iso: egen top10share`x'=mean(aa)
	drop aa
	by iso: gen long top10Y`x'=top10share`x'*totinc`x'/(0.1)

	by iso: gen aa=1-topsh`x' if p==99000 // next 9
	by iso: egen next9share`x'=mean(aa)
	by iso: replace next9share`x'=next9share`x'-(1-top10share`x')
	drop aa
	by iso: gen long next9Y`x'=next9share`x'*totinc`x'/(0.09)

	by iso: gen aa=topsh`x' if p==99000 // top 1
	by iso: egen top1share`x'=mean(aa)
	drop aa
	by iso: gen long top1Y`x'=top1share`x'*totinc`x'/(0.01)

	by iso: gen aa=topsh`x' if p==99900 // top 0.1
	by iso: egen top01share`x'=mean(aa)
	drop aa
	by iso: gen long top01Y`x'=top01share`x'*totinc`x'/(0.001)

	by iso: gen aa=topsh`x' if p==99990 // top 0.01
	by iso: egen top001share`x'=mean(aa)
	drop aa
	by iso: gen long top001Y`x'=top001share`x'*totinc`x'/(0.0001)

	by iso: gen aa=topsh`x' if p==99999 // top 0.001
	by iso: egen top0001share`x'=mean(aa)
	drop aa
	by iso: gen long top0001Y`x'=top0001share`x'*totinc`x'/0.00001
	}


	* Generate growth and average growth
	local diff=`last`i''-`first`i''
	foreach var in totinc bot40Y bot50Y mid40Y top10Y next9Y top1Y top01Y top001Y top0001Y{
	gen `var'growth=100*((`var'`last`i''/`var'`first`i'')-1)
	gen `var'agrowth=100*((`var'`last`i''/`var'`first`i'')^(1/`diff')-1) // average annual growth rate
	}

	* Generate shares of growth captured by country
	by iso: egen bot40Yshare=sum(shareDY) if inrange(p,0,39000)
	by iso: egen bot50Yshare=sum(shareDY) if inrange(p,0,49000)
	by iso: egen mid40Yshare=sum(shareDY) if inrange(p,50000,89000)
	by iso: egen top10Yshare=sum(shareDY) if p>=90000
	by iso: egen next9Yshare=sum(shareDY) if inrange(p,90000,98000)
	by iso: egen top1Yshare=sum(shareDY) if p>=99000
	by iso: egen top01Yshare=sum(shareDY) if p>=99900
	by iso: egen top001Yshare=sum(shareDY) if p>=99990
	by iso: egen top0001Yshare=sum(shareDY) if p>=99999
	foreach var of varlist bot40Yshare bot50Yshare mid40Yshare top10Yshare next9Yshare top1Yshare top01Yshare top001Yshare top0001Yshare {
	by iso: egen `var'2=mean(`var')
	drop `var'
	rename `var'2 `var'
	}


	// -------------------------------------- RESHAPE TO GENERATE TABLE

	// First reshape
	keep iso totinc* bot40Y* bot50Y* mid40Y* top10Y* next9Y* top1Y* top01Y* top001Y* top0001Y*
	by iso: keep if _n==1
	reshape long totinc bot40Y bot50Y mid40Y top10Y next9Y top1Y top01Y top001Y top0001Y, i(iso) j(Y) string

	foreach var in totinc bot40Y bot50Y mid40Y top10Y next9Y top1Y top01Y top001Y top0001Y{
	rename `var' a`var'
	}
}


	// Reshape again
	reshape long  a, i(Y iso) j(new) string
	egen v=concat(iso Y)
	drop iso Y
	reshape wide a, i(new) j(v) string
	renpfix a

	// ------------------------------------------- CLEAN AND LABEL
	replace new="Average" if new=="totinc"
	replace new="Bottom 40%" if new=="bot40Y"
	replace new="Bottom 50%" if new=="bot50Y"
	replace new="Middle 40%" if new=="mid40Y"
	replace new="Top 10%" if new=="top10Y"
	replace new="Next 9%" if new=="next9Y"
	replace new="Top 1%" if new=="top1Y"
	replace new="Top 0.1%" if new=="top01Y"
	replace new="Top 0.01%" if new=="top001Y"
	replace new="Top 0.001%" if new=="top0001Y"
	rename new group
	sort group
	gen sort=1
	replace sort =2 if group=="Bottom 40%"
	replace sort =3 if group=="Bottom 50%"
	replace sort =4 if group=="Middle 40%"
	replace sort =5 if group=="Top 10%"
	replace sort =6 if group=="Next 9%"
	replace sort =7 if group=="Top 1%"
	replace sort =8 if group=="Top 0.1%"
	replace sort =9 if group=="Top 0.01%"
	replace sort =10 if group=="Top 0.001%"
	sort sort
	drop sort

//
keep group CN* US* WE*
drop WE1 WE2  US1 US2 CN1 CN2






	ds group *agrowth *share, not
	foreach var of varlist `r(varlist)'{
	replace `var' = round(`var',1)
	}

	foreach var of varlist *agrowth *share{
	replace `var' = round(`var',0.01)
	}
	
br

preserve
keep group CNgrowth USgrowth WEgrowth
drop if group=="Bottom 40%"
drop if group=="Next 9%"
export excel using "$user/WID_India/tables/Tables.xlsx", sheet("Table1-data") sheetmodify firstrow(varl)
restore

preserve
keep group CNagrowth USagrowth WEagrowth
drop if group=="Bottom 40%"
drop if group=="Next 9%"
export excel using "$user/WID_India/tables/Tables.xlsx", sheet("avg1") sheetmodify firstrow(varl)
restore


preserve
keep group CNshare USshare WEshare
drop if group=="Bottom 40%"
drop if group=="Top 10%"
export excel using "$user/WID_India/tables/Tables.xlsx", sheet("Table2-data") sheetmodify firstrow(varl)
restore


// Total growth for average, bot50, mid40, top 10 and smaller
use "$outputdata/gic/table-1980-2014.dta", clear

keep group growth share
replace share=100 if share==.
export excel using "$user/WID_India/Tables/Tables.xlsx", sheet("Table1-databis") sheetmodify firstrow(varl)



