


use "$inputdata/WBdata_pre1983_all.dta", clear

// Warning we use NSS tab data here
//use "$pathway2/NSS_tab_final.dta", clear

rename p perc
joinby perc using "$inputdata/percfactor.dta", unmatched (both)
drop _merge


gen percfactor_int=percfactor1 if perc==99000
egen percfactor_int2=max(percfactor_int)
replace percfactor1=percfactor_int2 if perc>99000
drop percfactor_int percfactor_int2

gen percfactor2_int=percfactor2 if perc==99000
egen percfactor2_int2=max(percfactor2_int)
replace percfactor2=percfactor2_int2 if perc>99000
drop percfactor2_int percfactor2_int2

gen percfactor3_int=percfactor3 if perc==99000
egen percfactor3_int2=max(percfactor3_int)
replace percfactor3=percfactor3_int2 if perc>99000
drop percfactor3_int percfactor3_int2
 
gen estimated_inc1=bracketavg*percfactor1
gen estimated_inc2=bracketavg*percfactor2
gen estimated_inc3=bracketavg*percfactor3

gen estimated_thr1=thr*percfactor1
gen estimated_thr2=thr*percfactor2
gen estimated_thr3=thr*percfactor3

gen pop=1 if perc<99000
replace pop=0.1 if perc>=99000 & perc<99900
replace pop=0.01 if perc>=99900 & perc<99990
replace pop=0.001 if perc>=99990
gen groupinc_1=estimated_inc1*pop
gen groupinc_2=estimated_inc2*pop
gen groupinc_3=estimated_inc3*pop


bysort year: egen SurveyIncome1=total(groupinc_1)
replace SurveyIncome1=SurveyIncome1/100
bysort year: egen SurveyIncome2=total(groupinc_2)
replace SurveyIncome2=SurveyIncome2/100
bysort year: egen SurveyIncome3=total(groupinc_3)
replace SurveyIncome3=SurveyIncome3/100
drop groupinc*

sort year perc



drop if year>=1983
save "$inputdata/NSS_tab_final_income.dta", replace


/*
keep if perc==1000
foreach var in 1 2 3{
gen savings`var'=SurveyIncome`var'/average
}
graph twoway (line savings1 savings2 savings3 year)
*/
