import excel using "$inputdata/WB_data_interpolated/Gini Coefficients2.xls", clear firstrow
levelsof Year, local(WByearlist)
global WByearlist `WByearlist'


local firstiter=0
foreach var in $WByearlist{
insheet using "$inputdata/WB_data_interpolated/Consumption, `var'.csv", delim(,) clear
egen year2=mean(trunc(year))
replace year=year2
egen average2=mean(average)
replace average=average2
drop average2
drop country component
save "$inputdata/WB_data_interpolated/Consumption, `var'.dta", replace
if `firstiter'!=0{
append using "$inputdata/WB_data_interpolated/WBdata_all.dta"
}
save "$inputdata/WB_data_interpolated/WBdata_all.dta", replace
local firstiter=1
}

// move from monthly to annual cons
foreach var in average thr topavg bracketavg{
replace `var'=12*`var'
}

// percentile in trackable format
replace p=p*100
gen float p2=1000*round(p,0.001)
drop p
rename p2 p
save "$inputdata/WBdata_pre1983_all.dta", replace
