
clear
cd "$results_interp_1"
foreach var in average p b thr topsh topavg year{
gen `var'=.
}
saveold "$results_interp_1/India_interp_NNI_adults_Siva_gr.dta", replace
*erase India_interp_gpinter.dta
foreach period in 1922/2014 {
forvalues x = `period'{
set more off
capture noisily insheet using "India, `x'.csv", delim(,) clear
capture noisily drop country
capture noisily replace year=`x' 
capture noisily replace b="." if b=="Inf"
capture noisily destring average p thr topsh topavg b, replace
capture noisily egen average2=total(average)
capture noisily replace average=average2
capture noisily drop average2
capture noisily tempfile India_interp_`x'
capture noisily saveold $India_interp_`x'.dta, replace
capture noisily append using "$results_interp_1/India_interp_NNI_adults_Siva_gr.dta", force
capture noisily saveold "$results_interp_1/India_interp_NNI_adults_Siva_gr.dta", replace
}
}

save "$inputdata/revisedtaxdatafinal.dta", replace
  
