 

// Ensure consistency around junction point 


forval year=1951(1)2014{
use "$inputdata/CombinedResults/IndiaInterpTaxSurvey`year'_$strategyA$strategyB$strategyC.dta", clear


foreach n in 1 2 3{ 
levelsof p, local(valuesp)
gsort - p
foreach p in "`varluesp'"{
replace thr_final_`n'=thr_final_`n'[_n-1]-1 if thr_final_`n'>thr_final_`n'[_n-1]
replace bavg_final_`n'=bavg_final_`n'[_n-1]-1 if bavg_final_`n'>bavg_final_`n'[_n-1]
}


//shares
sum bavg_final_`n' [aw=pop]
replace meaninc_`n'=r(mean)
replace groupshare_`n'=bavg_final_`n'*pop/(meaninc_`n')
//topshares
replace topshare_`n'=sum(groupshare_`n')
//topaverage
replace topavg_`n'=(topshare_`n'*meaninc_`n')/((100-(p/1000))/100)
}

save "$inputdata/CombinedResults/IndiaInterpTaxSurvey`year'_$strategyA$strategyB$strategyC.dta", replace
}





// Ensure consistency around junction point 


forval year=1951(1)2014{
use "$inputdata/CombinedResults/IndiaInterpTaxSurvey`year'_$strategyA$strategyB$strategyC.dta", clear


foreach n in 1 2 3{ 
levelsof p, local(valuesp)
gsort - p
foreach p in "`varluesp'"{
replace thr_final_`n'=thr_final_`n'[_n-1]-1 if thr_final_`n'>thr_final_`n'[_n-1]
replace bavg_final_`n'=bavg_final_`n'[_n-1]-1 if bavg_final_`n'>bavg_final_`n'[_n-1]
}


//shares
sum bavg_final_`n' [aw=pop]
replace meaninc_`n'=r(mean)
replace groupshare_`n'=bavg_final_`n'*pop/(meaninc_`n')
//topshares
replace topshare_`n'=sum(groupshare_`n')
//topaverage
replace topavg_`n'=(topshare_`n'*meaninc_`n')/((100-(p/1000))/100)
}

save "$inputdata/CombinedResults/IndiaInterpTaxSurvey`year'_$strategyA$strategyB$strategyC.dta", replace
}




// Combine all ranges together

local firstiter=0
forval year=1951(1)2014{
use "$inputdata/CombinedResults/IndiaInterpTaxSurvey`year'_$strategyA$strategyB$strategyC.dta", clear
if `firstiter'!=0{
append using "$inputdata/CombinedResults/IndiaInterpTaxSurveyall_$strategyA$strategyB$strategyC.dta"
}
save "$inputdata/CombinedResults/IndiaInterpTaxSurveyall_$strategyA$strategyB$strategyC.dta", replace
local firstiter=1
}






// Combine with old series
clear 
use "$inputdata/Old_Series.dta"
replace p=round(p*1000)
rename Banerjee_Piketty BP
rename Revised_final TaxInterp
save "$inputdata/Old_Series_rs.dta", replace
joinby year p using "$inputdata/CombinedResults/IndiaInterpTaxSurveyall_$strategyA$strategyB$strategyC.dta", unmatched(both)
drop _merge
save "$inputdata/CombinedResults/Quasifinal_$strategyA$strategyB$strategyC.dta", replace


// Old series with new income controls

clear
local firstiter=0
local r1 1922/1941
local r2 1943/1945
local r3 1947/1950
foreach var in `r1' `r2' `r3'{
forval x=`var'{
insheet using "$results_interp_1/revised1922-1950/India, `x'.csv", delim(,) clear
replace p=round(p*100000)
drop country
egen average2=mean(average)
replace average=average2
drop average2
egen year2=mean(year)
replace year=year2
drop year2 b
keep if p>=99000
foreach var in average thr topavg bracketavg{ 
rename `var' `var'_NY
}
rename topsh topshare_NY 
save "$results_interp_1/revised1922-1950/prefinaltax`x'.dta", replace
if `firstiter'!=0{
append using "$results_interp_1/revised1922-1950/prefinaltaxall.dta"
save "$results_interp_1/revised1922-1950/prefinaltaxall.dta", replace
}
save "$results_interp_1/revised1922-1950/prefinaltaxall.dta", replace
local firstiter=1
}
}


use "$results_interp_1/revised1922-1950/prefinaltaxall.dta", clear
joinby year p using "$inputdata/CombinedResults/Quasifinal_$strategyA$strategyB$strategyC.dta", unmatched(both)

replace topshare_1=topshare_NY if topshare_1==.
replace topshare_2=topshare_NY if topshare_2==.
replace topshare_3=topshare_NY if topshare_3==.

replace topshare_1=topshare_1*100
replace topshare_2=topshare_2*100
replace topshare_3=topshare_3*100
replace topshare_tax=topshare_tax*100
replace topshare_NY=topshare_NY*100
sort year p

gen bottom_1=100-topshare_1
gen bottom_2=100-topshare_2
gen bottom_3=100-topshare_3




save "$inputdata/RawResults/Final_Current_raw_$strategyA$strategyB$strategyC.dta",replace

// keep only series of interest 


save "$inputdata/RawResults/Final_Current_$strategyA$strategyB$strategyC.dta",replace


