
use "$user/WID_India/Data/Input/SurveyInterpResults/NSS_post1983_income.dta", clear
cd "$user/WID_India/Data/Input/"


joinby year using "deflator_india.dta"
joinby year using "adultpop.dta"
joinby year using  "indiaHFCEmeanuse.dta"

keep if year==2010 | year==1983
replace year=2011 if year==2010
keep if perc==0


drop thr topsh bracketavg perc INRtoEUP
rename average survey
gen total_survey=survey*adult
drop survey
rename y total_HFCE

gen total_survey_2011=total_survey*108.86/13.73
replace total_survey_2011=total_survey if year==2011

gen total_HFCE_2011=total_HFCE*108.86/13.73
replace total_HFCE_2011=total_HFCE if year==2011

rename mnninc999i total_NNI_2011



rename total_survey total_survey_current
rename total_HFCE total_HFCE_current
gen total_NNI_current=total_NNI_2011*inyi

keep total* year


gen aa=total_HFCE_2011 if year==1983
egen total_HFCE_1983=mean(aa)
drop aa
gen aa=total_survey_2011 if year==1983
egen total_survey_1983=mean(aa)
drop aa
gen aa=total_NNI_2011 if year==1983
egen total_NNI_1983=mean(aa)
drop aa




gen aa=total_HFCE_current if year==1983
egen total_HFCE_current_1983=mean(aa)
drop aa
gen aa=total_survey_current if year==1983
egen total_survey_current_1983=mean(aa)
drop aa
gen aa=total_NNI_current if year==1983
egen total_NNI_current_1983=mean(aa)
drop aa


keep if year==2011
gen realgrowth_survey=100*total_survey_2011/total_survey_1983
gen realgrowth_NNI=100*total_NNI_2011/total_NNI_1983
gen realgrowth_HFCE=100*total_HFCE_2011/total_HFCE_1983

gen nominalgrowth_survey=100*total_survey_current/total_survey_current_1983
gen nominalgrowth_NNI=100*total_NNI_current/total_NNI_current_1983
gen nominalgrowth_HFCE=100*total_HFCE_current/total_HFCE_current_1983


label var realgrowth_HFCE "Household Final Consumption growth rate - Nat. Accounts"
label var realgrowth_NNI "Net National Income growth rate - Nat. Accounts"
label var realgrowth_survey "Household total consumption growth rate - NSSO"


graph bar (mean) realgrowth_NNI realgrowth_HFCE realgrowth_survey, graphregion(color(white)) title("Total real growth rate in India, 1983-2011") ///
ylabel(, grid gstyle(dot)) ///
bargap(50) ///
ytitle ("Total growth (%)") ///
yscale(titlegap(*10)) ///
legend(size(vsmall) label (1 "National income (Nat. Accounts)") label (3 "Household consumption (NSSO)") label (2 "Household consumption (Nat. Accounts)") )
graph export "$user/WID_India/Graphs/NSSOvsNAS.png", replace

keep realgrowth_NNI realgrowth_HFCE realgrowth_survey

export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig5-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig5") modify
putexcel (A1)=picture("$user/WID_India/Graphs/NSSOvsNAS.png")

