// GRAPH 4 - Generate number of tax payers

use "$inputdata/NTaxpayers.dta", clear

graph twoway (connected shareReturnsAdults Year, msize(small) ), xtitle (Year) ytitle (Share of total adult population (%)) ///
title("Number of taxpayers in India, 1922-2015")  graphregion(color(white)) legend(size(small)) ///
xscale(range(1920 (10) 2015)) xlabel(1920(10)2015) xtick(1920(10)2015, grid gstyle(dot)) ///
ylabel(, grid gstyle(dot)) ///
yscale(titlegap(*5)) xscale(titlegap(*5)) note("Data from Indian Income Tax Department and WID.world population estimates.", size(1.9))

preserve
keep shareReturnsAdults Year thr
keep if thr==0
drop thr

graph export "$user/WID_India/Graphs/NTaxpayers.png", replace
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig4-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig4") modify
putexcel (A1)=picture("$user/WID_India/Graphs/NTaxpayers.png")
restore
