clear

use "$user/WID_India/Data/Input/Forbes/forbes.dta", clear
cd "$user/WID_India/Data/Input/Forbes/"

collapse (sum) wealth , by(year country)
replace wealth=wealth/1000000000
label variable year "Year"
label variable country "Country"
label variable wealth "Total Wealth reported in Forbes (bn current USD)"
drop if country==""
rename country alpha2

save "forbes_harmonized.dta", replace

use "forbes_harmonized.dta", clear
rename alpha2 country
joinby year country using "inflationNNI.dta"

gen wealth_USD2015=wealth*1000000000/dollar_inflation
gen NNI_USD2015=mnninc999i/LCUtoUSD


gen Forbes_to_NNI=100*(wealth_USD2015/NNI_USD2015)
label variable Forbes_to_NNI "%  National Income"


gen Forbes_to_NNI_1988=Forbes_to_NNI if year==1988
bys country: egen Forbes_to_NNI_1988b=mean(Forbes_to_NNI_1988)
gen FtoNNI_b100_1988=100*(Forbes_to_NNI/Forbes_to_NNI_1988b)

sort country year

label variable FtoNNI_b100_1988 "Forbes wealth to Net Nat. Income (base 100=1988)"

gen wealth_bn=wealth_USD2015/1000000000
label variable wealth_bn "Reported wealth (bn 2015 USD)"


graph twoway (connected Forbes_to_NNI year if country=="IN", msize(small) msymbol(R)), title("Wealth of richest Indians in Forbes List, 1988-2015 ") graphregion(color(white)) xlabel(1990(5)2015) ///
ylabel(, grid gstyle(dot)) xlabel(, grid gstyle(dot)) ///
yscale(titlegap(*5)) xscale(titlegap(*5)) note("Wealth of richest Indians reported in Forbes' rich list. National Income data from WID.world.", size(1.9))

graph export "$user/WID_India/Graphs/Forbes.png", replace

keep Forbes_to_NNI year
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig3-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig3") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Forbes.png")



