use "$user/WID_India/Data/Input/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta", clear

gen gap_explained=100*((meaninc_constant-survey_mean_constant)/((0.7*anninc992i_constant)-survey_mean_constant))
label variable gap_explained "Explained Gap"
 
 

gen p2=p/1000


  graph twoway (connected gap_explained year if year>=1990 , msymbol(S)), graphregion (color(white)) ///
yscale(range(30(10)50)) yscale(range(30(10)50)) ///
ylabel(0(10)50, grid gstyle(dot)) xlabel(1990(5)2015, grid gstyle(dot)) ///
 ytitle("Share of gap explained by missing top incomes (%)") yscale(titlegap(*10)) xscale(titlegap(*5)) ///
 xtitle("")
 

  graph export "$user/WID_India/Graphs/Figure12.png", replace

keep gap_explained year
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Figure12-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Figure12") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Figure12.png")


