use "$user/WID_India/Data/Input/RawResults/Final_Current_$strategyA$strategyB$strategyC.dta",clear

keep year p bavg_tax bavg_survey

gen ratio= bavg_tax/bavg_survey

keep if year==2011


label var bavg_survey "Survey data"
label var bavg_tax "Tax data"
replace bavg_tax=bavg_tax/1000
replace bavg_survey=bavg_survey/1000
gen p2=p/1000

graph twoway (connected bavg_tax bavg_survey p2 if p>=94000 & p<99900), graphregion (color(white)) ytitle (Thousand INR) yscale(titlegap(*5)) ///
xtitle(Percentile) ///
ylabel(, grid gstyle(dot)) xlabel(94(1)99, grid gstyle(dot))  xscale(titlegap(*10)) 

graph export "$user/WID_India/Graphs/Appendix7.png", replace

keep bavg_tax bavg_survey p2 
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix7-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix7") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix7.png")
