use "$user/WID_India/Data/Input/RawResults/Final_Current_$strategyA$strategyB$strategyC.dta",clear


// savings profile
gen savings_1=(meaninc_1-average_cons_survey)/meaninc_1
replace savings_1=savings*100
gen savings_2=(meaninc_survey-average_cons_survey)/meaninc_survey
replace savings_2=savings_2*100
label var savings_1 "Savings (based on tax & surveys)"
label var savings_2 "Savings (based on surveys only)"
keep if p==90000
keep year savings*
save "$pathway/FinalSavings.dta", replace
joinby year using "$inputdata/savingsIN-SNA.dta", unmatched(both)
drop _merge
label var savings_HFCE "Savings (Nat. Accounts)"



keep if year<=2015
keep if year>=1983

graph twoway (connected savings_1 savings_2 savings_HFCE year), graphregion (color(white)) ///
ylabel(, grid gstyle(dot)) xlabel(, grid gstyle(dot)) xtitle("") ///
legend(size(vsmall)) ///
ytitle (% Total income) yscale(titlegap(*10)) xscale(r(1980(10)2015) titlegap(*10)) xlabel(1980(10)2015) xtick(1980(10)2015)


graph export "$user/WID_India/Graphs/Appendix5.png", replace

keep savings_1 savings_2 savings_HFCE year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix5-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix5") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix5.png")

