

//// Summary stats

use "$inputdata/NSS_tab_final_income.dta", clear
drop if year==2010
append using "$inputdata/NSS_post1983_final_income.dta"
save "$inputdata/NSS_allyears_final_income.dta", replace

use "$inputdata/NSS_allyears_final_income.dta",clear
levelsof year, local(years)
foreach var in `years' {
use "$inputdata/NSS_allyears_final_income.dta", clear
disp "`var'"
keep if year==`var'
gsort - perc

//survey stats
sum bracketavg [aw=pop]
gen meaninc_survey=r(mean)
replace meaninc_survey=r(mean)
gen groupshare_survey=bracketavg*pop/(meaninc_survey)
gen topshare_survey=sum(groupshare_survey)
gen top1_survey=topshare_survey if perc==99000
sum top1_survey
replace top1_survey=r(mean)
gen top10_survey=topshare_survey if perc==90000
sum top10_survey
replace top10_survey=r(mean)
gen bot50_survey=topshare_survey if perc==50000
sum bot50_survey
replace bot50_survey=(100-r(mean))

// rescaled survey stats
sum estimated_inc1 [aw=pop]
gen meaninc_1=r(mean)
gen meaninc1_survey=r(mean)
gen groupshare_1=(estimated_inc1*pop)/((meaninc_1))
gen topshare_1=sum(groupshare_1)
gen top1_1=topshare_1 if perc==99000
sum top1_1
replace top1_1=r(mean)
gen top10_1=topshare_1 if perc==90000
sum top10_1
replace top10_1=r(mean)
gen bot50_1=topshare_1 if perc==50000
sum bot50_1
replace bot50_1=(100-r(mean))

sum estimated_inc2 [aw=pop]
gen meaninc_2=r(mean)
gen meaninc2_survey=r(mean)
gen groupshare_2=(estimated_inc2*pop)/((meaninc_2))
gen topshare_2=sum(groupshare_2)
gen top1_2=topshare_2 if perc==99000
sum top1_2
replace top1_2=r(mean)
gen top10_2=topshare_2 if perc==90000
sum top10_2
replace top10_2=r(mean)
gen bot50_2=topshare_2 if perc==50000
sum bot50_2
replace bot50_2=(100-r(mean))



sum estimated_inc3 [aw=pop]
gen meaninc_3=r(mean)
gen meaninc3_survey=r(mean)
gen groupshare_3=(estimated_inc3*pop)/((meaninc_3))
gen topshare_3=sum(groupshare_3)
gen top1_3=topshare_3 if perc==99000
sum top1_3
replace top1_3=r(mean)
gen top10_3=topshare_3 if perc==90000
sum top10_3
replace top10_3=r(mean)
gen bot50_3=topshare_3 if perc==50000
sum bot50_3
replace bot50_3=(100-r(mean))


// further sumstats survey
ineqdeco bracketavg [aw=pop]
gen ginisurvey=r(gini)
gen r9010survey=r(p90p10)

// further sumstats method1
ineqdeco estimated_inc1 [aw=pop]
gen ginisurveyscaled1=r(gini)
gen r9010surveyscaled1=r(p90p10)

// further sumstats method2
ineqdeco estimated_inc2 [aw=pop]
gen ginisurveyscaled2=r(gini)
gen r9010surveyscaled2=r(p90p10)

// further sumstats method3
ineqdeco estimated_inc3 [aw=pop]
gen ginisurveyscaled3=r(gini)
gen r9010surveyscaled3=r(p90p10)


keep if _n==1
keep ginisurvey r9010survey ginisurveyscaled1 r9010surveyscaled1 ginisurveyscaled2 ginisurveyscaled3 r9010surveyscaled2 r9010surveyscaled3 meaninc_survey meaninc1_survey meaninc3_survey meaninc2_survey year
save "$inputdata/SumStats/NSS_SStats`var'.dta", replace
}



local firstiter=0
use "$inputdata/NSS_allyears_final_income.dta",clear
levelsof year, local(years)
foreach var in `years'{
use "$inputdata/SumStats/NSS_SStats`var'.dta", clear
if `firstiter'!=0{
append using "$inputdata/SumStats/NSS_SStats_all.dta"
}
save "$inputdata/SumStats/NSS_SStats_all.dta", replace
local firstiter=1
}





foreach var in meaninc_survey meaninc1_survey meaninc2_survey meaninc3_survey{
replace `var'=round(`var',0.1)
}

foreach var in ginisurvey ginisurveyscaled1 ginisurveyscaled2 ginisurveyscaled3{
replace `var'=round(`var',0.001)
}

foreach var in r9010survey r9010surveyscaled1 r9010surveyscaled2 r9010surveyscaled3{
replace `var'=round(`var',0.01)
}



gen savings1=(meaninc1_survey/meaninc_survey)
gen savings2=(meaninc2_survey/meaninc_survey)
gen savings3=(meaninc3_survey/meaninc_survey)


label var meaninc_survey "Mean consumption - survey"
label var meaninc1_survey "Mean income - strategy A1"
label var meaninc2_survey "Mean income - strategy A2"
label var meaninc3_survey "Mean income - strategy A0"

label var ginisurvey "Gini consumption - survey"
label var ginisurveyscaled1 "Gini income - strategy A1"
label var ginisurveyscaled2 "Gini income - strategy A2"
label var ginisurveyscaled3 "Gini income - strategy A0"

label var r9010survey "p90/p10 ratio consumption - survey"
label var r9010surveyscaled1 "p90/p10 ratio income - strategy A1"
label var r9010surveyscaled2 "p90/p10 ratio income - strategy A2"
label var r9010surveyscaled3 "p90/p10 ratio income - strategy A0"

order year mean* gini* r9010*

sort year
drop savings*

export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix3-data") sheetmodify firstrow(varl)
