
* Table 3 : Sum stats for 2014-15

import delimited "$outputdata/India_benchmark_19222014_constant.csv", delim(";") clear
joinby year using "$inputdata/adultpop.dta"

keep if year==2014

replace npopul992i=adult
drop adult


keep if p==0 | p==1000 | p==50000 | p== 90000 | p==99000 | p==99900  | p==99990 | p==99999
replace sptinc992j=sptinc992j[_n]-sptinc992[_n+1] if p==50000
replace sptinc992j=100-sptinc992j[_n+1]-sptinc992[_n+2] if p==1000

replace p=60000 if p==50000
replace p=50000 if p==1000
gen avginc=sptinc/100*anninc992i/(1-(p/100000))

drop in* ann* mnn*

replace npopul992i=round(npopul992i*(1-(p/100000)),1)
replace sptinc=100 if p==0
gen ratio=avginc/avginc[1]
gen group=""
replace group="Average" if p==0
replace group="Bottom 50%" if p==50000
replace group="Middle 40%" if p==60000
replace group="Top 10%" if p==90000
replace group="Top 1%" if p==99000
replace group="Top 0.1%" if p==99900
replace group="Top 0.01%" if p==99990
replace group="Top 0.001%" if p==99999
drop p year
order group npopul
drop aptinc*

export excel using "$user/WID_India/tables/Tables.xlsx", sheet("Table3-data") sheetmodify firstrow(varl)


