foreach year in 1983 1988 1994 2000 2005 2010 {
insheet using "$SurveyInterpResults/India, `year'.csv", delim(,)  clear
egen year2=mean(year)
replace year=year2
drop year2
drop country 
egen average2=max(average)
replace average=average2
drop average2
rename p perc
replace perc=perc*100
gen double perc2=round(perc*1000)
drop perc
rename perc2 perc
save "$SurveyInterpResults/NSS_post1983_`year'.dta", replace
}

local firstiter=0
foreach year in 1983 1988 1994 2000 2005 2010{
use "$SurveyInterpResults/NSS_post1983_`year'.dta", clear
drop b
if `firstiter'!=0{
append using "$SurveyInterpResults/NSS_post1983_income.dta"
}
save "$SurveyInterpResults/NSS_post1983_income.dta", replace
local firstiter=1
}


// RESCALE

joinby perc using "$inputdata/percfactor.dta", unmatched (both)
drop _merge


gen percfactor_int=percfactor1 if perc==99000
egen percfactor_int2=max(percfactor_int)
replace percfactor1=percfactor_int2 if perc>99000
drop percfactor_int percfactor_int2

gen percfactor2_int=percfactor2 if perc==99000
egen percfactor2_int2=max(percfactor2_int)
replace percfactor2=percfactor2_int2 if perc>99000
drop percfactor2_int percfactor2_int2

gen percfactor3_int=percfactor3 if perc==99000
egen percfactor3_int2=max(percfactor3_int)
replace percfactor3=percfactor3_int2 if perc>99000
drop percfactor3_int percfactor3_int2
 
gen estimated_inc1=bracketavg*percfactor1
gen estimated_inc2=bracketavg*percfactor2
gen estimated_inc3=bracketavg*percfactor3

gen estimated_thr1=thr*percfactor1
gen estimated_thr2=thr*percfactor2
gen estimated_thr3=thr*percfactor3

gen pop=1 if perc<99000
replace pop=0.1 if perc>=99000 & perc<99900
replace pop=0.01 if perc>=99900 & perc<99990
replace pop=0.001 if perc>=99990
gen groupinc_1=estimated_inc1*pop
gen groupinc_2=estimated_inc2*pop
gen groupinc_3=estimated_inc3*pop


bysort year: egen SurveyIncome1=total(groupinc_1)
replace SurveyIncome1=SurveyIncome1/100
bysort year: egen SurveyIncome2=total(groupinc_2)
replace SurveyIncome2=SurveyIncome2/100
bysort year: egen SurveyIncome3=total(groupinc_3)
replace SurveyIncome3=SurveyIncome3/100
drop groupinc*

sort year perc

save "$inputdata/NSS_post1983_final_income.dta", replace
