use "$user/WID_India/Data/Input/WIID/WIID_India_sub.dta", clear
drop if Source=="Sudipto Mundle, NSSO 68th Round"


graph twoway (connected Q5 Year, msize(small) msymbol(R)), title("Top 20% share in total consumption in India, 1951-2011") graphregion(color(white)) xlabel(1950(10)2015) ///
ylabel(, grid gstyle(dot)) xlabel(, grid gstyle(dot)) ///
ytitle (% Total consumption) ///
yscale(titlegap(*5)) xscale(titlegap(*5)) note("Data from United Nations WIDER World Income Inequality Database and World Bank India Database.", size(1.9))

graph export "$user/WID_India/Graphs/Fig2.png", replace

preserve
keep Q5 Year
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig2-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Fig2") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Fig2.png")
restore
