
use "$outputdata/GIC/gic-india-1980-2014.dta", clear
rename growth growth8014

drop if p<2000

// ---------------------------------------- GRAPH

				replace p=p/1000
				
				sort p			
gen p2=_n
sort p
				drop if p<5
				

local tick 10 20 30 40 50 60 70 80 90 99 108 117 125
local lab  125 "99.999" 117 "99.99" 108 "99.9" 99 "99" 90 "90" 80 "80" 70 "70" 60 "60" 50 "50" ///
		40 "40" 30 "30" 20 "20" 10 "10"
graph twoway (connected growth8014 p2 if p>=5,  msize(small) ), ///
ylabel(, grid gstyle(dot) labsize(small)) ///
ytitle("Total growth rate (%) ") ///
graphregion(color(white)) bgcolor(white)   ///
xtitle("Income group (percentile)", height(1) alignment(middle)) ///
xtick(`tick') ///
xlab(`lab', labsize(small) grid gstyle(dot)) ///
xline(`tick', lpattern(dot) lcol(grey)) ///
xscale(titlegap(*12)) yscale(titlegap(*12)) 

/////////

graph export "$user/WID_India/Graphs/Figure11-gic19802015.png", replace

keep growth8014 p2 
export excel using "$user/WID_India/Graphs/Graphs.xlsx", sheet("Figure11-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs.xlsx", sheet("Figure11") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Figure11-gic19802015.png")


