
use "$user/WID_India/Data/Input/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta", clear

disp "$strategyA$strategyB$strategyC$strategyD"

keep if p==1000
//keep meaninc_constant anninc992i_constant survey_mean_constant p year


//gen newanninc=(anninc992i_constant[_n+1]+anninc992i_constant)/2


gen ratio_fiscal_NA=100*(meaninc_constant/anninc992i_constant)
gen ratio_survey_NA=100*(survey_mean_constant/anninc992i_constant)
//gen ratio_fiscal_NA2=100*(meaninc_1/anninc992i_current)
label var ratio_survey_NA "Total income from household surveys"
label var ratio_fiscal_NA "Total income from surveys & tax data combined"

 graph twoway (connected ratio_survey_NA ratio_fiscal_NA year if year>=1990 , msymbol(S)), graphregion (color(white)) ///
yscale(range(30(10)50)) yscale(range(30(10)50)) ///
ylabel(30 "30" 40 "40" 50 "50", grid gstyle(dot)) xlabel(1990(5)2015, grid gstyle(dot)) ///
 ytitle(% National income) yscale(titlegap(*10)) xscale(titlegap(*5)) ///
 legend(size(vsmall)) ///
 xtitle("")
 
 graph export "$user/WID_India/Graphs/Appendix8.png", replace

keep ratio_survey_NA ratio_fiscal_NA year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix8-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix8") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix8.png")


