
// Graph over all loops

local firstiter=0
foreach varA in 0 1 2 {
global strategyA A`varA'

foreach varB in 1 2 {
global strategyB B`varB'

foreach varC in 1 2 3 {
global strategyC C`varC'

foreach varD in 1 2 3 {
global strategyD D`varD'


use "$inputdata/RawResults/Final_constant_$strategyA$strategyB$strategyC$strategyD.dta", clear
keep year p bottom_$strategyA$strategyB$strategyC$strategyD topshare_$strategyA$strategyB$strategyC$strategyD
gen abottom50_$strategyA$strategyB$strategyC$strategyD=bottom_$strategyA$strategyB$strategyC$strategyD if p==50000
bys year: egen bottom50_$strategyA$strategyB$strategyC$strategyD=mean(abottom50_$strategyA$strategyB$strategyC$strategyD)
drop abottom50_$strategyA$strategyB$strategyC$strategyD
gen atopshare10_$strategyA$strategyB$strategyC$strategyD=topshare_$strategyA$strategyB$strategyC$strategyD if p==90000
bys year: egen topshare10_$strategyA$strategyB$strategyC$strategyD=mean(atopshare10_$strategyA$strategyB$strategyC$strategyD)
drop atopshare10_$strategyA$strategyB$strategyC$strategyD
gen middle40_$strategyA$strategyB$strategyC$strategyD=100-(bottom50_$strategyA$strategyB$strategyC$strategyD+topshare10_$strategyA$strategyB$strategyC$strategyD)

drop topshare10_ bottom50_

if `firstiter'!=0{
joinby p year using "$inputdata/RawResults/Final_constant_allstrategies.dta"
}
save "$inputdata/RawResults/Final_constant_allstrategies.dta", replace
local firstiter=1
}
}
}
}

// ALL scenarios

use "$inputdata/RawResults/Final_constant_allstrategies.dta", clear


graph twoway (line topshare* year if p==99000) (line topshare_A0B1C1D1 year if p==99000, lwidth(thick) lcolor(red)), graphregion (color(white)) ytitle (% of National Income) yscale(titlegap(*5)) ///
xtitle("")  ///
ylabel(, grid gstyle(dot)) xlabel(1920(10)2010, grid gstyle(dot)) ///
legend (off)

graph export "$user/WID_India/Graphs/Appendix13a.png", replace

keep if p==99000
keep topshare* year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix13a-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix13a") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix13a.png")


use "$inputdata/RawResults/Final_constant_allstrategies.dta", clear

graph twoway (line topshare* year if p==99900) (line topshare_A0B1C1D1 year if p==99900, lwidth(thick) lcolor(red)), graphregion (color(white)) ytitle (% of National Income) yscale(titlegap(*5)) ///
xtitle("")  ///
ylabel(, grid gstyle(dot)) xlabel(1920(10)2010, grid gstyle(dot)) ///
legend (off)

graph export "$user/WID_India/Graphs/Appendix13b.png", replace

keep if p==99900
keep topshare* year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix13b-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix13b") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix13b.png")



use "$inputdata/RawResults/Final_constant_allstrategies.dta", clear


graph twoway (line topshare* year if p==99990) (line topshare_A0B1C1D1 year if p==99990, lwidth(thick) lcolor(red)), graphregion (color(white)) ytitle (% of National Income) yscale(titlegap(*5)) ///
xtitle("")  ///
ylabel(, grid gstyle(dot)) xlabel(1920(10)2010, grid gstyle(dot)) ///
legend (off)

graph export "$user/WID_India/Graphs/Appendix13c.png", replace

keep if p==99990
keep topshare* year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix13c-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix13c") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix13c.png")



use "$inputdata/RawResults/Final_constant_allstrategies.dta", clear


graph twoway (line topshare* year if p==90000) (line topshare_A0B1C1D1 year if p==90000, lwidth(thick) lcolor(red)), graphregion (color(white)) ytitle (% of National Income) yscale(titlegap(*5)) ///
xtitle("")  ///
ylabel(, grid gstyle(dot)) xlabel(1950(10)2010, grid gstyle(dot)) ///
legend (off)

graph export "$user/WID_India/Graphs/Appendix14a.png", replace

keep if p==90000
keep topshare* year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix14a-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix14a") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix14a.png")



use "$inputdata/RawResults/Final_constant_allstrategies.dta", clear

graph twoway (line bottom* year if p==50000, msymbol(S) msize(small) ) (line bottom_A0B1C1D1 year if p==50000, lwidth(thick) lcolor(red)), graphregion (color(white))  ytitle (% of National Income) yscale(titlegap(*5)) ///
xtitle("")  ///
ylabel(5 "5" 10 "10" 15 "15" 20 "20" 25 "25" 30 "30" 35 "35", grid gstyle(dot)) xlabel(1950(10)2010, grid gstyle(dot)) ///
yscale(r(5(5)35)) legend (off)

graph export "$user/WID_India/Graphs/Appendix14b.png", replace

keep if p==50000
keep bottom* year 
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix14b-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix14b") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix14b.png")



use "$inputdata/RawResults/Final_constant_allstrategies.dta", clear

graph twoway (line middle* year if p==90000, msymbol(S) msize(small) ) (line middle40_A0B1C1D1 year if p==90000, lwidth(thick) lcolor(red)), graphregion (color(white)) ytitle (% of National Income) yscale(titlegap(*5)) ///
xtitle("")  ///
ylabel(, grid gstyle(dot)) xlabel(1950(10)2010, grid gstyle(dot)) ///
legend (off)
graph export "$user/WID_India/Graphs/Appendix14c.png", replace

keep if p==90000
keep middle* year
export excel using "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix14c-data") sheetmodify firstrow(varl)
putexcel set "$user/WID_India/Graphs/Graphs_Appendix.xlsx", sheet("Appendix14c") modify
putexcel (A1)=picture("$user/WID_India/Graphs/Appendix14c.png")

