/*******Stata code to generate the Lebanese wealth distribution corrected at the top with billionaires data *****/

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth" 
 

/**** Step 1: Importing WID.world normalized USCHFR distributions and excluding the top 1%****/ 


foreach country in Lebanon{ 
forval year=1995/2016{  
clear 

import excel "Input/WealthTabulationsWIDworld.xlsx", sheet("`year'") firstrow
drop if p>0.99 
replace year=`year' if p==0  
replace country="`country'" if p==0  
replace component="wealth" if p==0 
replace average=topavg if p==0 

export excel using "Input/WealthTabulationsCorrected`country'.xlsx", sheet("`year'") sheetreplace firstrow(variables) 
clear 
}
}


foreach country in Lebanon{ 
forval year=1995/2016{ 

foreach nadult in 2 4 6 8{ 

clear 

import excel "Input/WealthTabulationsWIDworld.xlsx", sheet("`year'") firstrow
drop if p>0.99 


replace year=`nadult'`year' if p==0  
replace country="`country'" if p==0  
replace component="wealth" if p==0 
replace average=topavg if p==0 

export excel using "Input/WealthTabulationsCorrectedVariants1`country'.xlsx", sheet("`nadult'`year'") sheetreplace firstrow(variables) 
clear 

}

foreach linear in 0 20 40 60 80 100{ 

clear 
import excel "Input/WealthTabulationsWIDworld.xlsx", sheet("`year'") firstrow
drop if p>0.99 


replace year=`linear'`year' if p==0  
replace country="`country'" if p==0  
replace component="wealth" if p==0 
replace average=topavg if p==0 
export excel using "Input/WealthTabulationsCorrectedVariants2`country'.xlsx", sheet("`linear'`year'") sheetreplace firstrow(variables) 
clear 
} 
} 
}


/****Step 2: importing billionnaire parameters*/

clear 
 import excel "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017Appendix.xlsx", sheet("DataWealthInequality") cellrange(A8:O35) firstrow clear

rename year year2 
gen bbill=(tbill/nbill)/thrbill 
keep year2 nbill tbill thrbill bbill wdol wlcu n 

save WealthParametersLebanon.dta, replace 


/****Step 3: benchmark corrections with nadult=5 and linear profile*/

foreach country in Lebanon{ 
forval year=1995/2016{ 
foreach nadult in 5 { 

clear 

import excel "Output/WealthTopSeriesWIDworld.xlsx", sheet("wealth, USCHFR, `year'") firstrow clear
drop topsh 
drop if p<0.9 & (p~=0 & p~=0.1 & p~=0.2 & p~=0.3 & p~=0.4 & p~=0.5 & p~=0.6 & p~=0.7 & p~=0.8 & p~=0.9) 

append using WealthParameters`country'.dta 

keep if year2==. | year2==`year' 
replace p=1-`nadult'*nbill/((n/100)) if year2==`year' 
replace thr=(thrbill*1000000000/`nadult')/wdol if year2==`year' 
replace b=bbill if year2==`year' 
replace bracketavg=b*thr if year2==`year' 
replace topavg=b*thr if year2==`year' 
gen pbill0=1-`nadult'*nbill/((n/100))
egen pbill=max(pbill0) 
drop if p==. 
sort p 
gen ratio=thr/(((p[_n+1]-p)*thr[_n-1]+(p-p[_n-1])*thr[_n+1])/(p[_n+1]-p[_n-1])) if year2==`year' 
replace ratio=thr/thr[_n-1] if year2==`year' & ratio==. 
replace ratio=1 if year2==`year' & nbill==0 
drop if p>pbill & year2==. 
egen dratio=max(ratio) 
replace dratio=dratio-1 
egen np=count(p) 
replace ratio=1 if _n==1 
replace ratio=ratio[_n-1]+dratio/np if _n>1 
replace thr=thr*ratio if year2==. 
replace bracketavg=bracketavg*(ratio+ratio[_n+1])/2 if year2==. 
replace bracketavg=((p[_n+1]-p)*bracketavg+(1-p[_n+1])*bracketavg[_n+1])/(1-p) if _n==np-1 & pbill<1 
drop if _n==np 
keep p thr bracketavg 
replace p=0.99+p/100 


export excel using "Input/WealthTabulationsCorrected`country'.xlsx", sheet("`year'", modify) cell(E101) 

clear  

import excel using "Input/WealthTabulationsCorrected`country'.xlsx", sheet("`year'") firstrow 

gsort -p 
replace topavg=bracketavg if _n==1 
replace topavg=((p[_n-1]-p)*bracketavg+(1-p[_n-1])*topavg[_n-1])/(1-p) if _n>1 
replace b=topavg/thr 
drop if p>0.99999 
replace bracketavg=topavg if _n==1 
sort p 
replace average=topavg if _n==1 
replace country="`country'" if _n==1 

export excel using "Input/WealthTabulationsCorrected`country'.xlsx", sheet("`year'", replace) firstrow(variables)  
} 
} 
}


*/

foreach country in Lebanon{ 
forval year=1995/2016{  
clear
import excel "Input/WealthTabulationsCorrected`country'.xlsx", sheet("`year'") firstrow
drop topavg b
gen topavg=.
replace topavg=bracketavg if _n==_N
	local m = _N-1
	forval k=`m'(-1)1{
	replace topavg= ((1-p[`k'+1])*topavg[`k'+1] + (p[`k'+1]-p[`k'])*bracketavg[`k'])/(1-p[`k']) if _n== `k'
	 }
	 
replace average=topavg[1]

export excel using "Input/WealthTabulationsCorrected`country'.xlsx", sheet("`year'", replace) firstrow(variables)  
}
}


 /****Step 4: variant corrections with nadult=2,4,6,8 and linear profile*/
 
foreach country in Lebanon{ 
forval year=1995/2016{ 

foreach nadult in 2 4 6 8{ 

clear 
import excel "Output/WealthTopSeriesWIDworld.xlsx", sheet("wealth, USCHFR, `year'") firstrow 
drop topsh 
drop if p<0.9 & (p~=0 & p~=0.1 & p~=0.2 & p~=0.3 & p~=0.4 & p~=0.5 & p~=0.6 & p~=0.7 & p~=0.8 & p~=0.9) 

append using WealthParameters`country'.dta 

keep if year2==. | year2==`year' 
replace p=1-`nadult'*nbill/((n/100)) if year2==`year' 
replace thr=(1000000000/`nadult')/wdol if year2==`year' 
replace b=tbill/nbill if year2==`year' 
replace bracketavg=b*thr if year2==`year' 
replace topavg=b*thr if year2==`year' 
gen pbill0=1-`nadult'*nbill/((n/100)) 
egen pbill=max(pbill0) 
drop if p==. 
sort p 
gen ratio=thr/(((p[_n+1]-p)*thr[_n-1]+(p-p[_n-1])*thr[_n+1])/(p[_n+1]-p[_n-1])) if year2==`year' 
replace ratio=thr/thr[_n-1] if year2==`year' & ratio==. 
replace ratio=1 if year2==`year' & nbill==0 
drop if p>pbill & year2==. 
egen dratio=max(ratio) 
replace dratio=dratio-1 
egen np=count(p) 
replace ratio=1 if _n==1 
replace ratio=ratio[_n-1]+dratio/np if _n>1 
replace thr=thr*ratio if year2==. 
replace bracketavg=bracketavg*(ratio+ratio[_n+1])/2 if year2==. 
replace bracketavg=((p[_n+1]-p)*bracketavg+(1-p[_n+1])*bracketavg[_n+1])/(1-p) if _n==np-1 & pbill<1 
drop if _n==np 
keep p thr bracketavg 
replace p=0.99+p/100 

export excel using "Input/WealthTabulationsCorrectedVariants1`country'.xlsx", sheet("`nadult'`year'", modify) cell(E101) 

clear  

import excel using "Input/WealthTabulationsCorrectedVariants1`country'.xlsx", sheet("`nadult'`year'") firstrow 

gsort -p 
replace topavg=bracketavg if _n==1 
replace topavg=((p[_n-1]-p)*bracketavg+(1-p[_n-1])*topavg[_n-1])/(1-p) if _n>1 
replace b=topavg/thr 
drop if p>0.99999 
replace bracketavg=topavg if _n==1 
sort p 
replace average=topavg if _n==1 
replace country="`country'" if _n==1 
replace year=`nadult'`year' if _n==1 

export excel using "Input/WealthTabulationsCorrectedVariants1`country'.xlsx", sheet("`nadult'`year'", replace) firstrow(variables) 

} 
} 
}


/****Step 5: variant corrections with nadult=5 and piecewise-linear profile*/

/****linear=20 means 20% of correction factor adjustement achieved at P99.9****/

foreach country in Lebanon{ 
forval year=1995/2016{ 
foreach nadult in 5{ 
foreach linear in 0 20 40 60 80 100{ 

clear 

import excel "Output/WealthTopSeriesWIDworld.xlsx", sheet("wealth, USCHFR, `year'") firstrow 

drop topsh 
drop if p<0.9 & (p~=0 & p~=0.1 & p~=0.2 & p~=0.3 & p~=0.4 & p~=0.5 & p~=0.6 & p~=0.7 & p~=0.8 & p~=0.9) 

append using WealthParameters`country'.dta 

keep if year2==. | year2==`year' 
replace p=1-`nadult'*nbill/((n/100)) if year2==`year' 
replace thr=(1000000000/`nadult')/wdol if year2==`year' 
replace b=tbill/nbill if year2==`year' 
replace bracketavg=b*thr if year2==`year' 
replace topavg=b*thr if year2==`year' 
gen pbill0=1-`nadult'*nbill/((n/100))
egen pbill=max(pbill0) 
drop if p==. 
sort p 
gen ratio=thr/(((p[_n+1]-p)*thr[_n-1]+(p-p[_n-1])*thr[_n+1])/(p[_n+1]-p[_n-1])) if year2==`year' 
replace ratio=thr/thr[_n-1] if year2==`year' & ratio==. 
replace ratio=1 if year2==`year' & nbill==0 
drop if p>pbill & year2==. 
egen dratio=max(ratio) 
replace dratio=dratio-1 
gen dratio1=`linear'*dratio/100 
gen dratio2=dratio-dratio1 
egen np=count(p) 
replace ratio=1 if _n==1 
replace ratio=ratio[_n-1]+dratio1/10 if _n>1 & _n<=10 
replace ratio=ratio[_n-1]+dratio2/(np-10) if _n>10 
replace thr=thr*ratio if year2==. 
replace bracketavg=bracketavg*(ratio+ratio[_n+1])/2 if year2==. 
replace bracketavg=((p[_n+1]-p)*bracketavg+(1-p[_n+1])*bracketavg[_n+1])/(1-p) if _n==np-1 & pbill<1 
drop if _n==np 
keep p thr bracketavg 
replace p=0.99+p/100 

export excel using "Input/WealthTabulationsCorrectedVariants2`country'.xlsx", sheet("`linear'`year'", modify) cell(E101) 

clear  

import excel using "Input/WealthTabulationsCorrectedVariants2`country'.xlsx", sheet("`linear'`year'") firstrow 

gsort -p 
replace topavg=bracketavg if _n==1 
replace topavg=((p[_n-1]-p)*bracketavg+(1-p[_n-1])*topavg[_n-1])/(1-p) if _n>1 
replace b=topavg/thr 
drop if p>0.99999 
replace bracketavg=topavg if _n==1 
sort p 
replace average=topavg if _n==1 
replace country="`country'" if _n==1 
replace year=`linear'`year' if _n==1 

export excel using "Input/WealthTabulationsCorrectedVariants2`country'.xlsx", sheet("`linear'`year'", replace) firstrow(variables) 
} 
} 
} 
}
*/
 
/****Step 6: apply gpinter to input file WealthTabulationsCorrected.xlsx 
and WealthTabulationsCorrectedVariants1 and 2.xlsx for all countries
to obtain output file WealthSeriesCorrected.xlsx and WealthSeriesCorrectedVariants1 and 2.xlsx */











