clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome" 
 
******************************************************************************** 
************************ VARIANTS DEFINITION OF INCOME  ************************ 
******************************************************************************** 
 
  
* Step 1: Computing the fiscal correction coefficients for the top 1 for each year  

global variants 0.6 0.7 0.9

foreach v of global variants{
forval j=2005/2014{
clear
import excel "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/FiscalData/Results/FiscalSeriesDef`v'.xlsx", sheet("`j'") firstrow clear
destring _all, replace
keep in 11
rename thresh thr
save `j'_`v'.dta, replace 
 }
 }
 
 foreach v of global variants{
use 2005_`v'.dta
forval j=2006/2014{
append using `j'_`v'.dta
}
save upfactors99`v'.dta, replace
}
  
forval j=2005/2014{
clear
 import excel "Output/SurveySeries/OutputSurveyOnly.xlsx", sheet("Lebanon, `j'") firstrow
destring _all, replace
drop year country average 
gen year=`j'
keep in 100

foreach x of varlist thr bracketavg topavg b{
rename `x' `x'_
}
save `j'.dta, replace 
}


 foreach v of global variants{

use 2005.dta
forval j=2006/2014{
append using `j'.dta
}

merge m:m year using upfactors99`v'.dta, nogenerate
foreach x of varlist thr bracketavg topavg b{
gen coeff`x'= `x'/`x'_
}
keep year p coeff* b
order year p coeff* b

foreach x of varlist coeff* b{

sum `x'
gen mean`x'=r(mean)
}

save upfactors99`v'.dta, replace

export excel using "CompCorrectionCoeffLebVariantsDef.xlsx", sheet("upfactors99`v'") firstrow(variables) sheetreplace
 }

forval j=2005/2014{
erase `j'.dta
}


 foreach v of global variants{
forval j=2005/2014{
erase `j'_`v'.dta
}
erase upfactors99`v'.dta
}

* Step 2: Importing the survey data for the bottom 0.99 of the population* 

 
forval j=2005/2014{
clear
 import excel "Output/SurveySeries/OutputSurveyOnly.xlsx", sheet("Lebanon, `j'") firstrow
destring _all, replace
replace year=`j'
replace p=0.82 in 83
replace p=0.83 in 84
replace p=0.94 in 95
replace p=0.95 in 96


keep if p<=0.99
replace bracketavg=topavg in 100
drop topavg
save survey`j'.dta, replace
}

*********************************************************************************
/*Step 3: creating a Stata database for the Correction coefficients. The profile 
chosen must be specified direcly in the excel file "CompCorrectionCoeffLeb.xlsx, sheet "CompUpFactorLeb"*/
*********************************************************************************


* Step 4: Applying the coefficients to the survey data, between p=0.8 and p=0.99 *

 
clear 
 foreach v of global variants{
forval j=2005/2014{
import excel "CompCorrectionCoeffLebVariantsDef.xlsx", sheet("Stata`v'") firstrow clear

keep p *`j'
gen year=`j'
order year p coeff*
save corrcoeff`j'`v'.dta, replace
}
}

clear all
 foreach v of global variants{
forval j=2005/2014{
use survey`j'.dta
merge m:1 p using corrcoeff`j'`v'.dta, nogenerate
rename coeffavg coeffbracketavg
drop b

foreach x of varlist thr bracketavg{
gen `x'_=`x'*coeff`x'
replace `x'=`x'_ if `x'_!=.
}

keep year country average p thr bracketavg
drop if _n>100

gen topavg=bracketavg[100]
forval k=99(-1)1{
replace topavg= ((1-p[`k'+1])*topavg[`k'+1] + (p[`k'+1]-p[`k'])*bracketavg[`k'])/(1-p[`k']) if _n== `k'
 }
replace average=topavg[1]
drop top*

export excel using "Input/FiscalSeries/Variants/InputFiscalDef`v'.xlsx", sheet("`j'") sheetreplace firstrow(variables)
erase corrcoeff`j'`v'.dta
 clear all
}
}

forval j=2005/2014{
erase survey`j'.dta
}


* Step 5: Normalizing the distribution to national income (Euro 2016 PPP)

global price PPP

*2005-2014
foreach p of global price{
 foreach v of global variants{

 forval j=2005/2014{
import excel "Input/FiscalSeries/Variants/InputFiscalDef`v'.xlsx", sheet("`j'") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using "LebanonIncomeParameters.dta"
drop if _merge!=3
drop _merge
foreach x of varlist average thr bracketavg{
gen `x'_=factorprice`p'*`x'*factor
drop `x'
rename `x'_ `x'
}
drop factor* 

keep year country average p thr br* 
order year country average p thr br* 
export excel using "Input/FiscalSeries/Variants/`p'/RawSeries/Lebanon`p'corrDef`v'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
}
}
}


* Step 6: Normalizing to national accounts

clear
 
foreach p of global price{
 foreach v of global variants{
forval j=2005/2014{
 clear  

import excel  "Input/FiscalSeries/Variants/`p'/RawSeries/Lebanon`p'corrDef`v'.xlsx", sheet("Lebanon, `j'") firstrow clear

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg popsizeLebanon Lebanon`p'
rename pop popsize
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_ popsize
order year country average_ p thr_ bracketavg_ popsize

rename average_ average 
rename thr_ thr
rename bracketavg_ bracketavg 
export excel using "Input/FiscalSeries/Variants/`p'/NormalizedSeries/Lebanon`p'corrnormDef`v'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

}
}
}
