* Code Generating the final series (after the fiscal and the missing capital income corrections) *

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome" 

 global price PPP

********************************************************************************* 
*************** VARIANTS SURVEY DATA: SURVEY YEARS 2004-2007 *************** 
********************************************************************************* 




 
forval j=2005/2014{
foreach p of global price{
clear
import excel  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth/Output/WealthSeriesLebanonCorrected.xlsx", sheet("wealth, Lebanon, 2016") firstrow clear

destring _all, replace
replace year=`j'
 
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
 
keep year country average p thr bracketavg Lebanon`p'missv3  
foreach x of varlist average thr bracketavg{
replace `x'=`x'*Lebanon`p'missv3 
}
drop Lebanon*
gen component="ynf"
drop if year!=`j'

export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'20042007.xlsx", sheet("Lebanon, ynf, `j'") sheetreplace firstrow(variables)
clear

import excel "Input/FiscalSeries/Variants/`p'/RawSeries/Lebanon`p'corr20042007.xlsx", sheet("Lebanon, `j'") firstrow clear
gen component="yf"
export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'20042007.xlsx", sheet("Lebanon, yf, `j'") sheetreplace firstrow(variables)
}
}



************************************************
* Apply Gpinter, with the add-up component option 
************************************************

* Normalization to national income

clear
 
foreach p of global price{
forval j=2005/2014{
foreach g in 3{
clear
import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/Variants/LebanonFinal`p'20042007.xlsx", sheet("Lebanon, `j'") firstrow

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/Variants/LebanonFinal`p'norm20042007.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}


********************************************************************************* 
********************* VARIANTS SURVEY DATA: IPC LAST BRACKET ******************** 
********************************************************************************* 
/*

global IPC 1 3
forval j=2005/2014{
foreach p of global price{
foreach ipc of global IPC{

clear
import excel  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth/Output/WealthSeriesLebanonCorrected.xlsx", sheet("wealth, Lebanon, 2016") firstrow clear

destring _all, replace
replace year=`j'
 
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
 
keep year country average p thr bracketavg Lebanon`p'missv3  
foreach x of varlist average thr bracketavg{
replace `x'=`x'*Lebanon`p'missv3 
}
drop Lebanon*
gen component="ynf"
drop if year!=`j'

export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'IPC`ipc'.xlsx", sheet("Lebanon, ynf, `j'") sheetreplace firstrow(variables)
clear

import excel "Input/FiscalSeries/Variants/`p'/RawSeries/Lebanon`p'corrIPC`ipc'.xlsx", sheet("Lebanon, `j'") firstrow clear
gen component="yf"
export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'IPC`ipc'.xlsx", sheet("Lebanon, yf, `j'") sheetreplace firstrow(variables)
}
}
}

************************************************
* Apply Gpinter, with the add-up component option 
************************************************

* Normalization to national income

clear
 
foreach p of global price{
forval j=2005/2014{
foreach g in 3{
foreach ipc of global IPC{


import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/Variants/LebanonFinal`p'IPC`ipc'.xlsx", sheet("Lebanon, `j'") firstrow clear

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/Variants/LebanonFinal`p'normIPC`ipc'.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}
}

******************************************************************
* Apply Gpinter to obtain the output files with the results
******************************************************************
