cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/FiscalData"
clear all
set more off 

local variables wagenet corpnet partnet selfemplnet rent

forval v=2/100{
forval j=2005/2014{

clear
use "Lebanon_cl2.dta", clear

keep if year==`j'

foreach x of local variables{
gsort - `x' 
replace `x' =0 in 1/`v'
}

drop income profitnet
gen profitnet= corpnet+partnet+selfemplnet
gen income = 1.25*(wagenet + profitnet + rent)
 
keep income year pop20 

 
set obs `= _N+ pop20- _N'

replace income=0 if income==.
gsort - income
 
egen rank=rank(income), unique
gen sum = sum(income)
gen topav = sum/[_n]
gen beta = topav/income
drop sum

egen p1=cut(income), group(100)

drop if p1 <99
egen totalincome1`j'=total(income)  
keep year total*
keep in 1
merge m:m year using  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome/LebanonIncomeParameters.dta", nogenerate
drop if year!=`j'
gen ni= Lebanonlcu*popsize
keep year total* ni
gen share= totalincome/ni
save clean`j'`v'.dta, replace
}
}


forval v=2/100{
forval j=2005/2014{ 
use clean`j'`v'.dta
replace year=`j'`v'
save clean`j'`v'.dta, replace
}
}


forval j=2005/2014{
use clean`j'2.dta
forval v=3/100{
append using clean`j'`v'.dta
}
rename share share`j'
replace year =_n
ren year variants
save `j'.dta, replace
}


use 2005.dta, clear
forval j=2006/2014{
merge m:m variants using `j'.dta, nogenerate
}
keep variants share*
save AllVariants.dta, replace


use AllVariants.dta, clear
forval j=2005/2014{
replace share`j'=share`j'/0.45
}
 
export excel using "Results/ComparaisonCleaning.xlsx", sheet("Variants Top 1") sheetreplace firstrow(variables)

tsset variants
twoway (tsline share2005) (tsline share2006) (tsline share2007) (tsline share2008) (tsline share2009) (tsline share2010) (tsline share2011) (tsline share2012) (tsline share2013) (tsline share2014)
 

forval v=2/100{
forval j=2005/2014{ 
erase clean`j'`v'.dta
}
}

* Identifying outliers by schedule 

clear 
set more off
local variables wagenet corpnet partnet selfemplnet rent


forval j=2005/2014{
foreach x of local variables{

use Lebanon_cl2.dta, clear
keep if year==`j' 
gsort -`x'
sum `x'
gen clean`x'`j'=`x'/r(mean)

keep clean*
drop if _n>100
gen rank=_n
order rank clean*
save clean`x'`j'.dta, replace
}
}


foreach x of local variables{
use clean`x'2005.dta, clear
forval j=2006/2014{
merge m:m rank using clean`x'`j'.dta, nogenerate
}
egen average=rowmean(clean*)
export excel using "Results/ComparaisonCleaning.xlsx", sheet(" Top distrib, `x'") sheetreplace firstrow(variables)
}
 
foreach x of local variables{
forval j=2005/2014{
erase clean`x'`j'.dta
}
}

forval j=2005/2014{
erase `j'.dta
}
