/*******Stata code generating normalized WID.world top-percentile wealth distributions US-CH-FR using gpinter*****/

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth" 
 
 
/****Step 0: Importing data from WID.world to generate a normalized USCHFR wealth distribution,"**/
  forval year=1995/2014{
	foreach country in FR CN US{
		foreach x in thweal ahweal{

clear all
wid, indicators (`x') years (`year') age (992) areas (`country') perc (p0 p0p1 p1 p1p2 p2 p2p3 p3 p3p4 p4 p4p5 p5 p5p6 p6 p6p7 p7 p7p8 p8 p8p9 p9 p9p10 p10 p10p11 p11 p11p12 p12 p12p13 p13 p13p14 p14 p14p15 p15 p15p16 p16 p16p17 p17 p17p18 p18 p18p19 p19 p19p20 p20  p20p21  p21  p21p22 p22 p22p23 p23 p23p24 p24 p24p25 p25 p25p26 p26 p26p27 p27  p27p28 p28 p28p29 p29 p29p30 p30 p30p31 p31 p31p32 p32 p32p33 p33 p33p34 p34 p34p35 p35 p35p36 p36 p36p37 p37 p37p38 p38 p38p39 p39 p39p40 p40 p40p41 p41 p41p42 p42 p42p43 p43 p43p44 p44 p44p45 p45 p45p46 p46 p46p47 p47 p47p48 p48 p48p49 p49 p49p50 p50 p50p51 p51 p51p52 p52 p52p53 p53 p53p54 p54 p54p55 p55 p55p56 p56 p56p57 p57 p57p58 p58 p58p59 p59 p59p60 p60 p60p61 p61 p61p62 p62 p62p63 p63 p63p64 p64 p64p65 p65 p65p66 p66 p66p67 p67 p67p68 p68 p68p69 p69 p69p70 p70 p70p71 p71 p71p72 p72 p72p73 p73 p73p74 p74 p74p75 p75 p75p76 p76 p76p77 p77 p77p78 p78 p78p79 p79 p79p80 p80 p80p81 p81 p81p82 p82 p82p83 p83 p83p84 p84 p84p85 p85 p85p86 p86 p86p87 p87 p87p88 p88 p88p89 p89 p89p90 p90 p90p91 p91 p91p92 p92 p92p93 p93 p93p94 p94 p94p95 p95 p95p96 p96 p96p97 p97 p97p98 p98 p98p99 p99 p99p99.1 p99.1 p99.1p99.2 p99.2 p99.2p99.3 p99.3 p99.3p99.4 p99.4 p99.4p99.5 p99.5 p99.5p99.6 p99.6 p99.6p99.7 p99.7 p99.7p99.8 p99.8 p99.8p99.9 p99.9  p99.9p99.91 p99.91 p99.91p99.92 p99.92 p99.92p99.93 p99.93 p99.93p99.94 p99.94 p99.94p99.95 p99.95 p99.95p99.96 p99.96 p99.96p99.97 p99.97 p99.97p99.98 p99.98 p99.98p99.99 p99.99  p99.99p99.991 p99.991 p99.991p99.992 p99.992 p99.992p99.993 p99.993 p99.993p99.994 p99.994 p99.994p99.995 p99.995 p99.995p99.996 p99.996 p99.996p99.997 p99.997 p99.997p99.998 p99.998 p99.998p99.999 p99.999 p99.999p100) 
drop variable percentile 
rename value `x'
sort `x'
  
merge 1:1 _n using gperc.dta, nogenerate
  
  save `x'`country'`year'.dta, replace
  }
  }
  }
   
forval year=1995/2014{
	foreach country in FR CN US{ 

use thweal`country'`year'.dta
merge m:m p using ahweal`country'`year'.dta, nogenerate
rename t* thr 
rename a* bracketavg

 save `country'`year'.dta, replace
}
}


  forval year=1995/2014{
	foreach country in FR CN US{
wid, indicators (ahweal) years (`year') age (992) areas (`country') perc (p0p100) clear
keep country year value
gen p=0 in 1
ren value average
merge 1:m p using `country'`year'.dta, nogenerate 

 	foreach x of varlist thr bracketavg topavg average{
	gen `x'_`country'=`x'/average
	drop `x'
	}

	drop average country
order  year p thr bracketavg topavg
save `country'`year'.dta, replace
}
}


clear all 
forval year=1995/2014{
use FR`year'.dta
merge m:m p using US`year'.dta, nogenerate
merge m:m p using CN`year'.dta, nogenerate
egen thr=rowmean(thr*)
egen bracketavg=rowmean(bracketavg*)
egen topavg=rowmean(topavg*)

drop year
gen year=`year' in 1
gen country="USCHFR" in 1
gen average=topavg[1] in 1
gen component= "wealth" in 1
gen b= topavg/thr
keep year country component average p thr bracketavg topavg b
order year country component average p thr bracketavg topavg b
export excel using "Input/WealthTabulationsWIDworld.xlsx", sheet("`year'") sheetreplace firstrow(variables)
 clear all
 }
  
forval year=2015/2016{
clear
import excel "Input/WealthTabulationsWIDworld.xlsx", sheet("2014") firstrow
replace year=`year'
export excel using "Input/WealthTabulationsWIDworld.xlsx", sheet("`year'") sheetreplace firstrow(variables)
}

/****Step 1: importing WID.world normalized USCHFR distributions and restricting to top 1%****/ 
forval year=1995/2016{
clear 
import excel "Input/WealthTabulationsWIDworld.xlsx", sheet(`year') firstrow
drop if p<0.99 
replace p=(p-0.99)*100 
replace p=0 in 1
replace year=`year' if p==0  
replace country="USCHFR" if p==0  
replace component="wealth" if p==0 
replace average=topavg if p==0 
export excel using "Input/WealthTopTabulationsWIDworld.xlsx", sheet(`year') sheetreplace firstrow(variables) 
clear 
} 


/*Step 2: apply Gpinter to input file WealthTopTabulationsWIDworld.xlsx to obtain output file WealthTopSeriesWIDworld.xlsx
 Apply Gpinter to input file WealthTabulationsWIDworld.xlsx to obtain output file WealthSeriesWIDworld.xlsx****/


/****Step 3: suppress intermediate thresholds below top 0.1% (otherwise too many thresholds)****/
forval year=1995/2016{ 
clear 
import excel "Output/WealthTopSeriesWIDworld.xlsx", sheet("wealth, USCHFR, `year'") firstrow
drop if p<0.9 & (p~=0 & p~=0.1 & p~=0.2 & p~=0.3 & p~=0.4 & p~=0.5 & p~=0.6 & p~=0.7 & p~=0.8 & p~=0.9) 
replace bracketavg=((1-p)*topavg-(1-p[_n+1])*topavg[_n+1])/(p[_n+1]-p) if p<0.9 
export excel "Output/WealthTopSeriesWIDworld.xlsx", sheet("wealth, USCHFR, `year'", replace) firstrow(variables) 
} 



clear all
forval year=1995/2014{
 foreach country in FR CN US{
 foreach x in thweal ahweal{
erase `x'`country'`year'.dta
}
erase `country'`year'.dta
}
}



