* Code computing the share of the survey and fiscal income distribution in total national income * 

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome"

* Duplicate Input/FiscalSeries/PPP/RawSeries/LebanonPPPcorrp1.xlsx to create LebanonPPP.xlsx
global series Survey Fiscal  

foreach s of global series{
forval j=2005/2014{
foreach i in Lebanon{
clear 

import excel "Input/`s'Series/PPP/RawSeries/`i'PPP.xlsx", sheet("`i', `j'") firstrow clear
destring _all, replace
merge m:1 year using LebanonIncomeParameters.dta, nogenerate

keep year country average `i'MER
gen Share_`s'= average/`i'MER

keep year country Share
keep in 1
save `i'_`j'_`s'.dta, replace
}
}
}

foreach i in Lebanon{
foreach s of global series{
clear
use "`i'_2005_`s'.dta"
forval j=2006/2014{
 append using `i'_`j'_`s'
 keep year Share_`s'
 save `i'_`j'_`s'.dta, replace
 }
 }
 }

use Lebanon_2014_Survey.dta
merge m:m year using Lebanon_2014_Fiscal.dta, nogenerate
gen Share_Final = Share_Fiscal + 0.15
export excel using "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017Appendix.xlsx", sheet("ShareinTotalNationalIncome") sheetreplace cell(A4) firstrow(variables)


foreach i in Lebanon{
forval j=2005/2014{
foreach s of global series{
erase `i'_`j'_`s'.dta
}
}
}
 

 
 
 
