/*******Stata code creating input files to generate the Lebanese survey income distributions *****/

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome"

* Step 0: Apply gpinter to input files in "Input/GenerationSurveySeriesLeb.xlsx" to obtain the output file "Output/Survey040507.xlsx" 
* Benchmark series: 2005/2007, IPC=2 assumed in the last bracket


* Step 1: Generation of survey series using the 2007 "Before war" survey for the years 2004-2006 and the 2007 survey for the years 2007-2014 


*2005

forval j=2005/2006{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20052") firstrow clear

destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor0507*1000
drop `x'
rename `x'_ `x'
}

keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/LCU/LebanonLCU.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}



*2007
forval j=2007/2014{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20072") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor0507*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/LCU/LebanonLCU.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}

*********************************************************************************
/* Step 2: Apply G-pinter to produce output file "LCU/OutputSurveyOnly", 
to be used in the fiscal correction step */
*********************************************************************************

* Step 3: normalizing the series to national income, in MER and PPP 

global price MER PPP

forval j=2005/2014{
foreach p of global price{
clear
import excel "Input/SurveySeries/LCU/LebanonLCU.xlsx", sheet("Lebanon, `j'") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
drop if year!=`j'
foreach x of varlist average thr bracketavg{
gen `x'_=factorprice`p'*`x'*factor
drop `x'
rename `x'_ `x'
}
drop factor* 
order year country average p thr br* popsize
export excel using "Input/SurveySeries/`p'/RawSeries/Lebanon`p'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg popsizeLebanon Lebanon`p'
rename pop popsize
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_ popsize
order year country average_ p thr_ bracketavg_ popsize

rename average_ average 
rename thr_ thr
rename bracketavg_ bracketavg 
export excel using "Input/SurveySeries/`p'/NormalizedSeries/Lebanon`p'norm.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

}
}
 
   
