
clear all
set more off
cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/FiscalData"

forval year=2005/2014{
use "Lebanon_cleaned.dta", clear

 keep if year==`year'
 
set obs `= _N+ pop20- _N'
keep income wagenet profitnet selfemplnet corpnet partnet rent

foreach x of varlist _all{
replace `x'=0 if `x'==.
}

gsort - income
drop in 1
egen rank=rank(income), unique

egen p9=cut(income), group(100)
replace p9=0 if p9==.


foreach k in 9 99 999{
egen p`k'9_=cut(income) if p`k'==`k'9, group(10)
gen p`k'9=p`k'9_+`k'90 
drop p`k'9_
replace p`k'9=0 if p`k'9==.
}

drop rank
drop if p9<98

foreach k in 9 99 999 9999{
forval j=0/9{
foreach x of varlist wagenet profitnet selfemplnet corpnet partnet rent income{
egen total`x'`k'`j'=total(`x') if p`k'==`k'`j'
egen total`x'`k'`j'_=total(`x') if p`k'>=`k'`j'

sum total`x'`k'`j'
replace total`x'`k'`j'=r(mean) if total`x'`k'`j'==.
sum total`x'`k'`j'_
replace total`x'`k'`j'_=r(mean) if total`x'`k'`j'_==.

}
}
}

foreach x of varlist wagenet profitnet selfemplnet corpnet partnet rent{
foreach k in 9 99 999 9999{
forval j=0/9{
gen share`x'`k'`j'=(total`x'`k'`j'/totalincome`k'`j')/0.8
gen share`x'`k'`j'_=(total`x'`k'`j'_/totalincome`k'`j'_)/0.8

}
}
}

keep share*
keep in 1
forval j=90/98{
drop *net`j'
drop *net`j'_
drop *rent`j'
drop *rent`j'_
}


save composition`year'.dta, replace
keep *_
save compositiontop`year'.dta, replace
clear 

use composition`year'.dta
drop *_
save compositionbracket`year'.dta, replace

clear

local group top bracket
local source wage selfempl corp part rent

foreach g of local group{
foreach s of local source{
use composition`g'`year'.dta, clear
keep share`s'*
xpose, clear 
rename v1 `s'
save `s'`g'`year'.dta, replace
}
}

foreach g of local group{
use wage`g'`year'.dta, clear 
merge 1:1 _n using selfempl`g'`year'.dta, nogenerate
merge 1:1 _n using corp`g'`year'.dta, nogenerate
merge 1:1 _n using part`g'`year'.dta, nogenerate
merge 1:1 _n using rent`g'`year'.dta, nogenerate

gen p=0.99
forval j=0/9{
replace p=0.99`j' if _n==2+`j'
replace p=0.999`j' if _n==12+`j'
replace p=0.9999`j' if _n==22+`j'
}

order p wage self* corp part		
export excel using "Results/CompositionTopIncome.xlsx", sheet("`year'`g'") sheetreplace firstrow(variables)
}


foreach g of local group{
foreach s of local source{
erase `s'`g'`year'.dta
}
erase composition`g'`year'.dta
}
erase composition`year'.dta

}
