***** Code to generate the Lebanese distribution, corrected at the top using fiscal data, for the years 2005-2014 *** 

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome" 
 
  
* Step 1: Computing the fiscal correction coefficients for the top 1 for each year  
 
forval j=2005/2014{
clear
import excel "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/FiscalData/Results/FiscalSeries.xlsx", sheet("`j'") firstrow clear
destring _all, replace
keep in 11
rename thresh thr
save `j'.dta, replace 
 }
 
 use 2005.dta
forval j=2006/2014{
append using `j'.dta
}
save upfactors99.dta, replace

  
forval j=2005/2014{
clear
 import excel "Output/SurveySeries/OutputSurveyOnly.xlsx", sheet("Lebanon, `j'") firstrow
destring _all, replace
drop year country average 
gen year=`j'
keep in 100

foreach x of varlist thr bracketavg topavg b{
rename `x' `x'_
}
save `j'.dta, replace 
}


use 2005.dta
forval j=2006/2014{
append using `j'.dta
}

merge m:m year using upfactors99.dta, nogenerate
foreach x of varlist thr bracketavg topavg b{
gen coeff`x'= `x'/`x'_
}
keep year p coeff* b
order year p coeff* b

foreach x of varlist coeff* b{

sum `x'
gen mean`x'=r(mean)
}

save upfactors99.dta, replace

export excel using "CompCorrectionCoeffLeb.xlsx", sheet("upfactors99") firstrow(variables) sheetreplace
 

forval j=2005/2014{
erase `j'.dta
}

erase upfactors99.dta


* Step 2: Importing the survey data for the bottom 0.99 of the population* 

 
forval j=2005/2014{
clear
 import excel "Output/SurveySeries/OutputSurveyOnly.xlsx", sheet("Lebanon, `j'") firstrow
destring _all, replace
replace year=`j'
replace p=0.82 in 83
replace p=0.83 in 84
replace p=0.94 in 95
replace p=0.95 in 96


keep if p<=0.99
replace bracketavg=topavg in 100
drop topavg
save survey`j'.dta, replace
}

*********************************************************************************
/*Step 3: creating a Stata database for the Correction coefficients. The profile 
chosen must be specified direcly in the excel file "CompCorrectionCoeffLeb.xlsx, sheet "CompUpFactorLeb"*/
*********************************************************************************


* Step 4: Applying the coefficients to the survey data, between p=0.8 and p=0.99 *

 
clear 
forval j=2005/2014{
import excel "CompCorrectionCoeffLeb.xlsx", sheet("Stata") firstrow clear

keep p *`j'
gen year=`j'
order year p coeff*
save corrcoeff`j'.dta, replace
}

clear all
forval j=2005/2014{
use survey`j'.dta
merge m:1 p using corrcoeff`j'.dta, nogenerate
rename coeffavg coeffbracketavg
drop b

foreach x of varlist thr bracketavg{
gen `x'_=`x'*coeff`x'
replace `x'=`x'_ if `x'_!=.
}

keep year country average p thr bracketavg
drop if _n>100

gen topavg=bracketavg[100]
forval k=99(-1)1{
replace topavg= ((1-p[`k'+1])*topavg[`k'+1] + (p[`k'+1]-p[`k'])*bracketavg[`k'])/(1-p[`k']) if _n== `k'
 }
replace average=topavg[1]
drop top*
*gen component="labor"
export excel using "Input/FiscalSeries/InputFiscalCorrectionLebanonp1.xlsx", sheet("`j'") sheetreplace firstrow(variables)
erase corrcoeff`j'.dta
erase survey`j'.dta
clear all
}


* Step 5: Normalizing the distribution to national income (Euro 2016, MER and PPP)

global price MER PPP

*2005-2014
foreach p of global price{

 forval j=2005/2014{
import excel "Input/FiscalSeries/InputFiscalCorrectionLebanonp1.xlsx", sheet("`j'") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using "LebanonIncomeParameters.dta"
drop if _merge!=3
drop _merge
foreach x of varlist average thr bracketavg{
gen `x'_=factorprice`p'*`x'*factor
drop `x'
rename `x'_ `x'
}
drop factor* 
order year country average p thr br* popsize
export excel using "Input/FiscalSeries/`p'/RawSeries/Lebanon`p'corrp1.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
}
}


* Step 6: Normalizing to national accounts

clear
global profile 1 2 3 4 

foreach p of global price{
forval j=2005/2014{
foreach prof of global profile{
clear  

import excel "Input/FiscalSeries/`p'/RawSeries/Lebanon`p'corrp`prof'.xlsx", sheet("Lebanon, `j'") firstrow clear

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg popsizeLebanon Lebanon`p'
rename pop popsize
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_ popsize
order year country average_ p thr_ bracketavg_ popsize

rename average_ average 
rename thr_ thr
rename bracketavg_ bracketavg 
export excel using "Input/FiscalSeries/`p'/NormalizedSeries/Lebanon`p'corrnormp`prof'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

}
}
}

