* Code Generating the final series (after the fiscal and the missing capital income corrections) *

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome" 

global price PPP

 ********************************************************************************* 
********************* VARIANTS Wealth : Family size ************************
********************************************************************************* 

foreach nadult in 2 4 6 8{ 
forval j=2005/2014{
foreach p of global price{
clear
import excel  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth/Output/WealthSeriesLebanonCorrectedVariant1.xlsx", sheet("wealth, Lebanon, `nadult'2016") firstrow clear

destring _all, replace
replace year=`j'
 
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
 
keep year country average p thr bracketavg Lebanon`p'missv3  
foreach x of varlist average thr bracketavg{
replace `x'=`x'*Lebanon`p'missv3
}
drop Lebanon*
gen component="ynf"
drop if year!=`j'

export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'Wealthn`nadult'.xlsx", sheet("Lebanon, ynf, `j'") sheetreplace firstrow(variables)
clear

import excel "Input/FiscalSeries/`p'/RawSeries/Lebanon`p'corrp1.xlsx", sheet("Lebanon, `j'") firstrow clear
gen component="yf"
export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'Wealthn`nadult'.xlsx", sheet("Lebanon, yf, `j'") sheetreplace firstrow(variables)
}
}
} 


 ********************************************************************************* 
********************* VARIANTS Wealth : profile ************************
********************************************************************************* 

* Modify the name of the sheet "wealth, Lebanon, 2016" into "wealth, Lebanon, 02016"
* in WealthSeriesLebanonCorrectedVariant2.xlsx
 
foreach linear in 0 20 40 60 80 100{ 
forval j=2005/2014{
foreach p of global price{
clear
import excel  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth/Output/WealthSeriesLebanonCorrectedVariant2.xlsx", sheet("wealth, Lebanon, `linear'2016") firstrow clear

destring _all, replace
replace year=`j'
 
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
 
keep year country average p thr bracketavg Lebanon`p'missv3  
foreach x of varlist average thr bracketavg{
replace `x'=`x'*Lebanon`p'missv3
}
drop Lebanon*
gen component="ynf"
drop if year!=`j'

export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'Wealthf`linear'.xlsx", sheet("Lebanon, ynf, `j'") sheetreplace firstrow(variables)
clear

import excel "Input/FiscalSeries/`p'/RawSeries/Lebanon`p'corrp1.xlsx", sheet("Lebanon, `j'") firstrow clear
gen component="yf"
export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'Wealthf`linear'.xlsx", sheet("Lebanon, yf, `j'") sheetreplace firstrow(variables)
}
}
} 


************************************************
* Apply Gpinter, with the add-up component option
************************************************

* Normalization to national income


* Family size 
clear

foreach nadult in 2 4 6 8{ 
foreach p of global price{
forval j=2005/2014{
foreach g in 3{
clear
import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/Variants/LebanonFinal`p'Wealthn`nadult'.xlsx", sheet("Lebanon, `j'") firstrow

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/Variants/LebanonFinal`p'normWealthn`nadult'.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}
}


* Profile


clear

foreach linear in 0 20 40 60 80 100{ 
foreach p of global price{
forval j=2005/2014{
foreach g in 3{
clear
import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/Variants/LebanonFinal`p'Wealthf`linear'.xlsx", sheet("Lebanon, `j'") firstrow

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/Variants/LebanonFinal`p'normWealthf`linear'.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}
}


/*

* Gumbel Parameter

foreach p of global price{
forval j=2005/2014{
foreach g in 1.5 2 3 4{
clear
import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/LebanonFinal`p'v3.xlsx", sheet("Lebanon, `j'") firstrow

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/LebanonFinal`p'normv3.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}



 


