
************************************************************************************************************************
******************************************** Variants Survey Series**************************************************
************************************************************************************************************************
clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome"


************************************************************************************************************************
*********************************************** Survey Years *********************************************************
************************************************************************************************************************


* Generation survey series using the 2004 survey for the years 2004-2006 and the 2007 survey for the years 2007-2014

*2004
forval j=2004/2006{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20042") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor0407*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/SurveyYears/LebanonSurveySeries0407.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}



*2007
forval j=2007/2014{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20072") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor0407*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/SurveyYears/LebanonSurveySeries0407.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}

/*
*************************************************************** 
* Generation survey series using the 2004 survey for all years
**************************************************************** 

*2004
forval j=2004/2014{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20042") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor2004*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/SurveyYears/LebanonSurveySeries2004.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}


*************************************************************** 
* Generation survey series using the 2007 survey for all years
*************************************************************** 


*2004
forval j=2004/2014{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20072") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor2007*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/SurveyYears/LebanonSurveySeries2007.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}


*************************************************************** 
* Generation survey series using the 2005 survey for all years
*************************************************************** 


*2005
forval j=2004/2014{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 20052") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor2005*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/SurveyYears/LebanonSurveySeries2005.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}
*/

*********************************************************************************
* Step 2: Apply G-pinter to produce output file "OutputSurveyOnly0407" 
*********************************************************************************

* Step 3: normalizing the series, in PPP, and to national accounts

global price PPP
*global variants 0407 2004 2005 2007
global variants 0407  

forval j=2005/2014{
foreach p of global price{
foreach v of global variants{
clear
import excel "Input/SurveySeries/Variants/SurveyYears/LebanonSurveySeries`v'.xlsx", sheet("Lebanon, `j'") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
drop if year!=`j'
foreach x of varlist average thr bracketavg{
gen `x'_=factorprice`p'*`x'*factor
drop `x'
rename `x'_ `x'
}
drop factor* 
order year country average p thr br* popsize
export excel using "Input/SurveySeries/Variants/SurveyYears/`p'/RawSeries/Lebanon`v'`p'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg popsizeLebanon Lebanon`p'
rename pop popsize
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_ popsize
order year country average_ p thr_ bracketavg_ popsize

rename average_ average 
rename thr_ thr
rename bracketavg_ bracketavg 
export excel using "Input/SurveySeries/Variants/SurveyYears/`p'/NormalizedSeries/Lebanon`v'`p'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

}
}
} 



************************************************************************************************************************
******************************************** IPC Last Bracket **************************************************
************************************************************************************************************************

global IPC 1 2 3 

foreach b of global IPC{

*2005

forval j=2005/2006{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 2005`b'") firstrow clear

destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor0507*1000
drop `x'
rename `x'_ `x'
}

keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/IPCLastBracket/LebanonLCU`b'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}



*2007
forval j=2007/2014{
import excel "Output/SurveySeries/Survey040507.xlsx", sheet("Lebanon, 2007`b'") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebUpgradeFactorsSurvey.dta
drop if _merge!=3
drop _merge
 
foreach x of varlist average thr bracketavg{
gen `x'_=`x'*factor0507*1000
drop `x'
rename `x'_ `x'
}


keep year country average p thr br*  
order year country average p thr br*  
export excel using "Input/SurveySeries/Variants/IPCLastBracket/LebanonLCU`b'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)
clear all
}
}



*********************************************************************************
* Step 2: Apply G-pinter to produce output file "OutputSurveyIPC" 
*********************************************************************************

* Step 3: normalizing the series, in PPP, and to national accounts

global price PPP
foreach b of global IPC{

forval j=2005/2014{
foreach p of global price{

clear
import excel "Input/SurveySeries/Variants/IPCLastBracket/LebanonLCU`b'.xlsx", sheet("Lebanon, `j'") firstrow clear
destring year, replace
replace year=`j'
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
drop if year!=`j'
foreach x of varlist average thr bracketavg{
gen `x'_=factorprice`p'*`x'*factor
drop `x'
rename `x'_ `x'
}
drop factor* 
order year country average p thr br* popsize
export excel using "Input/SurveySeries/Variants/IPCLastBracket/`p'/RawSeries/Lebanon`b'`p'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg popsizeLebanon Lebanon`p'
rename pop popsize
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_ popsize
order year country average_ p thr_ bracketavg_ popsize

rename average_ average 
rename thr_ thr
rename bracketavg_ bracketavg 
export excel using "Input/SurveySeries/Variants/IPCLastBracket/`p'/NormalizedSeries/Lebanon`b'`p'.xlsx", sheet("Lebanon, `j'") sheetreplace firstrow(variables)

}
}
} 
   
