* Code Generating the final series (after the fiscal and the missing capital income corrections) *

clear all
set more off

cd "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterIncome" 

 global price PPP

********************************************************************************* 
********************* VARIANTS TAX DATA: DEFINITION OF INCOME *******************
********************************************************************************* 


  
global variants 0.6 0.7 0.9

foreach v of global variants{
forval j=2005/2014{
foreach p of global price{
clear
import excel  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth/Output/WealthSeriesLebanonCorrected.xlsx", sheet("wealth, Lebanon, 2016") firstrow clear

destring _all, replace
replace year=`j'
 
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
 
keep year country average p thr bracketavg Lebanon`p'missv3  
foreach x of varlist average thr bracketavg{
replace `x'=`x'*Lebanon`p'missv3 
}
drop Lebanon*
gen component="ynf"
drop if year!=`j'

export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'Def`v'.xlsx", sheet("Lebanon, ynf, `j'") sheetreplace firstrow(variables)
clear

import excel "Input/FiscalSeries/Variants/`p'/RawSeries/Lebanon`p'corrDef`v'.xlsx", sheet("Lebanon, `j'") firstrow clear
gen component="yf"
export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'Def`v'.xlsx", sheet("Lebanon, yf, `j'") sheetreplace firstrow(variables)
}
}
}

************************************************
* Apply Gpinter, with the add-up component option 
************************************************

* Normalization to national income

clear

foreach v of global variants{
foreach p of global price{
forval j=2005/2014{
foreach g in 3{
clear
import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/Variants/LebanonFinal`p'Def`v'.xlsx", sheet("Lebanon, `j'") firstrow

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/Variants/LebanonFinal`p'normDef`v'.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}
}

********************************************************************************* 
********************* VARIANTS TAX DATA: PROFILES *******************
********************************************************************************* 

 
global profile 2 3 4 

foreach prof of global profile{
forval j=2005/2014{
foreach p of global price{
clear
import excel  "/Users/lydiaassouad/Dropbox/WID_MiddleEast/Assouad2017Lebanon/Assouad2017DistributionSeries/GpinterWealth/Output/WealthSeriesLebanonCorrected.xlsx", sheet("wealth, Lebanon, 2016") firstrow clear

destring _all, replace
replace year=`j'
 
merge m:1 year using LebanonIncomeParameters.dta, nogenerate
 
keep year country average p thr bracketavg Lebanon`p'missv3  
foreach x of varlist average thr bracketavg{
replace `x'=`x'*Lebanon`p'missv3 
}
drop Lebanon*
gen component="ynf"
drop if year!=`j'

export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'prof`prof'.xlsx", sheet("Lebanon, ynf, `j'") sheetreplace firstrow(variables)
clear

import excel "Input/FiscalSeries/`p'/RawSeries/Lebanon`p'corrp`prof'.xlsx", sheet("Lebanon, `j'") firstrow clear
gen component="yf"
export excel using "Input/FinalSeries/`p'/InputCopula/Variants/LebanonFinal`p'prof`prof'.xlsx", sheet("Lebanon, yf, `j'") sheetreplace firstrow(variables)
}
}
}

************************************************
* Apply Gpinter, with the add-up component option 
************************************************

* Normalization to national income

clear

foreach prof of global profile{
foreach p of global price{
forval j=2005/2014{
foreach g in 3{
clear
import excel "Input/FinalSeries/`p'/OutputCopula/GumbelCopula`g'/Variants/LebanonFinal`p'prof`prof'.xlsx", sheet("Lebanon, `j'") firstrow

destring _all, replace
replace year=year[1]
merge m:m year using LebanonIncomeParameters.dta, nogenerate

drop if year !=`j'

keep year country average p thr bracketavg topavg b Lebanon`p'
gen av=average
replace av=av[1]

	foreach x of varlist average thr bracketavg topavg{
	gen `x'_=(`x'/av)*Lebanon`p'
	} 

keep year country average_ p thr_ bracketavg_  topavg_ b
order year country average_ p thr_ bracketavg_  topavg b 

ren *_ *
export excel using "Input/FinalSeries/`p'/NormalizedSeries/GumbelCopula`g'/Variants/LebanonFinal`p'normprof`prof'.xlsx", sheet("Lebanon, `j', final") sheetreplace firstrow(variables)

}
}
}
}
