﻿

/*****************************************************************************
		Code for importing data with the "DGFiP format"
		and transfort then into Excel format, first to a general GGP2017IncomeTaxTabulation files 

******************************************************************************/

*global projdir "\\ulysse\users\BGarbinti\brtrd\Projet wealth_income\TransfertsDGFiPExcel"
global projdir "C:\Users\G839276\Dropbox\WIDFrance\Papers\GGP2017DINA\GGP2017DINAAppendixD\IncomeTaxTabulations"



********************************************************************************
* Step 1: Putting in the right format for Pareto interpolations with Gpinter
********************************************************************************



*** 1-1- From DGFiP format to GGP2017IncomeTaxTabulation.xls 

capture program drop transform_data 
program define transform_data
	args year
	cd "$projdir"
	import excel "$projdir\FinMinRecentTabulations\TabRepNationaux\TabRepNationaux20012015.xls", sheet("National`year'") cellrange(A5:J32) firstrow clear
	br
	g year =`year'
	split A, p(" à ")
	drop if A1 == "Plus de 100 000 dont:"
	replace A1 = "9 000 001" if A1 == "Plus de 9 000 000"
	drop if A1=="Total"
	replace A1 = subinstr(A1, " ", "",.) 
	destring A1, gen(thr)
	drop A1
	sort thr
	g double cum_pop0 =sum(B)
	g double cum_pop = cum_pop0[_n-1]
	drop cum_pop0
	replace cum_pop=0 if thr==0
	egen double tot_pop = sum(B)
	g double p = cum_pop/tot_pop
	gsort - thr
	gen double tot_inc_above = sum(C)
	gen double tot_pop_above = sum(B)
	sort thr
	g double b = (tot_inc_above/tot_pop_above)/thr
	
	g average = (tot_inc_above/tot_pop_above) if _n==1
	replace average = average[_n-1] if missing(average)
	keep year average p thr b
	order year average p thr b
	tempfile temp1
	save `temp1', replace
	
	*share of singles in brackets : 2013 data
	import excel "GGP2017IncomeTaxTabulations.xlsx", sheet("2013") cellrange(A3:D28) firstrow clear
	br
	keep thr s
	replace thr=thr+1 if thr>0
	merge 1:1  thr using `temp1'
	keep if _merge==3
	drop _merge
	order year average p thr b s

	export excel using "GGP2017IncomeTaxTabulations.xlsx", sheet("`year'")  firstrow(variables) cell(A3) sheetmodify
end

transform_data 2014

*** 1-2 Add manually line for p10 from microfiles (see year 2013 and before) in GGP2017IncomeTaxTabulations.xlsx
