*****************************************************
* Exportation of the results related to GGP2017DINA *
*****************************************************

global projdir "C:/Users/John/Dropbox/WIDFrance/Papers"
global rawresults "$projdir/GGP2017DINA/GGP2017DINAAppendixC/DataFiles/Results"
global param "$projdir/GGP2017DINA/GGP2017DINAAppendixA"

***************************************************************************************
* Part A : Creation of table at the decile level with interpolation for missing years *
***************************************************************************************
	
* A.I)  DINA Income: pretax, labor pretax, capital pretax, factor labor income at equal-split or tax unit or individual level
* A.II) Fiscal income at equal-split or tax unit or individual level


* A.I) DINA Income: Creation of complete table with income share, income composition, average income and tresholds 1970-2014 
*****************************************************************************************************************************
	
foreach loop of newlist r_pretaxCN r_pretaxCN_foy r_pretaxCN_equal rcap rtrav_pretaxCN rtrav_pretaxCN_equal rtrav_FICN  {
	* 1) Load the Data
	*******************
		import excel using "$rawresults/exportresults_DINA.xlsx", first clear sheet("comptanat") cellrange(A7:AA52) 
		drop E Q
		foreach var of varlist income rtrav_pretaxCN -rfin_av_FICN {
			rename `var' `var'_tot
		}
		expand 3
		sort year
		gen sex=0 if _n==1 | year~=year[_n-1]
		replace sex=1 if sex[_n-1]==0
		replace sex=2 if sex[_n-1]==1
		tempfile NA
		save "`NA'",replace
		
		merge 1:m year sex using "$rawresults/gperc/gperc`loop'.dta"
		if "`loop'"~= "rtrav_FICN" {
			rename sh_r_pretaxCN share_dperc
		}
		if "`loop'"== "rtrav_FICN" {
			rename sh_r_FICN share_dperc
		}
		replace dperc=0 if dperc==.
		sort sex year gperc dperc
		keep if dperc==1 | dperc~=dperc[_n-1] | year ~= year[_n-1]
		
		
		drop _merge gperc 
		keep year sex  sh* dperc
		reshape wide sh*, i(year sex) j(dperc)
		merge 1:1 year sex using "`NA'"
		drop _merge
		sort sex year
	
	* 2) Interpolation for missing years
	*************************************		
		* Reference year: 1970
		local base=1970
		forval pas=0/2 {
		
		* Period 1970-1975
			 local i =1970+1+`pas'*45-`base'
			 local j=`i'+5
			 foreach num of numlist 0(10)90 95 99 995 999 {
				if "`loop'"~= "rtrav_FICN" {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				if "`loop'"== "rtrav_FICN" {
					foreach var of newlist sal nonsal_labor   {
						replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'_FICN`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				 
			 }
		
			 
		* Period 1975-1979
			 local i =1975-`base'+1+`pas'*45
			 local j=`i'+4
			 foreach num of numlist 0(10)90 95 99 995 999 {
				if "`loop'"~= "rtrav_FICN" {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				if "`loop'"== "rtrav_FICN" {
					foreach var of newlist sal nonsal_labor   {
						replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'_FICN`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}	 
			 }
			 
			 
		* Period 1979-1984
			 local i =1979-`base'+1+`pas'*45
			 local j=`i'+5
			 foreach num of numlist 0(10)90 95 99 995 999 {
				if "`loop'"~= "rtrav_FICN" {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				if "`loop'"== "rtrav_FICN" {
					foreach var of newlist sal nonsal_labor   {
						replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'_FICN`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}	
			 }
		 
		  * Period 1984-1988
			 local i =1984-`base'+1+`pas'*45
			 local j=`i'+4
			 foreach num of numlist 0(10)90 95 99 995 999 {
				if "`loop'"~= "rtrav_FICN" {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				if "`loop'"== "rtrav_FICN" {
					foreach var of newlist sal nonsal_labor   {
						replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'_FICN`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}	
			 }
		
		  * Period 1988-1990
			local i =1988-`base'+1+`pas'*45
			 local j=`i'+2
			 foreach num of numlist 0(10)90 95 99 995 999 {
				if "`loop'"~= "rtrav_FICN" {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				if "`loop'"== "rtrav_FICN" {
					foreach var of newlist sal nonsal_labor   {
						replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'_FICN`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}	
			 }
		  * Period 1991-1994 only for male and female
			if `pas'>0 {
				 local i =1991-`base'+1+`pas'*45
				 local j=`i'+3
				 foreach num of numlist 0(10)90 95 99 995 999 {
					if "`loop'"~= "rtrav_FICN" {
						foreach var of newlist sal pension nonsal_labor   {
							replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'_pretaxCN`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
						}
						foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
							replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
						}
						foreach var of newlist rfon_owner rfon_rent  {
							replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
						}
					}
					if "`loop'"== "rtrav_FICN" {
						foreach var of newlist sal nonsal_labor   {
							replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'_FICN`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
						 }
						 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
							replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i']+(sh_`var'`num'[`j']/`var'_FICN_tot[`j'] -sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
						}
						foreach var of newlist rfon_owner rfon_rent  {
							replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i']+(sh_`var'`num'[`j']/rfon_FICN_tot[`j'] -sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*(_n-`i')/(`j'- `i'))*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
						}
					}	
				}
			}
		* Period 2012-2014
			local i =2012-`base'+1+`pas'*45
			local j=`i'+3
			foreach num of numlist 0(10)90 95 99 995 999 {
				if "`loop'"~= "rtrav_FICN" {
					foreach var of newlist sal pension nonsal_labor   {
						replace sh_`var'_pretaxCN`num'=(sh_`var'_pretaxCN`num'[`i']/`var'_pretaxCN_tot[`i'])*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}
				if "`loop'"== "rtrav_FICN" {
					foreach var of newlist sal nonsal_labor   {
						replace sh_`var'_FICN`num'=(sh_`var'_FICN`num'[`i']/`var'_FICN_tot[`i'])*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					 }
					 foreach var of newlist rfon nonsal_capital rfin_div rfin_int rfin_liqu rfin_av  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_FICN_tot[`i'])*`var'_FICN_tot[_n] if _n>`i' & _n< `j'
					}
					foreach var of newlist rfon_owner rfon_rent  {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/rfon_FICN_tot[`i'])*rfon_FICN_tot[_n] if _n>`i' & _n< `j'
					}
				}	
			 }

		}
		
	* 3) Last adjustments
	***********************
		
		drop wealth-rfin_av_FICN_tot
		if "`loop'"~= "rtrav_FICN" {
			 reshape long share_dperc sh_rtrav_pretaxCN sh_rcap sh_sal_pretaxCN sh_pension_pretaxCN sh_nonsal_labor_pretaxCN sh_rfon sh_rfon_owner sh_rfon_rent sh_nonsal_capital sh_rfin sh_rfin_div sh_rfin_int sh_rfin_liqu sh_rfin_av sh_nonsal_pretaxCN,i(year sex) j(dperc)
				 replace sh_nonsal_pretaxCN= sh_nonsal_labor_pretaxCN +sh_nonsal_capital
				 replace sh_rfin =sh_rfin_div +sh_rfin_int +sh_rfin_liqu+ sh_rfin_av
				 replace sh_rcap= sh_rfon +sh_nonsal_capital+ sh_rfin
				 replace sh_rtrav_pretaxCN= sh_sal_pretaxCN +sh_pension_pretaxCN+ sh_nonsal_labor_pretaxCN
				 replace share_dperc= sh_rtrav_pretaxCN+	sh_rcap
			order year sex dperc
			foreach var of varlist sh_rtrav_pretaxCN-sh_nonsal_pretaxCN {
				replace `var'=`var'/share_dperc
			}
		}
		if "`loop'"== "rtrav_FICN" {
			 reshape long share_dperc sh_rtrav_FICN sh_rcap sh_sal_FICN sh_nonsal_labor_FICN sh_rfon sh_rfon_owner sh_rfon_rent sh_nonsal_capital sh_rfin sh_rfin_div sh_rfin_int sh_rfin_liqu sh_rfin_av sh_nonsal_FICN,i(year sex) j(dperc)
			 * Last adjustments
				 replace sh_nonsal_FICN= sh_nonsal_labor_FICN +sh_nonsal_capital
				 replace sh_rfin =sh_rfin_div +sh_rfin_int +sh_rfin_liqu+ sh_rfin_av
				 replace sh_rcap= sh_rfon +sh_nonsal_capital+ sh_rfin
				 replace sh_rtrav_FICN= sh_sal_FICN + sh_nonsal_labor_FICN
				 replace share_dperc= sh_rtrav_FICN+	sh_rcap
			order year sex dperc
			bys year sex : egen tot=sum(sh_`loop')
			replace share_dperc=sh_`loop'/tot
			keep year sex dperc share_dperc 
			sort sex year dperc
		}
		
		sort sex year dperc
		
		* For labor and capital distribution
		if "`loop'"=="rtrav_pretaxCN" | "`loop'"=="rcap"  | "`loop'"=="rtrav_pretaxCN_equal" {
			foreach var of varlist sh_rtrav_pretaxCN-sh_nonsal_pretaxCN {
				replace `var'=`var'*share_dperc
			}
			if "`loop'"=="rtrav_pretaxCN_equal" {
				rename sh_rtrav_pretaxCN sh_rtrav_pretaxCN_equal
			}
			bys year sex : egen tot=sum(sh_`loop')
			replace share_dperc=sh_`loop'/tot
			keep year sex dperc share_dperc 
			sort sex year dperc
		}
	save "$rawresults/dperc/dperc`loop'.dta",replace 
}
			
* A.II) Fiscal Income: Creation of complete table with income share, income composition, average income and tresholds 1970-2012 
*****************************************************************************************************************************
		
foreach loop of newlist r_irpp r_irpp_equal r_irpp_foy {
		
	* 1) Load the Data
	*******************
		import excel using "$rawresults/exportresults_DINA.xlsx", first clear sheet("comptanat") cellrange(A7:P52) 
		foreach var of varlist income rtrav_pretaxCN -rfin_av_pretaxCN {
			rename `var' `var'_tot
		}
		gen rfin_pretaxCN_tot=rfin_div_pretaxCN_tot+ rfin_int_pretaxCN_tot
		drop E
		expand 3
		sort year
		gen sex=0 if _n==1 | year~=year[_n-1]
		replace sex=1 if sex[_n-1]==0
		replace sex=2 if sex[_n-1]==1
		tempfile NA
		save "`NA'",replace
		
		merge 1:m year sex using "$rawresults/gperc/gperc`loop'.dta"
		if "`loop'"=="r_irpp" {
			rename sh_r share_dperc
		}
		if "`loop'"=="r_irpp_equal" | "`loop'"=="r_irpp_foy"  {
			rename sh_`loop' share_dperc
		}
		
		replace dperc=0 if dperc==.
		sort sex year gperc dperc
		keep if dperc==1 | dperc~=dperc[_n-1] | year ~= year[_n-1]
		
		drop _merge gperc 
		keep year sex  sh* dperc
		reshape wide sh*, i(year sex) j(dperc)
		merge 1:1 year sex using "`NA'"
		drop _merge
		sort sex year
	
	* 2) Interpolation for missing years
	*************************************
		* Reference year: 1970
		local base=1970
		
		forval pas=0/2 {
			* Periode 1970-1975
				 local i =1970+1+`pas'*45-`base'
				 local j=`i'+5
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
						 
			* Period 1975-1979
				 local i =1975-`base'+1+`pas'*45
				 local j=`i'+4
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
				 
			* Period 1979-1984
				 local i =1979-`base'+1+`pas'*45
				 local j=`i'+5
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			 
			  * Period 1984-1988
				 local i =1984-`base'+1+`pas'*45
				 local j=`i'+4
				 foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			
			  * Period 1988-1990
				local i =1988-`base'+1+`pas'*45
				 local j=`i'+2
				  foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					 }
				 }
			  * Period 1991-1994 par sexe
				if `pas'>0 {
					 local i =1991-`base'+1+`pas'*45
					 local j=`i'+3
					  foreach num of numlist 0(10)90 95 99 995 999 {
						foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
							replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i']+(sh_`var'`num'[`j']/`var'_pretaxCN_tot[`j'] -sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*(_n-`i')/(`j'- `i'))*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
						 }
					 }
				}
			 * Period 2012-2014
				local i =2012-`base'+1+`pas'*45
				local j=`i'+3
				foreach num of numlist 0(10)90 95 99 995 999 {
					foreach var of newlist sal pension nonsal_labor rfon nonsal_capital rfin   {
						replace sh_`var'`num'=(sh_`var'`num'[`i']/`var'_pretaxCN_tot[`i'])*`var'_pretaxCN_tot[_n] if _n>`i' & _n< `j'
					}
				}
			}
		
		* 3) Last adjustments
		***********************
			drop wealth-rfin_pretaxCN_tot
			reshape long share_dperc sh_rtrav sh_rcap sh_sal sh_pension sh_nonsal_labor sh_rfon sh_nonsal_capital sh_rfin sh_nonsal,i(year sex) j(dperc)
				 replace sh_nonsal= sh_nonsal_labor +sh_nonsal_capital
				 replace sh_rcap= sh_rfon +sh_nonsal_capital+ sh_rfin
				 replace sh_rtrav= sh_sal +sh_pension+ sh_nonsal_labor
				 replace share_dperc= sh_rtrav+	sh_rcap

			order year sex dperc
			foreach var of varlist sh_rtrav-sh_nonsal {
				replace `var'=`var'/share_dperc if share_dperc~=0
				replace `var'=0 if share_dperc==0
			}
			
			sort sex year
			save "$rawresults/dperc/dperc`loop'.dta",replace 
}
		
*********************************************************
* Part B: Exportation of results on income distribution *	
*********************************************************
	
	* All results are exported in xls file exportresults_DINA
	
	* I)  Descriptive statistics on income inequality by income concepts and population size
		* fiscal vs pretax income vs pretax capital vs pretax labor vs factor labor 
		* adults vs equal split adults vs tax units
	
	* II) Income composition by deciles or broad groups (pretax income, equal-split)

	* III) Gender inequality
		* 1) Proportion of women in top 10%, top 1% and top 0.1% of labor income distribution		
		* 2) Gender income ratio for all population or by age groups, 1970-2012 (ordered by year)
		* 3) Gender income ratio by exact age and by income concept (Total vs labor vs capital income), (ordered by age)
		 
	* IV)Income inequality by age  (pretax income : Total, labor and capital)
		* 1) Summary statistics for the distribution of income by broad age groups
		* 2) *Age-income profiles by years (ordered by age), Total vs capital vs labor pretax income
	
	* V) Correlation between labor income and wealth
	
* I)  Descriptive statistics on income inequality by income concepts and population type
*****************************************************************************************
	
	* I.1) Detailed series for distribution of income without missing years
	***********************************************************************
	
	* a) For all adults
	clear
	foreach loop of newlist r_irpp r_irpp_equal r_irpp_foy r_pretaxCN r_pretaxCN_equal r_pretaxCN_foy rcap rtrav_pretaxCN rtrav_pretaxCN_equal rtrav_FICN   { 
		local i=0
		use "$rawresults/gperc/gperc`loop'.dta",clear
		keep year gperc sex  thr ytop b y0 n
		keep if sex==`i'
		drop sex
		tempfile temp
		save "`temp'",replace
		
		* Add interpolated years from Tom Programm
			foreach num of numlist 1971/1974 1976/1978 1980/1983 1985/1987 1989 2013 2014  {
				dis `num'
				clear
				insheet using "$rawresults/Pareto interpolations/`loop'/`num'.csv",    delimiter(",")
				drop year average
				cap replace b="" if b=="Inf"
				destring _all, replace 
				gen year=`num'
				gen gperc=round(p*100) if p<0.985
				replace gperc=round(p*1000) if  p<0.9985 & gperc==.
				replace gperc=round(p*10000) if  p<0.99985 & gperc==.
				replace gperc=round(p*100000) if  p>0.99985 & gperc==.
				drop p topsh
				rename topavg ytop
				replace thr=0 if thr<1
				replace b=. if thr==0
				append using "`temp'"
				erase "`temp'"
				tempfile temp
				save "`temp'",replace		
			}
			merge m:m year using "$rawresults/Pareto interpolations/`loop'/y0_`loop'.dta", update
			drop _merge
			erase "`temp'"
			tempfile temp
			save "`temp'",replace
		
		* Add other variables
			import excel using "$rawresults/exportresults_DINA.xlsx", first clear sheet("comptanat") cellrange(AB7:AS52) 
			replace pop=pop*1000
			if "`loop'"=="r_irpp_foy" | "`loop'" =="r_pretaxCN_foy" {
				replace pop=pop*taxunitpop
			}
			if "`loop'"=="rtrav_FICN" {
				replace pop=pop*workagepop
			}
			keep year pop `loop'
			rename `loop' yav
			merge 1:m year using "`temp'"
			erase "`temp'"
			drop _merge
			gen sex=0
			bys year : egen ratio=sum(ytop*(gperc==0)/yav)
			foreach var of varlist thr ytop {
				replace `var'=`var'/ratio
			}
			drop ratio
			* Number of individuals
				bys year : egen ratio=sum(n/pop)
				replace n=n/ratio
				gen ntemp=0.01 
				replace ntemp=ntemp/10 if gperc>99
				replace ntemp=ntemp/10 if gperc>999
				replace ntemp=ntemp/10 if gperc>9999
				replace ntemp=ntemp*pop 
				replace n=ntemp if n==.
				drop ntemp ratio
			* Intermediate average
				gsort + year - gperc
				bys year : gen npop =sum(n)
				sort year gperc
				gen yint=(ytop*npop-ytop[_n+1]*npop[_n+1])/(npop-npop[_n+1]) if year==year[_n+1] 
				replace yint=ytop if gperc==99999
			* Round value
				foreach var of varlist yint thr {
					replace `var'=round(`var')
				}
			* Check error
				replace yint=thr if thr==thr[_n+1] & (yint>thr[_n+1] | yint<thr) & gperc~=99999
				replace thr=round((yint+yint[_n-1])/2) if (yint<thr[_n+1] & yint[_n-1]>thr[_n-1] & yint>yint[_n-1] & thr<yint[_n-1]) & gperc~=99999
				replace yint=round((thr+thr[_n+1])/2) if (thr>=yint[_n-1] & yint[_n-1]>=thr[_n-1] & thr<=thr[_n+1] & thr[_n+1]<=yint[_n+1] & thr>yint) & gperc~=99999
				gsort year -gperc
				bys year :gen tot=sum(n)
				bys year : gen tot2=sum(n*yint)
				replace ytop=tot2/tot 
				replace b=ytop/thr	
				drop npop tot tot2
			* Check
				sort year gperc
				gen prob=0
				replace prob=1 if thr>thr[_n+1] & year==year[_n+1]
				replace prob=1 if yint>thr[_n+1] & year==year[_n+1]
				replace prob=1 if yint<thr & year==year[_n+1]
				replace prob=1 if yint>yint[_n+1] & year==year[_n+1]
				tab year if prob==1
				drop prob
		* Save and export
			sort year gperc
			order year sex yav pop gperc n thr ytop b y0 
			save "$rawresults/gperc/gperc`loop'_19702014.dta",replace
			* Exportation to excel table	
				drop yav pop n sex y0 yint
				reshape wide thr ytop b,i(gperc) j(year)
				drop gperc 
				export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gperc`loop'")   sheetmodify cell(B13) firstrow(variables)
				clear
	}
	* b) by gender
	clear
	foreach loop of newlist rtrav_pretaxCN rtrav_FICN   { 
		forval i=1/2 {
			use "$rawresults/gperc/gperc`loop'.dta",clear
			keep year gperc sex  thr ytop b y0 n
			keep if sex==`i'
			drop sex
			tempfile temp
			save "`temp'",replace
		
		* Add interpolated years from Tom Programm
			foreach num of numlist 1971/1974 1976/1978 1980/1983 1985/1987 1989 1992 1993 2013 2014  {
				dis `num'
				clear
				if `i'==1 {
					insheet using "$rawresults/Pareto interpolations/`loop'_m/`num'.csv",    delimiter(",")
				}
				if `i'==2 {
					insheet using "$rawresults/Pareto interpolations/`loop'_w/`num'.csv",    delimiter(",")
				}
				drop year average
				cap replace b="" if b=="Inf"
				destring _all, replace 
				gen year=`num'
				gen gperc=round(p*100) if p<0.985
				replace gperc=round(p*1000) if  p<0.9985 & gperc==.
				replace gperc=round(p*10000) if  p<0.99985 & gperc==.
				replace gperc=round(p*100000) if  p>0.99985 & gperc==.
				drop p topsh
				rename topavg ytop
				replace thr=0 if thr<1
				replace b=. if thr==0
				append using "`temp'"
				erase "`temp'"
				tempfile temp
				save "`temp'",replace		
			}
			if `i'==1 {
			merge m:m year using "$rawresults/Pareto interpolations/`loop'_m/y0_`loop'_`i'.dta", update
			}
			if `i'==2 {
			merge m:m year using "$rawresults/Pareto interpolations/`loop'_w/y0_`loop'_`i'.dta", update
			}
			drop _merge
			erase "`temp'"
			tempfile temp
			save "`temp'",replace
		
		* Add other variables
			import excel using "$rawresults/exportresults_DINA.xlsx", first clear sheet("comptanat") cellrange(AB7:AU52) 
			replace pop=pop*1000
			if "`loop'"=="rtrav_pretaxCN"  {
				replace pop=pop*(sh_mpop*(`i'==1)+(1-sh_mpop)*(`i'==2))
			}
			if "`loop'"=="rtrav_FICN" {
				replace pop=pop*workagepop*(sh_mwpop*(`i'==1)+(1-sh_mwpop)*(`i'==2))
			}
			keep year pop `loop'_`i'
			rename `loop'_`i' yav
			merge 1:m year using "`temp'"
			erase "`temp'"
			drop _merge
			gen sex=`i'
			bys year : egen ratio=sum(ytop*(gperc==0)/yav)
			foreach var of varlist thr ytop {
				replace `var'=`var'/ratio
			}
			drop ratio
			* Number of individuals
				bys year : egen ratio=sum(n/pop)
				replace n=n/ratio
				gen ntemp=0.01 
				replace ntemp=ntemp/10 if gperc>99
				replace ntemp=ntemp/10 if gperc>999
				replace ntemp=ntemp/10 if gperc>9999
				replace ntemp=ntemp*pop 
				replace n=ntemp if n==.
				drop ntemp  ratio	
			* Intermediate average
				gsort + year - gperc
				bys year : gen npop =sum(n)
				sort year gperc
				gen yint=(ytop*npop-ytop[_n+1]*npop[_n+1])/(npop-npop[_n+1]) if year==year[_n+1] 
				replace yint=ytop if gperc==99999
			* Round value
				foreach var of varlist yint thr {
					replace `var'=round(`var')
				}
			* Check error
				replace yint=thr if thr==thr[_n+1] & (yint>thr[_n+1] | yint<thr)  & gperc~=99999
				replace thr=round((yint+yint[_n-1])/2) if (yint<thr[_n+1] & yint[_n-1]>thr[_n-1] & yint>yint[_n-1] & thr<yint[_n-1]) & gperc~=99999
				replace yint=round((thr+thr[_n+1])/2) if (thr>=yint[_n-1] & yint[_n-1]>=thr[_n-1] & thr<=thr[_n+1] & thr[_n+1]<=yint[_n+1] & thr>yint) & gperc~=99999
				gsort year -gperc
				bys year :gen tot=sum(n)
				bys year : gen tot2=sum(n*yint)
				replace ytop=tot2/tot 
				replace b=ytop/thr	
				drop npop tot tot2
			* Check
				sort year gperc
				gen prob=0
				replace prob=1 if thr>thr[_n+1] & year==year[_n+1]
				replace prob=1 if yint>thr[_n+1] & year==year[_n+1]
				replace prob=1 if yint<thr & year==year[_n+1]
				replace prob=1 if yint>yint[_n+1] & year==year[_n+1]
				tab year if prob==1
				drop prob			
		* Save and export
			sort year gperc
			order year sex yav pop gperc n thr ytop b y0 
			if `i'==1 {
				save "$rawresults/gperc/gperc`loop'_m_19702014.dta",replace
			}
			if `i'==2 {
				save "$rawresults/gperc/gperc`loop'_w_19702014.dta",replace
			}
			* Exportation to excel table	
				drop yav pop n sex y0 yint
				reshape wide thr ytop b,i(gperc) j(year)
				drop gperc 
				if `i'==1 {
					export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gperc`loop'_m")   sheetmodify cell(B13) firstrow(variables)
				}
				if `i'==2 {
					export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gperc`loop'_w")   sheetmodify cell(B13) firstrow(variables)
				}
				clear
		}
	}
	

		
	
	* I.2) Summary statistics for the distribution of income 
	***********************************************************
	
	foreach loop of newlist  r_irpp r_irpp_equal r_irpp_foy r_pretaxCN r_pretaxCN_equal r_pretaxCN_foy rcap rtrav_pretaxCN rtrav_pretaxCN_equal rtrav_FICN rtrav_FICN_m rtrav_FICN_w rtrav_pretaxCN_w rtrav_pretaxCN_m { 
			dis "`loop'"
			* Create the database
				clear
				set obs 45
				gen year =1969+_n
				gen gperc=0
				merge 1:m year gperc using "$rawresults/gperc/gperc`loop'_19702014.dta"
				keep year gperc sex  thr ytop b n y0
				drop sex 
			
			* Pop above the threshold
				gsort + year - gperc 
				bys year : gen npop =sum(n)
			* Definition of income groups
				keep if gperc==0 | gperc==10 | gperc==50 | gperc==90  | gperc==990 | gperc==9990 | gperc==99990 | gperc==99999 
			* Income shares
				sort year gperc
				bys year : egen ytot=sum(npop*ytop*(gperc==0))
				gen share=ytop*npop
				replace share=share[_n-1]-share if gperc==10 
				replace share=share-share[_n+2] if gperc==0 
				replace share=share-share[_n+1] if gperc==50  
				replace share=share/ytot
			* Other
				bys year : egen yav=sum(ytop*(gperc==0))
				replace yav=. if ytop==.
				gen thr_perc=thr/yav
			* Supress interpolated info above P99.9
				foreach var of varlist thr_perc share b thr {
							replace `var'`num'=. if year<1990 & year~=1970 & year~=1975 & year~=1979 & year~=1984 & year~=1988 & gperc>=9991
				}
				keep yav share thr_perc b thr year gperc y0
				reshape wide share thr_perc  b thr ,i(year yav y0 ) j(gperc)
				drop  year   thr0 b0   thr_perc0	
				order  yav share10  share* y0 thr_perc* b* thr*
			* Export
				export excel using "$rawresults/exportresults_DINA.xlsx", sheet("sumstat`loop'")   sheetmodify cell(B8) firstrow(variables)						
	}
	
	
	
* II) Income composition by decile and broad groups (pretax income, equal-split)
*********************************************************************************
	
	* 1) Income composition by broad groups
	*****************************************
		use "$rawresults/dperc/dpercr_pretaxCN_equal.dta",clear
		keep if sex==0
		drop sex
		gen share_wagepens=sh_sal_pretaxCN +sh_pension_pretaxCN
		drop sh_nonsal_labor_pretaxCN sh_nonsal_capital sh_rfon_owner sh_rfon_rent sh_rfin_div sh_rfin_av sh_rfin_int sh_rfin_liqu sh_sal_pretaxCN sh_pension_pretaxCN
		gen bperc=dperc
		replace bperc=0 if dperc<50
		replace bperc=50 if dperc >=50 & dperc<90
		foreach var of varlist sh_rtrav_pretaxCN- share_wagepens {
			replace `var'=`var'*share_dperc
		}
		collapse (sum) sh* ,by(year bperc)
		rename share_dperc share_bperc
		order year bperc share_bperc sh_rtrav_pretaxCN sh_rcap share_wagepens sh_nonsal_pretaxCN sh_rfon sh_rfin
		reshape wide sh*, i(year) j(bperc)
		foreach var of newlist share_bperc sh_rtrav_pretaxCN sh_rcap share_wagepens sh_nonsal_pretaxCN sh_rfon sh_rfin {
			replace `var'99=`var'99+`var'995+`var'999
			drop `var'995
			replace `var'90=`var'90+`var'95+`var'99
			drop `var'95
			gen `var'9=`var'90-`var'99
			gen `var'09=`var'99-`var'999
		}
		order *09,last
		* shares in % of total income
			export excel using "$rawresults/exportresults_DINA.xlsx", sheet("compo_sum")   sheetmodify cell(A8) firstrow(variables)
			
		
	* 2) Income composition by decile
	***********************************
		use "$rawresults/dperc/dpercr_pretaxCN_equal.dta",clear
		keep if sex==0
		drop sex
		gen share_wagepens=sh_sal_pretaxCN +sh_pension_pretaxCN
		drop sh_nonsal_labor_pretaxCN sh_nonsal_capital sh_rfon_owner sh_rfon_rent sh_rfin_div sh_rfin_av sh_rfin_int sh_rfin_liqu sh_sal_pretaxCN sh_pension_pretaxCN
		order year dperc share_dperc sh_rtrav_pretaxCN sh_rcap share_wagepens sh_nonsal_pretaxCN sh_rfon sh_rfin
		reshape wide sh*, i(year) j(dperc)
		* shares in % income share 
			export excel using "$rawresults/exportresults_DINA.xlsx", sheet("compo_det1")   sheetmodify cell(A8) firstrow(variables)
		* shares in % total income
			foreach var of newlist sh_rtrav_pretaxCN sh_rcap share_wagepens sh_nonsal_pretaxCN sh_rfon sh_rfin {
				foreach num of numlist 0(10)90 95 99 995 999 {
					replace `var'`num'=`var'`num'*share_dperc`num'
				}
			}
			export excel using "$rawresults/exportresults_DINA.xlsx", sheet("compo_det2")   sheetmodify cell(A8) firstrow(variables)

	* 3) Income composition by decile ordered by decile
	*****************************************************
		use "$rawresults/dperc/dpercr_pretaxCN_equal.dta",clear
		keep if sex==0
		drop sex
		gen share_wagepens=sh_sal_pretaxCN +sh_pension_pretaxCN
		drop sh_rtrav_pretaxCN sh_rcap  sh_nonsal_labor_pretaxCN sh_nonsal_capital sh_rfon_owner sh_rfon_rent sh_rfin_div sh_rfin_av sh_rfin_int sh_rfin_liqu sh_sal_pretaxCN sh_pension_pretaxCN
		order year dperc share_dperc share_wagepens sh_nonsal_pretaxCN sh_rfon sh_rfin
		foreach var of varlist share_wagepens-sh_rfin {
			replace `var'=`var'*share_dperc
		}
		replace dperc=0 if dperc<30
		collapse (sum) share_dperc-sh_rfin,by(year dperc)
		foreach var of varlist share_wagepens-sh_rfin {
			replace `var'=`var'/share_dperc
		}
		drop share_dperc
		reshape wide sh*, i(dperc) j(year)
		drop dperc
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("compo_det1_decile")   sheetmodify cell(B8) firstrow(variables)
	

* IV) Gender inequality (pre-tax labor, individualistic adults)
****************************************************************
			
	* 1) Proportion of women in top 10%, top 1% and top 0.1% of labor income distribution		
	****************************************************************************************	
		clear
		set obs 43
		gen year =1969+_n
		merge 1:1 year using "$rawresults/other/genderall.dta"
		drop _merge
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gender")   sheetmodify cell(A8) firstrow(variables)
		keep year
		merge 1:1 year using "$rawresults/other/gender2059.dta"
		drop _merge year
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gender")   sheetmodify cell(N8) firstrow(variables)

	* 2) Gender income ratio for all population or by age groups 1970-2012 (ordered by year)
	******************************************************************************************
		use "$rawresults/other/income_age_sex.dta",clear 
		drop if sex==0
		gen aged=0
		replace age=0
		append using "$rawresults/other/income_age_sex.dta"
		drop if sex==0
		replace aged=int(age/10)
		replace aged=8 if aged>8
		gen rtrav=rtrav_pretaxCN*n
		collapse (sum) rtrav n,by(year sex aged)
		replace rtrav=rtrav/n
		
		sort year aged sex
		reshape wide rtrav n, i(year aged) j(sex)
		gen ratio_m_w=rtrav1/rtrav2
		keep year aged ratio* n*

		tempfile base
		save "`base'",replace
		foreach var of numlist 0 2/8{ 
			use "`base'",clear
			keep if aged==`var'
			gen n=n1+n2
			lpoly ratio_m_w year  [aw=n], at(year)   generate(ratio_smoo) 
			if (`var'>0){
				append using "`temp'"
				erase "`temp'"
			}	
			tempfile temp
			save "`temp'", replace
		}
		drop n*
		reshape wide ratio_m_w ratio_smoo , i(year) j(aged)
		order year ratio_m_w* ratio_smoo*
		erase "`base'"
		tempfile base
		save "`base'",replace
		clear
		set obs 43
		gen year =1969+_n
		merge 1:1 year using "`base'"
		drop _merge
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gender_ratio")   sheetmodify cell(A8) firstrow(variables)
	
	* 3) Gender income ratio by exact age over the 1970-2012 period (ordered by age), Total income vs labor vs capital
	**********************************************************************************************************************
		use "$rawresults/other/income_age_sex.dta",clear 
		rename yav r
		rename rtrav_pretaxCN rtrav
		rename rcap_cn rcap
		foreach var of varlist  r rtrav rcap {
			bys year sex :  egen `var'all=sum(n*`var') 
			bys year sex :  egen n`var'all=sum(n)
			replace `var'all=`var'all/n`var'all
			drop n`var'all
		}
		sort year age sex
		reshape wide r* n , i(year age) j(sex)
		* gender income ratio and age-income profile
			foreach var of newlist r rtrav rcap {
				gen ratio_m_w`var'=`var'1/`var'2
				replace `var'0=`var'0/`var'all0
				drop `var'all*
			}
		keep year age ratio* n0			
		reshape wide ratio_m_wr ratio_m_wrtrav ratio_m_wrcap n0, i(age) j(year)
		
		foreach var of newlist r rcap rtrav {
			foreach year of numlist 1970 1975 1979 1984 1988 1990/2012{
				dis `year'
				if `year'~=1992 & `year'~=1993 {
					lpoly ratio_m_w`var'`year' age  [aw=n0`year'] if age>23, at(age)   generate(ratio_smoo`var'`year') 
				}
			}
		}
		drop n*
		drop ratio_m_wr1992 ratio_m_wr1993 ratio_m_wrtrav1992 ratio_m_wrtrav1993  ratio_m_wrcap1992 ratio_m_wrcap1993 
		order age ratio_m_wr???? ratio_m_wrtrav* ratio_m_wrcap* ratio_smoor???? ratio_smoortrav* ratio_smoorcap* 
		keep age ratio_m_w* ratio_smoo*
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("gender_ratio_age")   sheetmodify cell(A8) firstrow(variables)
			 		 
* V) Income inequality by age (pretax income, equal-split)
**********************************************************
	
	* 1) Summary statistics for the distribution of income by broad age groups (pretax income, equal-split)
	*********************************************************************************************************
		clear
		set obs 43
		gen year =1969+_n
		gen bperc=0
		gen bage=20
		merge 1:m year bage bperc using "$rawresults/other/bperc_bage_income_equal.dta"
		drop _merge
				
		* Income shares
			gsort + year bage - bperc 
			rename share_bperc_bage share
			* Above P90, share =Pxx-100
				bys year bage : gen temp =sum(share)
				replace share=temp if bperc>=90 & bperc<=999
			* For P0-50 :
				replace share=share + share[_n-1] if bperc==0 & bperc[_n-1]==10
			
		gen thr_perc=thr/ymean_bage	
		keep year bage bperc ymean_bage   share thr_perc b thr 
		reshape wide share thr_perc  b thr ymean_bage ,i(year bperc  ) j(bage)
		reshape wide share* thr*  b??  ,i(year ymean_bage??) j(bperc)
		drop share?010 thr?00 b?00  thr_perc?00
		order year ymean_bage20 share20* thr_perc20* b20* thr20* ymean_bage40 share40*  thr_perc40* b40* thr40* 
		order  ymean_bage60 share60*  thr_perc60* b60*  thr60*,last
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("sum_stat_bage")   sheetmodify cell(A8) firstrow(variables)

	* 2) Age-income profiles by years (ordered by age), Total vs capital vs labor pretax income
	********************************************************************************************
		use "$rawresults/other/income_age_sex_equal.dta",clear 
		drop if age>80
		keep if sex==0
		* Age-income profile (in % of the corresponding average income)		
			rename yav r
			rename rtrav_pretaxCN rtrav
			rename rcap_cn rcap
			foreach var of varlist  r rtrav rcap {
				bys year sex :  egen `var'all=sum(n*`var') 
				bys year sex :  egen n`var'all=sum(n)
				replace `var'all=`var'all/n`var'all
				drop n`var'all
			}
			sort year age sex
			reshape wide r* n , i(year age) j(sex)
			foreach var of newlist r rtrav rcap {
				replace `var'0=`var'0/`var'all0
				drop `var'all*
			}
		reshape wide r0 rtrav0 rcap0 n0  , i(age) j(year)
		* Smoothed  age-income profile
			foreach var of newlist r rcap rtrav {
				foreach year of numlist 1970 1975 1979 1984 1988 1990/2012{
					dis `year'
					lpoly `var'0`year' age [aw=n0`year'], at(age)    generate(`var'0_smoo`year')
				}
			}
		drop n*
		order age r0???? rtrav0???? rcap0???? r0_smoo* rtrav0_smoo* rcap0_smoo* ,last
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("age_income_year")   sheetmodify cell(A8) firstrow(variables)
		
	
* V) Correlation between labor income and wealth
***************************************************		

	* 1) Graph Labor income rank vs wealth rank P1-p100
	********************************************************
		
		use "$rawresults/other/matrixwealthincome.dta",clear
		keep if type=="Labor income"
		* Compute P99-100
			replace py=99000 if py >99000
			collapse (sum) w_gr*,by(year type py )
			reshape long w_gr, i(year type py) j(py_w)
			replace py_w=99000 if py_w >99000
			collapse (sum) w_gr,by(year type py py_w)
			foreach var of varlist py py_w {
				replace `var'=floor(`var'/1000)+1
			}
		* Proportion of individuals from a given fractile of labor income in each fractile of wealth
			bys year py : egen tot=sum(w_gr)
			replace w_gr=w_gr/tot
			drop tot
		* Average rank of wealth
			replace w_gr=w_gr*py_w
			collapse (sum) frac_w=w_gr,by(year py)
			rename frac_w py_w
			reshape wide py_w, i(year) j(py)
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("WYLrank1")   sheetmodify cell(A8) firstrow(variables)

	
	* 2) Table on correlation wealth rank * labor income rank by broad groups
	***************************************************************************
	
		use "$rawresults/other/matrixwealthincome.dta",clear
		keep if type=="Labor income"
		* Create broad groups
			reshape long w_gr, i(year type py) j(py_w)
			gen rank_w=0 if py_w<50000
			replace rank_w=50 if py_w>=50000 & py_w<90000
			replace rank_w=90 if py_w>=90000 & py_w<99000
			replace rank_w=99 if py_w>=99000 & py_w<99900
			replace rank_w=999 if py_w>=99900 
		
			gen rank_y=0 if py<50000
			replace rank_y=50 if py>=50000 & py<90000
			replace rank_y=90 if py>=90000 & py<99000
			replace rank_y=99 if py>=99000 & py<99900
			replace rank_y=999 if py>=99900 
				
			collapse (sum) w_gr*,by(year type rank_w rank_y )
			rename rank_w py_w
			rename rank_y py
		* Proportion of individuals from a given fractile of labor income in each fractile of wealth
			bys year py : egen tot=sum(w_gr)
			replace w_gr=w_gr/tot
			drop tot
			
		reshape wide w_gr , i(year type py) j(py_w)
		drop type
		export excel using "$rawresults/exportresults_DINA.xlsx", sheet("WYLrank2")   sheetmodify cell(A8) firstrow(variables)

	* 3) Proportion of individuals from different labor income groups in a given wealth group over time
		clear
		set obs 43
		gen year=1969+_n
		merge 1:m year using "$rawresults/other/matrixwealthincome.dta"
		replace type="Labor income" if type==""
		keep if type=="Labor income"
		
		* Create broad labor income groups
			reshape long w_gr, i(year type py) j(py_w)
			
			gen rank_y=0 if py<50000
			replace rank_y=50 if py>=50000 & py<90000
			replace rank_y=90 if py>=90000 & py<99000
			replace rank_y=99 if py>=99000 & py<99500
			replace rank_y=995 if py>=99500 
			
			gen rank_w=0 if py_w<50000
			replace rank_w=50 if py_w>=50000 & py_w<90000
			replace rank_w=90 if py_w>=90000 & py_w<99000
			replace rank_w=99 if py_w>=99000 & py_w<99500
			replace rank_w=995 if py_w>=99500 
				
			collapse (sum) w_gr*,by(year type rank_w rank_y)
			rename rank_w py_w
			rename rank_y py
			* Top 1% instead of top 1-0.5% wealth group
			sort year py py_w
			replace w_gr=w_gr+w_gr[_n+1] if py_w==99
			* Top 1% instead of top 1-0.5% labor income group
			sort year  py_w py
			replace w_gr=w_gr+w_gr[_n+1] if py==99 
		* Proportion of labor income groups in a given wealth group over time
			sort year py_w
			bys year py : egen tot=sum(w_gr*(py_w~=995))
			replace w_gr=w_gr/tot
			drop tot
			reshape wide w_gr, i(year type py) j(py_w)
			sort py year 
			foreach var of varlist w_gr* {
				rename `var' `var'l_gr
			}
			drop type
			reshape wide w_gr*, i(year) j(py)
			order year w_gr0* w_gr50* w_gr90* w_gr99* 
			order w_gr995*,last

		* Smooth
			foreach wnum of numlist 0 50 90 99 995 {
				foreach lnum of numlist 0 50 90 99 995 {
					lpoly w_gr`wnum'l_gr`lnum' year, at(year)   generate(sm_w_gr`wnum'l_gr`lnum')  bwidth(3) 
				}
			}
			
		* Export
			export excel using "$rawresults/exportresults_DINA.xlsx", sheet("WYLrank3")   sheetmodify cell(A8) firstrow(variables)
										

