****************************************************************
* Exportation of the results related to GGP2017DINA Appendix B *
****************************************************************
set more off
global projdir "C:/Users/John/Dropbox/WIDFrance/Papers"
global rawresults "$projdir/GGP2017DINA/GGP2017DINAAppendixB/StataFiles"
global param "$projdir/GGP2017DINA/GGP2017DINAAppendixA"
global rawresultsC "$projdir/GGP2017DINA/GGP2017DINAAppendixC/DataFiles/Results/gperc"

*Bertrand
global projdir "C:\Users\G839276\Dropbox\WIDFrance\Papers"
global rawresults "$projdir/GGP2017DINA\GGP2017DINAAppendixB\StataFiles"
global param "$projdir/GGP2017DINA/GGP2017DINAAppendixA"
global rawresultsC "$projdir/GGP2017DINA/GGP2017DINAAppendixC/DataFiles/Results/gperc"

* All results are exported in xls file exportresults_DINA_ApB


* I) Total cumulated growth and average growh rate: France
**********************************************************

	* Import GDP deflator index
			import excel using "$param/GGP2017DINAAppendixA.xlsx", first clear sheet("A0") cellrange(A7:Q169) 
			keep if _n>=48
			keep Year Q
			rename Year year
			rename Q priceindex
			destring year, replace
			tempfile temp
			save "`temp'",replace

	* Series of pre-tax income among equal-split adults by gperc 1900-2014
		use "$rawresults/gperc_income_1900_2014.dta",clear
		keep yint_ptinc_j ytop_ptinc_j year p f
		* convert in 2014 euros
			merge m:m year using "`temp'" 
			drop if _merge==2
			drop _merge
			erase "`temp'"
			foreach var of newlist yint ytop {
				rename `var'_ptinc_j  `var'
				replace `var'=`var'/100/6.55957 if year<1949
				replace `var'=`var'/priceindex*100
			}
			drop priceindex 
	save "$rawresults/temp/tempgrowth.dta", replace
				
				
	* A) By income groups (Bottom 50, Middle 40, Top 10...) and time periods (1900-1950, 1950-1983, 1983-2014, 1900-2014, 1950-2014)
	*******************************************************************************************************************************
		use "$rawresults/temp/tempgrowth.dta",clear
		gsort + year - p
		bys year : gen n=sum(f/1000)
		keep if p==0 | p==50000 | p==90000 | p==99000 | p==99900 | p==99990 
		keep if year==1900 | year==1950 | year==1983 | year==2014
		sort year p
		replace n=(p[_n+1]-p)/1000 if p<90000

		* Intermediate average income
			replace yint=((100000-p)*ytop-(100000-p[_n+1])*ytop[_n+1])/(p[_n+1]-p) if p<=90000 
			* P90-99 
				expand 2 if p==90000
				sort year p
				replace p=90990 if p[_n-1]==90000 & p==90000
				replace n=9 if p==90990
			* P90-100
				replace yint=ytop if p==90000 |  p>=99000
			* For Full population
				expand 2 if p==0
				sort year p
				replace p=-1 if p[_n+1]==0 & p==0
				replace n=100 if p==-1
				replace yint=ytop if p==-1
				keep year p yint n
		reshape wide yint, i(p) j(year)

		* Cumulative growth 
			forval loop=1/5 {
				if `loop'==1 {
					local i =1900
					local j =1950
				}
				if `loop'==2 {
					local i =1950
					local j =1983
				}
				if `loop'==3 {
					local i =1983
					local j =2014
				}
				if `loop'==4 {
					local i =1900
					local j =2014
				}
				if `loop'==5 {
					local i =1950
					local j =2014
				}
				gen agrowth_`i'`j'=(yint`j'/yint`i')^(1/(`j'-`i'))-1
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
				egen temp=sum((yint`j'-yint`i')*(p==-1))
				gen sharegrowth_`i'`j'=(yint`j'-yint`i')*n/100/temp
				drop temp
			}
		
		keep p agrowth* cgrowth* sharegrowth*
		export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("TB12")   sheetmodify cell(A1) firstrow(variables)

	
	* B) By detailed percentiles (gperc) and time periods (1900-1950, 1950-1983, 1983-2014) 
	****************************************************************************************
		use "$rawresults/temp/tempgrowth.dta",clear
		keep if (p>=20000 & p<=99990)	
		keep if year==1900 | year==1950 | year==1983 | year==2014
		replace yint=ytop if p==99990 	
		keep year p yint
		reshape wide yint, i(p) j(year)
		* Cumulative growth 
			forval loop=1/4 {
				if `loop'==1 {
					local i =1900
					local j =2014
				}
				if `loop'==2 {
					local i =1900
					local j =1950
				}
				if `loop'==3 {
					local i =1950
					local j =1983
				}
				if `loop'==4 {
					local i =1983
					local j =2014
				}
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
				gen agrowth_`i'`j'=(yint`j'/yint`i')^(1/(`j'-`i'))-1
			}
		
		keep p agrowth* cgrowth*
		order p cgrowth*
		export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("growthFR")   sheetmodify cell(A7) firstrow(variables)

		
	* C) Robustness checks for period around 1983-2014
	****************************************************
		use "$rawresults/temp/tempgrowth.dta",clear
		keep if (p>=20000 & p<=99990)	
		keep if (year>=1982 & year <=1984) | (year>=2012 & year <=2014)
		replace yint=ytop if p==99990 	
		keep year p yint
		reshape wide yint, i(p) j(year)
		* Cumulative growth 
			forval loop=1/3 {
				if `loop'==1 {
					local i =1984
					local j =2012
				}
				if `loop'==2 {
					local i =1983
					local j =2012
				}
				if `loop'==3 {
					local i =1984
					local j =2014
				}
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
			}
		keep cgrowth*
		export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("growthFR")   sheetmodify cell(K7) firstrow(variables)
	
	* D) By types of income over 1983-2014 perid
	****************************************************************************************
		
		* Import GDP deflator index
			import excel using "$param/GGP2017DINAAppendixA.xlsx", first clear sheet("A0") cellrange(A7:Q169) 
			keep if _n>=48
			keep Year Q
			rename Year year
			rename Q priceindex
			destring year, replace
			tempfile temp
			save "`temp'",replace
		
		* Series of income
			foreach type of newlist r_pretaxCN_equal rtrav_pretaxCN_equal rtrav_pretaxCN rtrav_pretaxCN_m rtrav_pretaxCN_w rtrav_FICN rtrav_FICN_m rtrav_FICN_w {
				use "$rawresultsC/gperc`type'_19702014.dta",clear
				* Percentile
					gen p =gperc
					replace p=p*10 if gperc<99990
					replace p=p*10 if gperc<9990
					replace p=p*10 if gperc<990
				keep if (p>=20000 & p<=99990) 
				* Intermediate average
					replace yint=((100000-p)*ytop-(100000-p[_n+1])*ytop[_n+1])/(p[_n+1]-p) 
					replace yint=(thr+thr[_n+1])/2 if yint<thr | yint>thr[_n+1]
					replace yint=ytop if p==99990

				keep yint year p 
				* convert in 2014 euros
					merge m:m year using "`temp'" 
					drop if _merge==2
					drop _merge
					foreach var of varlist yint  {
						replace `var'=`var'/priceindex*100
					}
					drop priceindex 
		* Income growth 
			reshape wide yint, i(p) j(year)
			local i =1983
			if "`type'" =="rtrav_FICN_w" | "`type'" =="rtrav_pretaxCN_w" {
				local i=1984
			}
			local j =2014
			gen growth_`type'=(yint`j'/yint`i'-1)
			keep p g*
			if "`type'" ~="r_pretaxCN_equal" {
				merge 1:1 p using "`temp2'"
				drop _merge
			}
			tempfile temp2
			save "`temp2'", replace
		}
		drop p
		order growth_r_pretaxCN_equal growth_rtrav_pretaxCN_equal growth_rtrav_pretaxCN growth_rtrav_pretaxCN_m growth_rtrav_pretaxCN_w growth_rtrav_FICN growth_rtrav_FICN_m growth_rtrav_FICN_w
		export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("growthFR")   sheetmodify cell(O7) 	firstrow(variables)

	* E) By percentiles (gperc)1983-2014
	*************************************
		use "$rawresults/temp/tempgrowth.dta",clear
		keep if (p>=20000 & p<=99000)	
		keep if year==1983 | year==2014
		replace yint=ytop if p==99000 	
		keep year p yint
		reshape wide yint, i(p) j(year)
		* Cumulative growth 
			forval loop=1/1 {
				if `loop'==1 {
					local i =1983
					local j =2014
				}
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
				gen agrowth_`i'`j'=(yint`j'/yint`i')^(1/(`j'-`i'))-1
			}
		
		keep p agrowth* cgrowth*
		order p cgrowth*
		drop p
		export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("growthUS")   sheetmodify cell(F7) firstrow(variables)
		
			
* II) Total cumulated growth and average growh rate: US
********************************************************
	
	* A) By income groups (Bottom 50, Middle 40, Top 10...) 1983-2014
	*******************************************************************************************************************************
		insheet using "$rawresults/tables/US.csv",clear  delimiter(";")
		drop if _n==1
		*keep year perc ?ptinc992j npopul992i
		keep year perc aptinc992j optinc992j
		sort year perc
		destring _all, replace
		keep if year==1983 | year==2014
		
		* Harmonization of percentile name
			forval i=2/7 {
				drop if substr(perc,`i',1)=="p" 
			}
			drop if substr(perc,2,1)=="a" 
			gen p=substr(perc,2,.) 
			destring p, replace
			replace p=p*1000
			drop perc
			sort year p
		
		
		tempfile temp
		save "`temp'",replace
		forval pas=1/2 {
			use "`temp'",clear
			if `pas'==1 {
				keep if (p>=20000 & p<=99990)		
				replace aptinc992j=optinc992j if p==99990	
			}
			if `pas'==2 {
				keep if (p>=20000 & p<=99000)		
				replace aptinc992j=optinc992j if p==99000	
			}
		rename aptinc992j yint
		keep year p yint
		reshape wide yint, i(p) j(year)
		* Cumulative growth 
			forval loop=1/1 {
				if `loop'==1 {
					local i =1983
					local j =2014
				}
				gen cgrowth_`i'`j'=(yint`j'/yint`i'-1)
				gen agrowth_`i'`j'=(yint`j'/yint`i')^(1/(`j'-`i'))-1
			}
		
		keep p agrowth* cgrowth*
		order p cgrowth*
		if `pas'==1 {
			export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("growthUS")   sheetmodify cell(A7) firstrow(variables)
		}
		if `pas'==2 {
			drop p
			export excel using "$rawresults/tables/exportresults_DINA_ApB.xlsx", sheet("growthUS")   sheetmodify cell(D7) firstrow(variables)
		}
	}
			
		
		
		
		
		