* Diff entre fiscal income excl cap gain (microfiles vs tabulations)

cd "$projdir/GGP2017DINAAppendixC/"
			* gperc of fiscal income including capital gains or excluding capital gains from microfiles
				use year gperc thr ytop using DataFiles/Results/gperc/gpercr_irpp_foy_icg.dta, clear
				foreach var of varlist thr ytop {
					rename `var' `var'_icg
				}
				* Percentile
					gen p =gperc
					replace p=p*10 if gperc<99990
					replace p=p*10 if gperc<9990
					replace p=p*10 if gperc<990
				foreach var of newlist _icg {
						gen yint`var'=ytop`var' if p==99999
						replace yint`var'=((100000-p)*ytop`var'-(100000-p[_n+1])*ytop`var'[_n+1])/(p[_n+1]-p) if p<99999
						replace yint`var'=min(max(yint`var', thr`var'), thr`var'[_n+1]) if p<99999
					}
					
				
cd "$projdir/GGP2017DINAAppendixD/"
			merge 1:1 year p using StataFiles/gperc_fiscalincome_1900_2014.dta
			keep if year>=2003
			keep year-p yint_icg ythr_fiinc_t yint_fiinc_t ytop_fiinc_t
			gen coef=yint_icg/yint_fiinc_t

			
* For income groups
				cd "$projdir/GGP2017DINAAppendixC/"
				use DataFiles/Results/gperc/gpercr_irpp_foy_19702014.dta,clear
				foreach var of varlist thr ytop {
					rename `var' `var'_ecg
				}
				keep if year >=2003 & sex==0
				* Percentile
					gen p =gperc
					replace p=p*10 if gperc<99990
					replace p=p*10 if gperc<9990
					replace p=p*10 if gperc<990
				keep if p==0 | p==90000 | p==95000 | p==99000 | p==99500 | p==99900  | p==99990 | p==99999
				foreach var of newlist _ecg  {
						gen yint`var'=ytop`var' if p==99999
						replace yint`var'=((100000-p)*ytop`var'-(100000-p[_n+1])*ytop`var'[_n+1])/(p[_n+1]-p) if p<99999
						replace yint`var'=min(max(yint`var', thr`var'), thr`var'[_n+1]) if p<99999
				}
				keep year p yint_ecg
				tempfile temp
				save "`temp'",replace
				* Merge with tabulation including capital gains
					cd "$projdir/GGP2017DINAAppendixD/"
					use StataFiles/gperc_fiscalincome_1900_2014.dta,clear
					keep if year>=2003
					replace p=0 if p<90000
					replace p=90000 if p>=90000 & p<95000 
					replace p=95000 if p>=95000 & p<99000 
					replace p=99000 if p>=99000 & p<99500 
					replace p=99500 if p>=99500 & p<99900 
					replace p=99900 if p>=99900 & p<99990 
					replace p=99990 if p>=99990 & p<99999 
					collapse (mean) yinttu [aw=f],by(year p)
					merge 1:1 year p using "`temp'" 
					gen coef=yinttu/yint_ecg 
					keep year coef p
					reshape wide coef, i(year) j(p)
					save StataFiles\temp\capgaingroup.dta, replace
				
			* by percentile
