************************************************************************************************************************
* Demographic structure of the decedents for years 1998/2002 2006 and 2010 using INSEE data  (Donnes de l'Etat civil) *
************************************************************************************************************************

foreach year of numlist 1998/2002 2006 2010 {
	
	import excel using "$param/Decedents/RawData/DEC`year'.xlsx", first clear sheet("DEC`year'") 
	foreach var of varlist _all {
		local j=upper("`var'")
		rename `var' `j'
	}
	keep ADEC MDEC DEPDEC SEXE ANAIS ETAMAT 
	destring ADEC- ETAMAT,replace
	* Decedents in France Metropolitaine
		drop if DEPDEC=="97"
		drop DEPDEC
	
	gen year=`year'		
		
	* Age 
		* Age = Age during the year
		gen age = ADEC-ANAIS
		drop ADEC MDEC ANAIS
		
		* decenial age
			gen aged=int(age/10)
			replace aged=9 if aged>9
			
	tempfile temp
	save "`temp'",replace
		
*************************************************************************************************************************************************
* Export to RawResults_ApD Table D3 for years 1998-2002
********************************************************
	if (`year'>=1998 & `year'<=2002) {
		gen number=1
		collapse (sum) number,by(year SEXE aged)
		sort SEXE aged
		order year SEXE aged number
		reshape wide number, i(SEXE) j(aged)
		foreach var of varlist number* {
			replace `var'=`var'/1000
		}
		local i=`year'-1984+10
		tempfile c
		save "`c'", replace
		keep if SEXE==1
		drop year SEXE
		export excel using "$resDMTG/RawResults_ApD.xlsx", sheet("TableD3(m)")  sheetmodify cell(C`i') 
		use "`c'",clear
		erase "`c'"
		keep if SEXE==2
		drop year SEXE
		export excel using "$resDMTG/RawResults_ApD.xlsx", sheet("TableD3(f)")  sheetmodify cell(C`i') 
	}
***************************************************************************************************************************************************	
	use "`temp'",clear
	erase "`temp'"
	
	drop if age <20
	tempfile a 
	save "`a'",replace
	
	
	gen ndecf`year'=0
	replace ndecf`year'=1 if SEXE==2
 	gen ndech`year'=0
	replace ndech`year'=1 if SEXE==1

	collapse (sum) ndecf`year' ndech`year',by(year age)
	tempfile b
	save "`b'",replace
	
	use "`a'",clear
	erase "`a'"
	foreach var of newlist  pCh`year' pMh`year' pVh`year' pDh`year' pCf`year' pMf`year' pVf`year' pDf`year' {
		gen `var'=0
	}
	* sex
		foreach var of varlist  pCh`year' pMh`year' pVh`year' pDh`year'  {
			replace `var'=1 if SEXE==1
		}
		foreach var of varlist  pCf`year' pMf`year' pVf`year' pDf`year'  {
			replace `var'=1 if SEXE==2
		}
	* Matrimonial status
		foreach var of varlist pCh`year' pCf`year' {
			replace `var'=0 if `var'==1 & ETAMAT ~=1
		}
		foreach var of varlist pMh`year' pMf`year' {
			replace `var'=0 if `var'==1 & ETAMAT ~=2
		}
		foreach var of varlist pVh`year' pVf`year' {
			replace `var'=0 if `var'==1 & ETAMAT ~=3
		}
		foreach var of varlist pDh`year' pDf`year' {
			replace `var'=0 if `var'==1 & ETAMAT ~=4
		}
	
	
	collapse (mean) pCh`year'-pDf`year',by(year SEXE)
	collapse (max) pCh`year'-pDf`year',by(year)

	merge 1:m year using "`b'"  
	erase "`b'"
	drop year _merge
	gen penf0=0.23
	save "$param/Decedents/demofile`year'.dta", replace

}
