/*****************************************************************************************
 do-file utilise pour convertir le fichier brut DMTG 1994 en un fichier 
corrig avec variables wf94succ.dta et wf94her.dta
******************************************************************************************/


set more off


clear

* Note : en 1994 et en 2000: exo assurance-vie = primes verses aprs 70 ans jusqu' abattement de 305000 euros ce qui explique pourquoi cette variable (f4) ne doit pas dpasser 30500 euros par hritier. Il se peut qu'il y ait un montant exo_avie trs lev alors que le nbre d'hritiers est faible. Hyptohse : pas de dclaration de succession pour les hritiers qui ne touchent que l'a-vie exonre. Il faudrait checker.

* Retraitement et homognisation du fichier fiscal
	
	/* 
	Dans le fichier brut, pour chaque acte de succession, on dispose de diffrentes lignes correspondant :
					_ d'abord aux informations relatifs aux dfunts et  l'actif transmis
	On retraite le fichier de faon  avoir deux types de fichiers : 
					_ le premier correspond au niveau de la succession wf94succ
					_ le second est au niveau des hritiers wf94her mais incorpore toutes les informations du dfunt (qui sont donc communs  l'ensemble des hritiers d'une mme succession)
	
	
	*/

***********************************************************************
* I) Cration du fichier au niveau de l'acte de succession : wf94.dta* 
***********************************************************************
	* Il va falloir mettre en cohrence les date naissances dcs des hritiers et dfunts abrantes
	* Il faudra peut tre imputer les PCS manquantes
	* Je laisse donc les valeurs abrrantes, on verra plus tard
	* pour date de dcs abrrantes, se servir galement de la date du dpot de la dclaration (datenr)
	use "$dataDMTG/DMTG94.dta", clear
		
	gen year=1994
	
/* A) Retraitement des donnes */

	/* Characteristics of the estate */
	
		* Cration d'un identifiant par acte de succession (idsucc) et d'un identifiant hritier par acte (idher)
				keep if mutation=="S"
				gen idsuc=substr(benef,1,13)
			
			* Lien de parent : harmonisation des liens avec 2000 de l'hritier le plus proche au plus loign
				gen lien=m1
				replace lien=0 if m1==3
				* 4 liens abrrants  recoder : des dfunts polygames dont la deuxime femme est en fait l'enfant + un conjoint dupliqu en trois exemplaires
				*bys idsuc : egen tot=total(lien==1)		
				*sort tot idsuc
				*order lien c3 l4,last 
				replace lien = 0 if idsuc=="9210451801014" & l4=="07196392"
				replace lien=0 if idsuc=="9500351801002"
				drop if benef =="670035180100601" | benef== "670035180100603"
				replace lien=0 if idsuc=="7100252801001" & l4 ~="02190371"
							
				sort idsuc lien 
				gen x=0
				replace x=1 if idsuc~=idsuc[_n-1]
				gen idsucc=1 if _n==1
				replace idsucc=idsucc[_n-1]+x if _n>1
				gen idher=1 if x==1
				replace idher=idher[_n-1]+1 if x==0
				sort idsucc idher
		
		* Pondration
			/* dj appel pondn */
		
		* Echantillonage par tranche de patrimoine
			gen weight = 50 if a3 >0 
			replace weight = 10 if a4>0
			replace weight=1 if a3==0 & a4==0
			
		* PSU : direction des services fiscaux (centres dpartementaux)
			gen psu = substr(sages,1,4)
			replace psu=substr(psu,1,3)+"0" if substr(psu,-1,1)=="1"
			
	
		* Nbre de bnficiaires
			bys idsucc : egen nher=max(idher)
			sort idsucc idher
			drop sages-mutat noenrdon-c10 
			
	/* Caractristiques du dfunt */

		* Anne du dcs
			gen yeardec = real(substr(datedec,3,4))
			replace yeardec=1993 if yeardec <1977
			* checker les date avant 1986
			
		* Anne de naissance et ge  la mort
			gen birth = real(substr(c3,3,4))
			replace birth=. if birth==0
		    *replace birth=1994 if birth==1996
			*replace birth=1895+int(40*uniform()) if birth==0 | birth==.
			gen age=yeardec-birth 

		* Nbre d'enfants
			sort idsucc
			bys idsucc : egen nenf=total(lien==0)
			sort idsucc idher
			gen nenf01=0 if nenf==0
			replace nenf01=1 if nenf>0
			sort idsucc idher
		
		* PCS
			gen pcs_d = real(c4)
			replace pcs_d = pcs_d/10 if pcs_d/10 == int(pcs_d/10)
			replace pcs_d = 0 if pcs_d ==. | pcs_d==99
			replace pcs_d = 6 if pcs_d==69
			replace pcs_d = 8 if pcs_d==88
			gen pcs = pcs_d
			replace pcs = int(pcs_d/10) if pcs_d >= 10
			
		* Dpartement
			gen dep=c5
			replace dep= 0 if dep==99 | dep==.
			
		* Rgime et statut matrimonial	
			gen mat=c7
			replace regmat=3 if regmat==4
			replace regmat=0 if mat~="M"
			
		* sexe 
			gen sexe=0 if c6==1
			replace sexe=1 if c6==2
			* pour les valeurs manquantes, imputation alatoire quand non mari, sexe oppos du conjoint quand mari
			replace sexe = 0 if sexe==. & mat=="M" & lien==1 & l3==2
			replace sexe = 1 if sexe==. & mat=="M" & lien==1 & l3==1
			bys idsucc : egen sexe2 = min(sexe) 
			replace sexe = sexe2 if sexe==. & sexe2~=.
			drop sexe2
			replace sexe=int(uniform()+0.5) if sexe==. &  idher==1
			bys idsucc : egen sexe2 = min(sexe) 
			replace sexe = sexe2 if sexe==. & sexe2~=.
			drop sexe2
					
					
		* revenu fiscal du foyer
			replace rbg=rbg/6.55957
			replace rbg=0 if rbg<0 | rbg==.
			gen ir=impotnet/6.55957
			replace ir=0 if ir<0 | ir==.
			

	/* Caractristique de l'actif de succession */
	
	
	
		* Actifs de succession :
	
			* Bien que l'actif net corresponde en moyenne  la somme des parts des hritiers en moyenne et au niveau individuel dans 92% des cas (voir module verif  la fin du do-file), il vaut mieux dfinir actnet comme la somme des parts nettes pour viter les 8% d'erreur qui sont souvent des grosses successions. Le plus souvent c'est souvent un mauvais placement de virgule ou alors une mauvaise prise en compte de l'ensemble des hritiers qui cre le problme.
			* Ex : pour les idsucc = 1954,311,531, 1626, 2469 actnet est faux.
			* Au contraire pour la succession 480, c'est partnette qui est 100 fois plus grand que l'actif net et cela n'est pas du tout cohrent avec les droits pays.
	
			bys idsucc : egen actnet=sum(n1/6.55957)
			replace actnet=j6/6.55957 if idsuc=="1800351000003" /* Le redressement de cette succession fait baisser de 2000 euros la moyenne des successions ! */
			gen legs=max(j26,j5)/6.55957
			gen actnetimpos= max(actnet-legs,0)
			gen passif = max(j4,j24+j15/2)/6.55957
			* Pour la succession 1160, il y a eu une erreur de case, l'actif net j6 a t plac dans la case passif. On a donc j6 =0 alors que somme des parts nettes =passif
			replace passif = 0 if idsuc =="4400352801015"
			gen actbrut=actnet+passif
		
		
		* Composition de la succession 
				* Attention, la somme des composantes de l'actif brut n'est pas gal  l'actif brut dans certains des cas. Voir fin du do-file pour plus de dtail. 
				* On ne prend donc pas les montants reports mais la part de chaque type d'actif dans le total multipli ensuite par l'actif brut sauf pour les biens exos videmment.
				
				* Retraitement des actifs exos
					replace f1=3*h4 if h4>0 & f1==0
					replace f3=3*h3 if h3>0 & f3==0
					replace f2=3*h5 if h5>0 & f2==0
					gen pat_exo=(f1+f2+f3+f4+f5+f6)/6.55957
				/* composante de biens exos */
					gen patfin_av_exo = f4/6.55957
					gen patpro_exo = (f1+f2+f3)/6.55957
					gen patfin_div_exo = 0
					gen patfin_int_exo = 0
					gen patfon_brut_exo = (f5)/6.55957
					gen patfin_liqu_exo = (f6)/6.55957
				
				/* Catgories d'actifs taxables
				patfon_brut : logement (housing assets) = immeubles  husages d'habitation et monuments historiques + forfait mobilier
				patpro : non-housing tangible assets (unincorporated business + land) = immeubles  usage prof (non agricoles) + exploitations agricoles + biens ruraux + part de groupement foncier agri + bois + autres immeubles non batis + fonds de commerce + clientles) + autres meubles corporels 
				patfin_div : public equity and mutual funds (valeurs mob ctes) + private equity (val mob non ctes)
				patfin_int : obligations  ; bons ngociables, droits sociaux divers  et parts de SCI de gestion ; creances
				patfin_av : life insurance (assurances-vie)
				patfin_liqu : savings & checking accounts,.. = liquidits 
				*/
				
				gen patfin_av = g11/6.55957
				gen patfon_brut = (h7+h9+g13+max(j2,j22))/6.55957
				gen patpro=(h1+h2+h3+h4+h5+h6+g1+g2)/6.55957
				gen patfin_div = (max(g4-g6,0)+g3)/6.55957
				replace patfin_div=0 if patfin_div<0
				gen patfin_int=(g6+g9+g10)/6.55957
				replace patfin_int=0 if patfin_int<0
				gen patfin_liqu= (g12)/6.55957
				
				
				gen tot = patfon_brut+patpro+patfin_int+patfin_div+patfin_av+patfin_liqu
				foreach var of varlist patfon_brut patpro patfin_int patfin_div patfin_liqu patfin_av {
					replace `var'=`var'/tot*actbrut if tot~=0
					replace `var'=0 if actbrut==0 | tot==0
				}
				drop tot 
				gen part_bienpro = 0 /* n'existe pas en 2000 */

	
	
	
		* Rappel des donations antrieures et dons manuels 
			* Retraitement de donations de 1 ou 2 Fr
				foreach var of varlist k2 k3 k5 k6 {
					replace `var'=0 if `var' <10
				}
				bys idsucc : egen dons10moins=max(k2/6.55957)
				bys idsucc : egen  dons10plus=max(k3/6.55957)
				bys idsucc : egen  donsman=max((k5)/6.55957)
				gen donations= dons10moins+dons10plus+donsman

			* Rajout par rapport  Piketty
			gen nb_donant = 0
			forval i = 1/4 {
				gen temp`i' = 0
				replace temp`i' = real(substr(k4,-2*`i',2)) if real(substr(k4,-2*`i',2))~=. 
				replace nb_donant = `i' if (temp`i'> 0)
			}
			* Ecart entre la date de la mort et celle de la donation (de la plus ancienne  la plus rcente) :
				forval i = 1/4 {
					gen date_dons`i' = 0
					replace date_dons`i' = yeardec -1900-temp`i' if temp`i'>0
				}
				replace date_dons1 = yeardec-1900-temp4  if nb_donant == 4 & temp1 > temp2
				replace date_dons2 = yeardec-1900-temp3  if nb_donant == 4 & temp1 > temp2
				replace date_dons3 = yeardec-1900-temp2  if nb_donant == 4 & temp1 > temp2
				replace date_dons4 = yeardec-1900-temp1  if nb_donant == 4 & temp1 > temp2
				
				replace date_dons1 = yeardec-1900-temp3  if nb_donant == 3 & temp1 > temp2
				replace date_dons3 = yeardec-1900-temp1  if nb_donant == 3 & temp1 > temp2
				
				replace date_dons1 = yeardec-1900-temp2  if nb_donant == 2 & temp1 > temp2
				replace date_dons2 = yeardec-1900-temp1  if nb_donant == 2 & temp1 > temp2
				* recodage
				replace date_dons1 = round(8*uniform()+1) if (idsuc== "7560253801013" |idsuc=="7560254801021") & idher==1
				bys idsucc : egen a = min(date_dons1) if (idsuc== "7560253801013" |idsuc=="7560254801021")
				replace date_dons1 = a if (idsuc== "7560253801013" |idsuc=="7560254801021")
				drop a
				
			* Retraitement des donations non mentiones au niveau dfunt mais renseignes au niveau hritier
				bys idsucc : egen verif=sum(n6/6.55957)
				replace dons10moins=verif if dons10moins==0 & dons10plus==0 & verif >0
				gen prob=1 if dons10plus/verif> 0.98 & dons10plus/verif<1.02 & dons10moins==0 & nb_donant >0 & date_dons1 < 10 & dons10plus >0 & verif >0
				bys idsucc : egen probt=min(prob)
				replace dons10moins=dons10plus if probt==1
				replace dons10plus=0 if probt==1
				drop verif prob probt

				
				bys idsucc : egen verif=sum((n8+n7)/6.55957) if nb_donant>0 & donations==0 & n7 >0
				gen prob=1 if dons10moins==0 & verif~=. & date_dons1<10
				bys idsucc : egen probt=min(prob)
				replace dons10moins=verif if probt==1
				drop prob probt verif

				* Dcalage d'une case : report donation en n7 plutt que n6
				gen prob=1 if (n7 >0 | n8 >0) & (dons10moins==0 & dons10plus==0)
				bys idsucc : egen probt=min(prob)
				bys idsucc : egen verif=sum(n7/6.55957) if probt==1
				replace dons10moins=verif if probt==1
				drop prob verif probt
				replace donations=dons10moins+dons10plus+donsman

				
				
		* DMTG global
			gen droitsnetstemp=k1/6.55957 if idher==1
			bys idsucc : egen droitsnets=min(droitsnetstemp)
			drop droitsnetstemp
			
	/* Caractristique des hritiers */
		
			* Infos socio-dmohraphiques
			
				* Indicatrice hritier = personne morale
				gen persmor = 0
				replace persmor = 1 if l1==2 & lien==9
				
				gen birthher=real(substr(l4,3,4)) if length(l4)==8 & (real(substr(l4,3,2))==19 | real(substr(l4,3,2))==18)
				replace birthher=real(substr(l4,5,4)) if length(l4)==8 & birthher == . & (real(substr(l4,5,2))==19 | real(substr(l4,5,2))==18)
				replace birthher=real(substr(l4,3,4)) if length(l4)==6 & real(substr(l4,3,2))==19
				replace birthher=real(substr(l4,-6,4)) if length(l4)==6 & real(substr(l4,-6,2))==19
				replace birthher=real(substr(l4,3,4)) if length(l4)==7 & real(substr(l4,3,2))==19
				replace birthher = 9999 if persmor==1

				gen ageher=yeardec-birthher 
				replace ageher = 0 if birthher == 0 | birthher == 9999
				
				* Dpartement de naissance : depher_naiss, dpartement du domicile : depher
				gen depher_naiss = real(substr(l4,7,2)) if length(l4)==8
				replace depher_naiss = 0 if depher_naiss ==99|depher_naiss==.
				gen depher = l6	
				replace depher = 0 if depher ==99|depher==.

				
				gen sexeher=0 if l3==1
				replace sexeher=1 if l3==2
				* recodage de sexeher : sexe oppos du conjoint et alatoire quand non conjoint
				replace sexeher = 0 if sexe ==1 & lien==1 & sexeher==.
				replace sexeher = 1 if sexe==0 & lien==0 & sexeher==.
				replace sexeher=int(uniform()+0.5) if sexeher==. 

				gen pcsher_d=real(l7)
				replace pcsher_d = pcsher_d/10 if pcsher_d/10 == int(pcsher_d/10)
				replace pcsher_d = int(pcsher_d/10) if (pcsher_d >=10 & pcsher_d <= 30) | pcsher_d > 70
				gen pcsher = pcsher_d
				replace pcsher=int(pcsher_d/10) if pcsher_d>=10
				
				
				
				*gen nbenf_her = 0
				*replace nbenf_her = real(l8) if real(l8)~=99 &  real(l8)~=.
				
				
		
			
			* DMTG et actifs des hritiers
			
				gen partnet=n1/6.55957
				replace partnet=j6/6.55957 if idsuc=="1800351000003"
				gen exosperso=n2/6.55957
				replace exosperso=0 if exosperso<0
								
				gen donman=n4/6.55957
				gen don10moins=n6/6.55957
				gen don10plus=0
				replace don10moins = donman if idsuc=="8300653801005"
				replace donman=0 if idsuc=="8300653801005"
				gen don=donman+don10moins+don10plus

				gen parttaxable=n5/6.55957
				replace parttaxable=partnet if idsuc=="1800351000003"

				gen abatdons=n7/6.55957
				gen parttaxeedonant=n8/6.55957
				gen abat=n9/6.55957
				gen parttaxee=n10/6.55957
				replace parttaxee=0 if parttaxee==0
				replace parttaxee=(j6-300000)/6.55957 if idsuc=="1800351000003"

				
				gen droitsbruts=p1/6.55957
				replace droitsbruts=0 if droitsbruts<0
				gen dtsnets=p7/6.55957
				
			
		keep pondn-dtsnets  regmat
		drop impotnet
		order year idsucc idher pondn weight
			
			
	
/* B)  Recodage des donnes manquantes ou abrrantes */
	
	/* Reprage des donnes abrrantes qu'on remplace par un . */
	
		* Date de naissance
			* Pour les gens ns aprs 1988 : problme s'ils ont des enfants ou sont marris
			* Problme si date de naissance > 1994
			replace birth=. if birth > 1971
	
			sort idsucc lien birthher
			
			

		* controle de cohrence date de naissance des hritiers et du dfunt
			* Seulement deux successions avec enfant qui pose problme
		
			gen prob=1 if birth> birthher & birth~=. & lien==0
			replace prob=0 if prob==.
			bys idsucc : egen a =sum(prob)
			bys idsucc : egen age_fr = mean(birthher-birth) if prob~=1 &lien==0 & a==1
			bys idsucc : egen age_fr2=min(age_fr) if  a == 1
			*order birth birthher sexe lien idsucc, last
			replace birthher=. if prob==1 & age_fr2 > 15 & age_fr2~=.
			replace birth=. if a==1 & age_fr2 < 15
			drop prob a age_fr*
			
			replace age =yeardec-birth 
			
		* Classement des individus
			sort idsucc lien birthher
			drop idher x
			gen x=0
			replace x=1 if idsuc~=idsuc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher 
			
	tempfile a
	save "`a'", replace
		
	/* Imputation des dates de naissance manquantes */
		
		* Pour les dfunts
			* On fait un petit reshape maison pour pouvoir avoir une ligne par succession avec les hritiers qui nous intresse en colonne
			
		
			gen femmetemp=1 if lien==1
			replace femmetemp=0 if femme==.
			gen birthtemp =birthher if femmetemp==1
			replace birthtemp=0 if birthtemp==.
			bys idsucc :  egen femme = sum(femmetemp)
			bys idsucc :  egen birthfemme = sum(birthtemp)
			drop birthtemp femmetemp
			
			sort idsucc idher
			forval i =1/2 {
				gen enftemp`i'=0
				gen birthenftemp`i'=0
				replace enftemp`i'=1 if idher==`i' & nenf>=`i'
				replace birthenftemp`i'=birthher if idher==`i' & nenf>=`i'
				bys idsucc :  egen enf`i' = sum(enftemp`i')
				bys idsucc :  egen birthenf`i' = sum(birthenftemp`i')
			}
			drop birthenftemp* enftemp*
			
			sort idsucc idher
			forval i =1/2 {
				gen freretemp`i'=0
				gen birthfreretemp`i'=0
			}
			replace freretemp1=1 if lien==5 & lien ~= lien[_n-1]
			replace freretemp2=1 if lien==5 & lien == lien[_n-1] & lien[_n-1] ~= lien[_n-2]
			replace birthfreretemp1=birthher if lien==5 & lien ~= lien[_n-1]
			replace birthfreretemp2=birthher if lien==5 & lien == lien[_n-1] & lien[_n-1] ~= lien[_n-2]
			forval i =1/2 {
				bys idsucc :  egen frere`i' = sum(freretemp`i')
				bys idsucc :  egen birthfrere`i' = sum(birthfreretemp`i')
			}
			drop birthfreretemp* freretemp*
			keep if idher==1
			
			foreach var of varlist femme frere? enf? {
			replace `var'=0 if birth`var'==0
			}
			
			gen cible = 0
			replace cible=1 if birth ~=. & (enf1 >0 | enf2 >0 | frere1>0 | frere2>0 |  femme >0)
			xi:reg birth i.femme*birthfemme i.enf1*birthenf1  i.enf2*birthenf2 i.frere1*birthfrere1 i.frere2*birthfrere2 if cible==1 [aw=pondn]
			predict birth2
			replace birth = round(birth2) if birth==.
			keep birth idsucc
			sort idsucc
			merge idsucc using "`a'"
			drop _merge
			sort idsucc idher
			
		* Pour les hritiers
			gen cible=0
			replace cible =1 if birthher~=. & birthher~=9999
			xi:reg birthher i.lien*birth i.pcs i.sexe i.mat rbg if cible==1 [aw=pondn], cluster(idsucc)
			predict birth2
			replace birthher = round(birth2) if birthher==.
			drop cible-birth2
			* Note : Avec cette mthode tous les fils d'un dfunt auront le mme age.
			
	
		* Recodage de l'age
			replace age=yeardec-birth 
			replace ageher = yeardec-birthher
			replace ageher = 0 if birthher==9999	
		
		* On vire les individus sans patrimoine
			gen temp=pat_exo+actbrut
			drop if temp==0
			drop temp
			
		* Reclassement des individus par idsucc puis lien puis birther
			sort idsucc lien birthher
			drop x idher idsuc
			gen x=0
			replace x=1 if idsuc~=idsuc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
			drop x temp* 
			
		* PCS du 1er enfant pour matching donation
			bys idsucc : egen pcsenf=sum(pcsher*(idher==1)*(lien==0))

		* Arrondi 
			foreach var of varlist ir-patfin_liqu dons10moins-donations droitsnets partnet-dtsnets{
				replace `var'=round(`var')
			}





#delimit;
order year idsucc idher pondn psu weight yeardec birth
 nher age nenf nenf01 pcs pcs_d pcsenf sexe dep mat regmat rbg  ir 
 pat_exo patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo patfon_brut patpro patfin_div  patfin_int patfin_liqu patfin_av 
 part_bienpro  actbrut passif actnet legs actnetimpos droitsnets
 donations dons10moins dons10plus donsman nb_donant date_dons1 date_dons2 date_dons3 date_dons4 ;
 #delimit cr
 
*save "${wfDMTG}/wf94her.dta", replace

keep if idher ==1
drop lien-dtsnets idher
*ds idsucc mat, not
save "${wfDMTG}/MTG/wf1994succ.dta", replace





/*

* Petit point sur les comparaisons tot immeubles meubles avec actif brut et actif ent avec somme des parts nettes



*1) Tot meuble + immeuble avec somme des parts nettes
 
*Note sur comparaison tot immeuble et meubles avec actif brut dans le cas d'une communaut. (il n'y a pas de problme quand il n'y a pas de communaut.)
*Contrairement  2000, pour 94, tot immeuble et meubles = actif brut -forfait mobilier dans le cas d'une communaut (96% des cas). 


 

/* Le total meuble et immeuble ne correspond pas toujouts  l'actif brut de succession-forfait mobilier alors que a devrait tre le cas */
	
	* Etude  et explication de ce phnomne
	
	keep if idher==1
		* part des successions avec communaut : 36%
				gen ind=1 if j13 > 0 
				replace ind=0 if ind==.
				sum ind [aw=pond]

	
		* Quand il n'y a pas de liquidation de communaut :
			
			* g14+h10 (total meuble et immeuble = actif brut-forfait mobilier) 97% des cas ie 62% des successions
				* Total des biens meubles et immeubles
				gen tot=g14+h10
				* Actif brut -forfait mobilier j1
				gen verif3=1 if ind==0 & j1/tot >= 0.98 & j1/tot <= 1.02
				gen prob3=0 if ind==0 & verif3~=1
				replace prob3=1 if ind==0 & verif3==1
				sum prob3 [aw=pond] if ind==0
			
			
		
		* Quand il y a liquidation de la communaut
				keep if ind==1
				drop verif3 prob3
				* Biens communs/2 + biens propres du dfunt
				gen tot2=j13/2+ j19
				* Part de la communaut revenant au dfunt (aprs prise en compte des rcompenses et reprises) + moiti du passif + bien propre
				gen tot3=j21-j25
				gen verif = 0
				replace verif=1 if tot/tot2 >= 0.98 & tot/tot2 <= 1.02
				sum verif [aw=pond]
				gen verif2 = tot-tot2 if verif==0
				gen var = tot/tot2
				gen verif3=0
				replace verif3 = 1 if tot/tot3 >= 0.98 & tot/tot3 <= 1.02
				sum verif3 [aw=pond]
				* Biens communs
				gen tot4=j13
				gen verif4 = 0
				replace verif4=1 if tot/tot4 >= 0.98 & tot/tot4 <= 1.02
				sum verif4 [aw=pond]
				gen var4 = tot/tot4
				drop if verif==1|verif4==1
				drop verif*
				* Quand communaut > 0, tot2 correspond  tot dans 96% des cas (35% des successions). tot4 correspond  tot dans 3% des cas ie 1% des successions
				* Note : normalement il faudrait que tot meuble et immeuble corresponde  tot3 c'est  dire l'actif brut du dfunt qui prend en compte les rcompenses et les reprises. Mais ce n'est le cas que dans 65% des cas.
				* Dans les 3% de successions restantes, ce sont des incohrences
				* idsucc 98 et 816 dconne compltement au niveau tot. Erreur de saisie

				
/* Comparaison actif net et somme des parts nettes */
	
	* actif net = actif net imposable +legs
	gen actnet = (max(j6,j27)+max(j26,j5))/6.55957
	* Somme des parts nettes
	by idsucc : egen actnet2 = sum(n1/6.55957)	
	sum actnet actnet2 [aw=pond] if idher==1
	gen verif5 = 0
	replace verif5 = 1 if actnet2/actnet >= 0.98 & actnet2/actnet <= 1.02
	sum verif5 [aw=pond] if idher==1 
	gen ind=1 if j13 > 0 
	sum verif5 [aw=pond] if idher==1 & ind==1
	* En moyenne, les deux sont gaux en moyenne  99,94%
	* au niveau micro, les deux sont gaux dans 92% des cas, 89% des cas quand c'est une communaut.
	
*/
