*************************************************************
* Generalized percentile of wealth series from 1800 to 1970 * 
*************************************************************

* Stata code generating Stata file gperc_wealth_1800_1970.dta (long-run wealth series generated from inheritance tax tabulations), as well as extracted tables TC10 to TC13 using output from SimulationGpinter

clear
set more off


/***************************importing average wealth and inheritance series 1807-1964*/
	import excel using "$projsimul/rawdata_byyear_originalThomas.xlsx", sheet("Averages") firstrow
	save "$projdirfiles/temp/averages.dta", replace
	clear
 
/*****************************importing gperc series for fiscal inheritance 1807-1964*/
	foreach year in 1807 1817 1827 1837 1847 1857 1867 1877 1887 1902 1903 1904 1905 1907 1909 1910 1911 1912 1913 1925 1926 1927 1929 1930 1931 1932 1933 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1962 1964{
		insheet using "$projsimulres/`year'.csv",clear 
		replace b="" if b=="Inf"
		destring b,replace
		rename topavg ytop
		drop topsh
		replace year=`year'
		replace p=p*100
		drop average
		if `year'>1807 {
			append using "`temp'"
			erase "`temp'"
		}
		tempfile temp
		save "`temp'",replace	
	}
	forvalues year = 1914/1924{
		use "`temp'", clear
		keep if year==1913
		replace year=`year'
		append using "`temp'"
		erase "`temp'"
		tempfile temp
		save "`temp'",replace
	}
	forvalues year = 1965/1969{
		use "`temp'", clear
		keep if year==1964
		replace year=`year'
		append using "`temp'"
		erase "`temp'"
		tempfile temp
		save "`temp'",replace
	}
	sort year p
	*save "$projdirfiles/gperc_wealth_1800_1970.dta", replace
	
/*****************correction for economic inheritance vs fiscal inheritance*/
	*use "$projdir/gperc_wealth_1800_1970.dta", clear
	merge m:1 year using "$projdirfiles/temp/averages.dta",nogen
	replace thr=thr*wd/wdf
	replace ytop=ytop*wd/wdf
	drop w wd wdf
	replace p=round(1000*p,1)
	sort year p
	gen double yint=ytop if p==99999
	replace yint=((100000-p)*ytop-(100000-p[_n+1])*ytop[_n+1])/(p[_n+1]-p) if p<99999
	gen f=1 if p==99999
	replace f=p[_n+1]-p if p<99999
	* Round value
		foreach var of varlist yint thr {
			replace `var'=round(`var')
		}
	* Check error: 30 small errors of 1 euro
		replace yint=thr if thr==thr[_n+1] & year==year[_n+1]
		replace yint=round((thr+thr[_n+1])/2) if yint < thr & thr<thr[_n+1] & year==year[_n+1]
		gsort + year - p
		bys year : gen tot1=sum(f)
		bys year : gen tot2=sum(f*yint)
		replace ytop=tot2/tot1
		drop tot1 tot2
		replace b=ytop/thr
	
	order year p f thr yint ytop b
	keep year p f thr yint ytop b
	order year p f thr yint ytop b
	sort year p
	save "$projdirfiles/gperc_wealth_1800_1970.dta", replace

	* Check
		gen prob=0
		replace prob=1 if thr>thr[_n+1] & year==year[_n+1]
		replace prob=1 if yint>thr[_n+1] & year==year[_n+1]
		replace prob=1 if yint<thr & year==year[_n+1]
		replace prob=1 if yint>yint[_n+1] & year==year[_n+1]
		tab year if prob==1
		drop prob
		
/********************applying index factors for 1914-1924 and 1964-1969*****/
	import excel using "$projdir/GGP2016WealthAppendixC.xlsx", sheet("TC7Stata") firstrow clear
	drop if p==.
	reshape long c, i(p) j(year)
	rename c corr
	replace p=1000*p
	sort year p
	save "$projdirfiles/temp/corrfactors.dta", replace
	
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	merge 1:1 year p using "$projdirfiles/temp/corrfactors.dta", nogen
	replace thr=thr*corr if (year>1913 & year<1925) | year>1963
	replace yint=yint*corr if (year>1913 & year<1925) | year>1963
	* Round value
		foreach var of varlist yint thr {
			replace `var'=round(`var')
		}
	sort year p
	* Check error: 1 small error of 3 euros
		replace yint=thr if thr==thr[_n+1] & year==year[_n+1]
		replace yint=round((thr+thr[_n+1])/2) if yint > thr[_n+1] & thr<thr[_n+1] & year==year[_n+1]
		gsort + year - p
		bys year : gen tot1=sum(f)
		bys year : gen tot2=sum(f*yint)
		replace ytop=tot2/tot1
		drop tot1 tot2
		replace b=ytop/thr
	* Check
		sort year p
		gen prob=0
		replace prob=1 if thr>thr[_n+1] & year==year[_n+1]
		replace prob=1 if yint>thr[_n+1] & year==year[_n+1]
		replace prob=1 if yint<thr & year==year[_n+1]
		replace prob=1 if yint>yint[_n+1] & year==year[_n+1]
		tab year if prob==1
		drop prob
	
	merge m:1 year using "$projdirfiles/temp/averages.dta", nogen
	sort year
	by year: egen wm=total(f*yint)
	replace wm=wm/100000
	replace thr=round(thr*wd/wm)
	replace yint=round(yint*wd/wm) 
	gsort year -p
	replace ytop=yint if p==99999 
	replace ytop=(f*yint+(100000-p[_n-1])*ytop[_n-1])/(100000-p) if p<99999 
	replace b=ytop/thr
	sort year p
	keep year p f thr yint ytop b
	order year p f thr yint ytop b
	save "$projdirfiles/gperc_wealth_1800_1970.dta", replace


/***************************from the distribution of inheritance to the distribution of adult wealth: applying estate multiplier correction coefficients*/
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	merge m:1 year using "$projdirfiles/temp/averages.dta", nogen
	drop wd wdf 
	sort year p
	gen thra=thr
	replace thra=1.01*thr if p>=90000 & p<99000
	replace thra=1.05*thr if p>=99000
	gen yinta=ytop if p==99999
	replace yinta=((100000-p)*ytop-(100000-p[_n+1])*ytop[_n+1])/(p[_n+1]-p) if p<99999
	replace yinta=1.01*yinta if p>=90000 & p<99000	
	replace yinta=1.05*yinta if p>=99000
	
	* Round value
		foreach var of varlist yinta thra {
			replace `var'=round(`var')
		}
		sort year p
	* Check error : 
		replace yinta=round((thra+thra[_n+1])/2) if yinta<thr & year==year[_n+1]
	* Check
		sort year p
		gen prob=0
		replace prob=1 if thra>thra[_n+1] & year==year[_n+1]
		replace prob=1 if yinta>thra[_n+1] & year==year[_n+1]
		replace prob=1 if yinta<thra & year==year[_n+1]
		replace prob=1 if yinta>yinta[_n+1] & year==year[_n+1]
		tab year if prob==1
		drop prob
	
	by year: egen wm=total(f*yinta)
	replace wm=wm/100000
	replace thra=round(thra*w/wm)
	replace yinta=round(yinta*w/wm)
	gsort year -p
	gen ytopa=ytop
	replace ytopa=yinta if p==99999
	replace ytopa=(f*yinta+(100000-p[_n-1])*ytopa[_n-1])/(100000-p) if p<99999
	gen ba=ytopa/thra
	keep year p f thr yint ytop b thra yinta ytopa ba
	order year p f thr yint ytop b thra yinta ytopa ba
	sort year p
	save "$projdirfiles/gperc_wealth_1800_1970.dta", replace


/**********************************extracting table C10************************/
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	sort year p 
	gen p0=0 if p==0
	replace p0=p/1000+(yint/(thr[_n+1]-thr))*f/1000 if thr==0 & thr[_n+1]>0 & year[_n+1]==year
	keep if p==0 | p==10000 | p==50000 | p==90000 | p==99000 | p==99900 | p==99990 | p==99999
	gen wmean=ytop if p==0
	gen bottom10=1-0.9*ytop[_n+1]/ytop if p==0
	gen bottom50=1-0.5*ytop[_n+2]/ytop if p==0
	gen top10=0.1*ytop[_n+3]/ytop if p==0
	gen middle40=1-top10-bottom50 if p==0
	gen top1=0.01*ytop[_n+4]/ytop if p==0
	gen top01=0.001*ytop[_n+5]/ytop if p==0
	gen top001=0.0001*ytop[_n+6]/ytop if p==0
	gen top0001=0.00001*ytop[_n+7]/ytop if p==0
	gen p10=thr[_n+1]/wmean if p==0
	gen p50=thr[_n+2]/wmean if p==0
	gen p90=thr[_n+3]/wmean if p==0
	gen p99=thr[_n+4]/wmean if p==0
	gen p999=thr[_n+5]/wmean if p==0
	gen p9999=thr[_n+6]/wmean if p==0
	gen p99999=thr[_n+7]/wmean if p==0
	gen b10=ytop[_n+1]/thr[_n+1] if p==0
	gen b50=ytop[_n+2]/thr[_n+2] if p==0
	gen b90=ytop[_n+3]/thr[_n+3] if p==0
	gen b99=ytop[_n+4]/thr[_n+4] if p==0
	gen b999=ytop[_n+5]/thr[_n+5] if p==0
	gen b9999=ytop[_n+6]/thr[_n+6] if p==0
	gen b99999=ytop[_n+7]/thr[_n+7] if p==0
	keep if p==0
	keep year wmean bottom10 bottom50 middle40 top10 top1 top01 top001 top0001 p0 p10 p50 p90 p99 p999 p9999 p99999 b10 b50 b90 b99 b999 b9999 b99999
	order year wmean bottom10 bottom50 middle40 top10 top1 top01 top001 top0001 p0 p10 p50 p90 p99 p999 p9999 p99999 b10 b50 b90 b99 b999 b9999 b99999
	save "$projdirfiles/tables/TableC10.dta", replace
	export excel using "$projdirfiles/tables/TableC10.xlsx", firstrow(variables) replace

/*extracting table C11*/
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	keep year p thr ytop b
	reshape wide thr ytop b, i(p) j(year)
	save "$projdirfiles/tables/TableC11.dta", replace
	export excel using "$projdirfiles/tables/TableC11.xlsx", firstrow(variables) replace

/*******************************extracting table C12********************/
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	gen p0=0 if p==0
	replace p0=p/1000+(yinta/(thra[_n+1]-thra))*f/1000 if thra==0 & thra[_n+1]>0 & year[_n+1]==year
	keep if p==0 | p==10000 | p==50000 | p==90000 | p==99000 | p==99900 | p==99990 | p==99999
	sort year p 
	gen wmean=ytopa if p==0
	gen bottom10=1-0.9*ytopa[_n+1]/ytopa if p==0
	gen bottom50=1-0.5*ytopa[_n+2]/ytopa if p==0
	gen top10=0.1*ytopa[_n+3]/ytopa if p==0
	gen middle40=1-top10-bottom50 if p==0
	gen top1=0.01*ytopa[_n+4]/ytopa if p==0
	gen top01=0.001*ytopa[_n+5]/ytopa if p==0
	gen top001=0.0001*ytopa[_n+6]/ytopa if p==0
	gen top0001=0.00001*ytopa[_n+7]/ytopa if p==0
	gen p10=thra[_n+1]/wmean if p==0
	gen p50=thra[_n+2]/wmean if p==0
	gen p90=thra[_n+3]/wmean if p==0
	gen p99=thra[_n+4]/wmean if p==0
	gen p999=thra[_n+5]/wmean if p==0
	gen p9999=thra[_n+6]/wmean if p==0
	gen p99999=thra[_n+7]/wmean if p==0
	gen b10=ytopa[_n+1]/thra[_n+1] if p==0
	gen b50=ytopa[_n+2]/thra[_n+2] if p==0
	gen b90=ytopa[_n+3]/thra[_n+3] if p==0
	gen b99=ytopa[_n+4]/thra[_n+4] if p==0
	gen b999=ytopa[_n+5]/thra[_n+5] if p==0
	gen b9999=ytopa[_n+6]/thra[_n+6] if p==0
	gen b99999=ytopa[_n+7]/thra[_n+7] if p==0
	keep if p==0
	keep year wmean bottom10 bottom50 middle40 top10 top1 top01 top001 top0001 p0 p10 p50 p90 p99 p999 p9999 p99999 b10 b50 b90 b99 b999 b9999 b99999
	order year wmean bottom10 bottom50 middle40 top10 top1 top01 top001 top0001 p0 p10 p50 p90 p99 p999 p9999 p99999 b10 b50 b90 b99 b999 b9999 b99999
	save "$projdirfiles/tables/TableC12.dta", replace
	export excel using "$projdirfiles/tables/TableC12.xlsx", firstrow(variables) replace

/***********************************extracting table C13*/
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	keep year p thra ytopa ba
	reshape wide thra ytopa ba, i(p) j(year)
	save "$projdirfiles/tables/TableC13.dta", replace
	export excel using "$projdirfiles/tables/TableC13.xlsx", firstrow(variables) replace

/**************renaming variables as described in codebook*/
	use "$projdirfiles/gperc_wealth_1800_1970.dta", clear
	rename thra ythr_hweal_j
	rename yinta yint_hweal_j
	rename ytopa ytop_hweal_j
	rename ba b_hweal_j
	rename thr ythr_hweal_j_d
	rename yint yint_hweal_j_d
	rename ytop ytop_hweal_j_d
	rename b b_hweal_j_d
	keep year p f ythr_hweal_j yint_hweal_j ytop_hweal_j b_hweal_j ythr_hweal_j_d yint_hweal_j_d ytop_hweal_j_d
	order year p f ythr_hweal_j yint_hweal_j ytop_hweal_j b_hweal_j ythr_hweal_j_d yint_hweal_j_d ytop_hweal_j_d
	sort year p f ythr_hweal_j yint_hweal_j ytop_hweal_j b_hweal_j ythr_hweal_j_d yint_hweal_j_d ytop_hweal_j_d
	save "$projdirfiles/gperc_wealth_1800_1970.dta", replace
