
clear


* I) Load the data
*******************
 
	* National Accounts
		import excel using "$patdir/GGP2016WealthAppendixF.xlsx",first clear sheet("DataSeries") cellrange(A7:P52) 
		keep if  year==1992 | year==1998 | year==2004 | year==2010
		gen patfonNA=patfon_ownerNA+ patfon_rentNA
		gen patfinNA=patfin_divNA+ patfin_intNA+ patfin_liquNA+ patfin_avNA
		tempfile temp 
		save "`temp'",replace

	* EP 
		use "$wfpat/wfEP10_ind.dta",clear
		append using "$wfpat/wfEP04_ind.dta"
		append using "$wfpat/wfEP98_ind.dta"
		append using "$wfpat/wfEP92_ind.dta"
		merge m:1 year using "`temp'"
		drop _merge
		erase "`temp'"
		
	* Population from wealth surveys consistent with adult population
		bys year : egen pop=sum(pondn/1000)
		replace pondn=pondn*popNA/pop
		drop pop popNA
		
	* Definition of the percentile 
		sort year pat
		gen pondvr=round(100*pondn) 
		bys year : cumul pat [w=pondvr], gen (p100)
		gen p10=p100*100
		gen py   = 0
		replace py=50  if p10 >=50 & p10 <90 & py==0
		replace py= 90   if p10 >=90 & p10 <95 & py==0
		replace py= 95   if p10 >=95 & p10 <99 & py==0
		replace py= 99   if p10 >=99 & p10 <99.5 & py==0
		replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
		replace py= 999   if p10 >=99.9 & py==0
		drop p10 p100 pondvr
		
	save "$wfpat/temp/temp.dta",replace
	
* II) Stat des on wealth surveys without any adjustments 
********************************************************

	*a) Total wealth by assets: wealth surveys vs National Accounts
	******************************************************************
		use "$wfpat/temp/temp.dta",clear
		foreach var of varlist pat patfon patfon_owner patfon_rent passif patpro patfin patfin_div patfin_div_pub patfin_div_priv patfin_div_mut patfin_int patfin_liqu ccheque patfin_av   {
			bys year : egen `var'tot=sum(`var'*pondn/1000000000)
			gen r_`var'=`var'tot/`var'NA
		}
		sort year
		collapse (mean)  r_*,by(year)
		export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(R7)  firstrow(variables)
	
	*b) Average wealth, wealth thresholds  and wealth shares by wealth group
	**************************************************************************
		use "$wfpat/temp/temp.dta",clear
		gen pat2=pat
		replace pat=pat*pondn
		gen obs=1
		collapse (sum) pat n=pondn obs (min) thres=pat2 ,by(year py)
		
		gsort + year - py 
		bys year: gen pat_cumul=sum(pat)
		bys year: gen pop_cumul=sum(n)
		bys year: egen pat_tot=sum(pat)
		bys year: egen pop_tot=sum(n)
		bys year: egen obs_tot=sum(obs)

		* Average wealth 
			gen wmean=pat_cumul/pop_cumul if py>50
			replace wmean=pat/n if py<=50
			gen average=pat_tot/pop_tot
		* Wealth shares
			gen shw=pat_cumul/pat_tot if py>50
			replace shw=pat/pat_tot if py<=50
		sort year py	
		keep year py shw wmean thres obs_tot pop_tot average
		order 	year py shw wmean thres obs_tot pop_tot average
		export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(AI7)  firstrow(variables)

	*c) Wealth composition by wealth group
	****************************************
		use "$wfpat/temp/temp.dta",clear
		foreach var of varlist pat patfon passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av /*patfin_div_pub patfin_div_priv patfin_div_mut ccheque*/   {
			replace `var'=`var'*pondn
		}	
		collapse (sum) pat patfon passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av /*patfin_div_pub patfin_div_priv patfin_div_mut ccheque*/  ,by(year py)
		foreach var of varlist patfon passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av /*patfin_div_pub patfin_div_priv patfin_div_mut ccheque*/    {
			replace `var'=`var'/pat
		}
		bys year : egen pattot=sum(pat)
		replace pat=pat/pattot
		drop pattot
		export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(AR7)  firstrow(variables)

	*d) Asset-specific distribution	
	********************************	
		* In the wealth surveys
		**************************
		foreach var of varlist patfon passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av    {
			use "$wfpat/temp/temp.dta",clear
			drop py
			* Definition of the percentile 
			sort year `var'
			gen pondvr=round(100*pondn) 
			bys year : cumul `var' [w=pondvr], gen (p100)
			gen p10=p100*100
			gen py   = 0
			replace py=50  if p10 >=50 & p10 <90 & py==0
			replace py= 90   if p10 >=90 & p10 <95 & py==0
			replace py= 95   if p10 >=95 & p10 <99 & py==0
			replace py= 99   if p10 >=99 & p10 <99.5 & py==0
			replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
			replace py= 999   if p10 >=99.9 & py==0
			
			* Distribution
				replace `var'=`var'*pondn
				collapse (sum) `var' ,by(year py)
				bys year : egen `var'_tot=sum(`var')
				replace `var'=`var'/`var'_tot
				drop `var'_tot
				sort year py
				if "`var'"~="patfon" {
					merge 1:1 year py using "`tempA'"
					drop _merge
					erase "`tempA'"

				}
				tempfile tempA
				save "`tempA'",replace
				
			}
			erase "`tempA'"
			order year py patfon passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av
			export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(BD7)  firstrow(variables)
		
		* In the capitalization method
		********************************
			use "$projdir/GGP2016WealthAppendixB/DataFiles/Exportation/Results/wealth/other/assetdistri.dta",clear
			keep year py patfon_brut patfon_owner_brut patfon_rent_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av
			order  year py patfon_brut patfon_owner_brut patfon_rent_brut passif patpro patfin patfin_div patfin_int patfin_liqu patfin_av
			keep if year==1992 | year==1998 | year==2004 | year ==2010
			export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(CL7)  firstrow(variables)

* III) Adjustment by asset categories
***************************************	
	*a) Adjustment
	****************
	use "$wfpat/temp/temp.dta",clear
	foreach var of varlist patfon passif patpro  patfin_div patfin_int patfin_liqu patfin_av   {
		bys year : egen `var'tot=sum(`var'*pondn/1000000000)
		replace `var'=`var'/`var'tot*`var'NA
		drop `var'tot
	}
	replace passif=min(patfon,passif)
	bys year : egen passiftot=sum(passif*pondn/1000000000)
	bys year : egen passiftemp=sum(passif*pondn/1000000000*(passif>0.8*patfon))
	replace passif=passif/(passiftot-passiftemp)*(passifNA-passiftemp) if passif<0.8*patfon
	drop passiftot passiftemp
	replace passif=min(patfon,passif)
	replace patfin=patfin_div+ patfin_int +patfin_liqu +patfin_av 
	replace pat=patfon+patpro+patfin-passif
	
	* Definition of the percentile 
		drop py
		sort year pat
		gen pondvr=round(100*pondn) 
		bys year : cumul pat [w=pondvr], gen (p100)
		gen p10=p100*100
		gen py   = 0
		replace py=50  if p10 >=50 & p10 <90 & py==0
		replace py= 90   if p10 >=90 & p10 <95 & py==0
		replace py= 95   if p10 >=95 & p10 <99 & py==0
		replace py= 99   if p10 >=99 & p10 <99.5 & py==0
		replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
		replace py= 999   if p10 >=99.9 & py==0
		drop p10 p100 pondvr
	
	
	*b) Average wealth, wealth thresholds  and wealth shares by wealth group
	**************************************************************************
		gen pat2=pat
		replace pat=pat*pondn
		gen obs=1
		collapse (sum) pat n=pondn obs (min) thres=pat2 ,by(year py)
		
		gsort + year - py 
		bys year: gen pat_cumul=sum(pat)
		bys year: gen pop_cumul=sum(n)
		bys year: egen pat_tot=sum(pat)
		bys year: egen pop_tot=sum(n)
		bys year: egen obs_tot=sum(obs)

		* Average wealth 
			gen wmean=pat_cumul/pop_cumul if py>50
			replace wmean=pat/n if py<=50
			gen average=pat_tot/pop_tot
		* Wealth shares
			gen shw=pat_cumul/pat_tot if py>50
			replace shw=pat/pat_tot if py<=50
		sort year py	
		keep year py shw wmean thres obs_tot pop_tot average
		order 	year py shw wmean thres obs_tot pop_tot average
		export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(BO7)  firstrow(variables)

	
* III) Adjustment by asset categories and asset groups
********************************************************	
	use "$wfpat/temp/temp.dta",clear
	drop py
	* Adjustment with uniform rate by asset for housing, business, debts, savings account and life insurance
		foreach var of varlist patfon passif patpro  patfin_liqu patfin_av   {
			bys year : egen `var'tot=sum(`var'*pondn/1000000000)
			replace `var'=`var'/`var'tot*`var'NA
			drop `var'tot
		}
		replace passif=min(patfon,passif)
		bys year : egen passiftot=sum(passif*pondn/1000000000)
		bys year : egen passiftemp=sum(passif*pondn/1000000000*(passif>0.8*patfon))
		replace passif=passif/(passiftot-passiftemp)*(passifNA-passiftemp) if passif<0.8*patfon
		drop passiftot passiftemp
		replace passif=min(patfon,passif)
		tempfile temp
		save "`temp'",replace
	
	* Differential correcting factor by asset category and asset-specific groups (equities and bonds)
		foreach var of varlist patfin_div patfin_int {
			use "`temp'",clear
			* Definition of the percentile 
				sort year `var'
				gen pondvr=round(100*pondn) 
				bys year : cumul `var' [w=pondvr], gen (p100)
				gen p10=p100*100
				gen py   = 0
				replace py=50  if p10 >=50 & p10 <90 & py==0
				replace py= 90   if p10 >=90 & p10 <95 & py==0
				replace py= 95   if p10 >=95 & p10 <99 & py==0
				replace py= 99   if p10 >=99 & p10 <99.5 & py==0
				replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
				replace py= 999   if p10 >=99.9 & py==0
				drop pondvr p10 p100
				tempfile tempA
				save "`tempA'",replace
			* Merge with correcting factor
				import excel using "$patdir/GGP2016WealthAppendixF.xlsx", first clear sheet("DataSeries") cellrange(BX7:CA35) 
				merge 1:m year py using "`tempA'"
				drop _merge py
				replace `var'=`var'/r_`var' 
			erase "`temp'"
			erase "`tempA'"
			tempfile temp
			save "`temp'",replace
		}
		erase "`temp'"
	replace patfin=patfin_div+ patfin_int +patfin_liqu +patfin_av 
	replace pat=patfon+patpro+patfin-passif
	drop *NA r_patfin_div r_patfin_int
	

	*b) Average wealth, wealth thresholds  and wealth shares by wealth group
	**************************************************************************
		* Definition of the percentile 
			sort year pat
			gen pondvr=round(100*pondn) 
			bys year : cumul pat [w=pondvr], gen (p100)
			gen p10=p100*100
			gen py   = 0
			replace py=50  if p10 >=50 & p10 <90 & py==0
			replace py= 90   if p10 >=90 & p10 <95 & py==0
			replace py= 95   if p10 >=95 & p10 <99 & py==0
			replace py= 99   if p10 >=99 & p10 <99.5 & py==0
			replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
			replace py= 999   if p10 >=99.9 & py==0
			drop p10 p100 pondvr
		
		gen pat2=pat
		replace pat=pat*pondn
		gen obs=1
		collapse (sum) pat n=pondn obs (min) thres=pat2 ,by(year py)
		
		gsort + year - py 
		bys year: gen pat_cumul=sum(pat)
		bys year: gen pop_cumul=sum(n)
		bys year: egen pat_tot=sum(pat)
		bys year: egen pop_tot=sum(n)
		bys year: egen obs_tot=sum(obs)

		* Average wealth 
			gen wmean=pat_cumul/pop_cumul if py>50
			replace wmean=pat/n if py<=50
			gen average=pat_tot/pop_tot
		* Wealth shares
			gen shw=pat_cumul/pat_tot if py>50
			replace shw=pat/pat_tot if py<=50
		sort year py	
		keep year py shw wmean thres obs_tot pop_tot average
		order 	year py shw wmean thres obs_tot pop_tot average
		export excel using "$patdir/GGP2016WealthAppendixF.xlsx", sheet("DataSeries")  sheetmodify cell(CC7)  firstrow(variables)

	
		