/********************************************************
 Do-file used to harmonize the wealht survey 1986	*
*********************************************************/

*global datapat "W:/brtrd/Patrimoine/1986"

set more off
clear
set seed 15468
local year=1986
	

use "$datapat/EP 86/actfin86.dta", clear
gen year=1986
gen ident=_n
keep pond lien* sexe* anais* ni1? matri* pcs? di13 m09  resp* resc* res6 res4 res4a nivsorc ident year av9? im10 oblim07 sicctm07 sicavm07 fcpctm07 fcpm07 actm07 scim07 actncm07 bc4 el06? le7? c01/* nbre d'enfants hors dom*/
reshape long lien sexe matri pcs anais ni1,i(ident) j(idnum) string
sort ident idnum 
drop if lien=="" & sexe=="" & anais=="" & matri=="" & pcs=="" 

* A) Socio-demographic variables 
*********************************

	* Identifier
		* Household : identmen, Individual : identnum
	* Weight
		gen pondn=pond
		drop pond
	* Age
		gen age=1986-1000-real(anais)
		* 6 little retreatments
		bys ident : egen birthtemp=sum((1000+real(anais))*(lien=="1"))
		replace age=1986-birthtemp if age==.  & birthtemp~=0
		drop birthtemp
		bys ident : egen birthtemp=min((1000+real(anais))*(lien=="3"))
		replace age=1986-birthtemp+25 if age==. & birthtemp~=0
		drop birthtemp
		replace age=50 if age==.
		drop anais
		replace age=42 if age==12 & lien=="2"
				
	* Decenial age 
		gen aged=int(age/10)+1
		replace aged=9 if aged>=10
	* Link with the person of reference (PR)
		* lien
	* Number of children living in the household
		bys ident : egen nbenftemp=sum((lien=="3") | (lien=="4"))
		gen nenf=0
		replace nenf=nbenftemp if lien=="1" | lien=="2"
		drop nbenftemp
	* Total number of children (in and utside the household)
		replace nenf=nenf+real(di13) if (lien=="1" | lien=="2") & di13~=""
		gen nenf01=0
		replace nenf01=1 if nenf>0

	* Marital status
		*matri (1: single (C), 2: married (M), 3: widow (V), 4: divorced (D))
		gen mat="C" if matri=="1"
		replace mat="M" if matri=="2"
		replace mat="V" if matri=="3"
		replace mat="D" if matri=="4"
		replace mat="C" if mat==""
		drop matri
			
	* sex (1 :M, 2 :F)
		gen sexetemp=sexe
		drop sexe
		gen sexe=0 if sexetemp=="1"
		replace sexe=1 if sexetemp=="2"			
		replace sexe=round(runiform()) if sexe==.
		drop sexetemp
				
	* PCS
		gen pcs_ind=int(real(pcs)/10)
		replace pcs_ind=0 if real(pcs)==99 | pcs==""
		replace pcs_ind=9 if real(pcs)==31
		replace pcs_ind=8 if pcs=="00"

			tempfile temp
			save "`temp'",replace
			
* B) Correction of non-response
***********************************
	* Non-response or "do not knwow" for the estimation of wealth (6% of households)
	* Procedure : hotdeck stratified by 
		* marie: dummy for being married
		* age_hot: Age (<40, 40-50, 50-60, >60)
		* res4: Income bracket in 1985 (revenu global) available for 96% of individuals, 0 when non-reported)
		* res6_hot : Wealth bracket
		* indpt : Dummy for Self-employed
		* nivsorc : Social status of the person of reference (code p37 of pdf documentation file dfic2)

		keep if lien=="1"
		* Variables for the hotdeck stratification
			gen marie=1 if mat=="M" 
			replace marie=0 if mat~="M"
			
			gen age_hot=0 if age<40
			replace age_hot=40 if missing(age_hot) & age<=50
			replace age_hot=50 if missing(age_hot) & age<=60
			replace age_hot = 60 if missing(age_hot)
			
			gen res4_hot=res4
			destring res4_hot,replace
			replace res4_hot=0 if missing(res4)
			
			gen res6_hot=res6
			destring res6_hot, replace
			
			gen indpt = (nivsorc=="1" | nivsorc=="2" | nivsorc=="3" | nivsorc=="4")
			tab indpt
			/*
			gen nivsorc_hot = 1 if nivsorc=="1" | nivsorc=="2"
			replace nivsorc_hot = 2 if nivsorc=="3" | nivsorc=="4" | nivsorc=="5"
			replace nivsorc_hot = 3 if nivsorc=="6" | nivsorc=="7" | nivsorc=="8"  | nivsorc=="9"
			replace nivsorc_hot = 0 if res4_hot>6
			*/
			
			* Gathering to small strata (with 2 and 3 donors) :
			replace indpt=0 if marie==1 & age_hot==40 & res4_hot==1 
			
									
		* Hotdeck procedure
			*hotdeck res6_hot using hotdeck , store by(marie age_hot res4_hot nivsorc_hot ) keep(ident idnum res6) seed(1994556398) 
			*use "`temp'",clear
			*merge 1:1 ident idnum using "hotdeck1"
			*erase hotdeck1.dta
			cd "$datapat"
			hotdeck res6_hot using hotdeck , store by(marie age_hot res4_hot indpt) keep(ident idnum res6) seed(1994556398) 
			use "`temp'",clear
			erase "`temp'"
			merge 1:1 ident idnum using "hotdeck1"
			erase hotdeck1.dta 

			bys ident : egen res6temp=min(res6_hot)
			tostring res6temp,replace
			replace res6=res6temp if res6==""
			drop res6temp _merge res6_hot res4_hot age_hot marie  nivsorc 
		
															
* C) Composition of wealth by asset and income
**************************************************
							
* C.1) Estimation of exact amount of different assets from brackets
*********************************************************************

	* Gross wealth
	****************
		gen uni=runiform() if lien=="1"
		gen patrimoine_men=uni*3049 if res6=="1" & lien=="1"
		replace patrimoine_men=3049+uni*(15245-3049) if res6=="2" & lien=="1"
		replace patrimoine_men=15245+uni*(45735-15245) if res6=="3" & lien=="1"
		replace patrimoine_men=45735+uni*(76225-45735) if res6=="4" & lien=="1"
		replace patrimoine_men=76225+uni*(152449-76225) if res6=="5" & lien=="1"
		replace patrimoine_men=152449+uni*(228674-152449) if res6=="6" & lien=="1"
		replace patrimoine_men=228674+uni*(381123-228674) if res6=="7" & lien=="1"
		*Pareto coeff 2 for the last bracket
		replace patrimoine_men=381123*(uni^(-1/2)) if (res6=="8" ) & lien=="1"   
		drop uni
		*summ patrimoine_men, de
		
	* Financial assets
	*********************
		
		* Compte cheque (p52 de lil-0124dfic.pdf)
			* no amounts
			g ccheque=0
		
		* Compte  terme (p68)
			tab c01, missing
			gen unicaterme=runiform() if lien=="1"
			gen caterme =0
			replace caterme= unicaterme*1524 if c01=="1"
			replace caterme= 1524+unicaterme*(7623-1524) if c01=="2"
			replace caterme= 7623+unicaterme*(30490-7623) if c01=="3"
			replace caterme= 30490+unicaterme*(76225 -30490) if c01=="4"
			*Pareto coeff 2 for the last bracket
			replace caterme=76225*(unicaterme^(-1/2))  if c01=="5"
			drop unicaterme c01
			*summ caterme, de
		
		* livret p69 
			gen livret=0
			forval num =1/6 {
				gen unilivret`num'=runiform() if lien=="1"
				gen livret`num'=0
				replace livret`num'= unilivret`num'*152 if le7`num'=="1"
				replace livret`num'= 152+unilivret`num'*(1524-152) if le7`num'=="2"
				replace livret`num'= 1524+unilivret`num'*(4573-1524) if le7`num'=="3"
				replace livret`num'= 4573+unilivret`num'*(7623 -4573) if le7`num'=="4"
				replace livret`num'=7623+unilivret`num'*(10367 -7623)  if le7`num'=="5"
				*Pareto coeff 2 for the last bracket							
				replace livret`num'=10367*(unilivret`num'^(-1/2))  if le7`num'=="6"
				replace livret=livret+livret`num'
				drop unilivret`num' livret`num' le7`num'
			}
		
		* epargne logement p78 
			gen epl=0
			forval num =1/8 {
				gen uniepl`num'=runiform() if lien=="1"
				gen epl`num'=0
				replace epl`num'= uniepl`num'*762 if el06`num'=="1"
				replace epl`num'= 762+uniepl`num'*(3049-762) if el06`num'=="2"
				replace epl`num'= 3049+uniepl`num'*(9147-3049) if el06`num'=="3"
				replace epl`num'= 9147+uniepl`num'*(15245 -9147) if el06`num'=="4"
				*Pareto coeff 2 for the last bracket				
				replace livret=15245*(uniepl`num'^(-1/2)) if el06`num'=="5"
				replace epl=epl+epl`num'
				drop uniepl`num' epl`num' el06`num'
			}

		* Valeurs mobilires p86 and after
			* 1: bonds, 2: short term  sicav, 3: Other sicav, 4: short term FCP, 5: other FCP, 6: public equities (Actions cts), 7: SCI, 8: private equities (actions non ctes)
			foreach var of  newlist obli sicct sicav fcpct  fcp  act sci  actnc{
				gen uni`var'=runiform() if lien=="1"
				gen `var'=0
				replace `var'= uni`var'*1524 if `var'm07=="1"
				replace `var'= 1524+uni`var'*(7623-1524) if `var'm07=="2"
				replace `var'= 7623+uni`var'*(15245-7623) if `var'm07=="3"
				replace `var'= 15245+uni`var'*(38112-15245) if `var'm07=="4"
				replace `var'= 38112+uni`var'*(152449-38112) if `var'm07=="5"
				*Pareto coeff 2 for the last bracket	
				replace `var'= 152449*(uni`var'^(-1/2)) if `var'm07=="6"
				drop uni`var' `var'm07
			}
			
		* Bons  p93
			gen unibon=runiform() if lien=="1"
			gen bon=0
			replace bon= unibon*1524 if bc4=="1"
			replace bon= 1524+unibon*(7623-1524) if bc4=="2"
			replace bon= 7623+unibon*(30490-7623) if bc4=="3"
			replace bon= 30490+unibon*(76225 -30490) if bc4=="4"
			*Pareto coeff 2 for the last bracket	
			replace bon= 76225*(unibon^(-1/2))  if bc4=="5"
			drop unibon bc4
			*summ bon, de
			
		* Life insurance p97
			* Valeur de rachat
			forval i =1/3 {
				gen uni`i'=runiform() if lien=="1"
				gen avie`i' = 0
				replace avie`i' = uni`i'*3049 if av9`i'=="2"
				replace avie`i' = 3049+uni`i'*(7623-3049) if av9`i'=="3"
				replace avie`i' = 7623+uni`i'*(15245-7623) if av9`i'=="4"
				replace avie`i' = 15245+uni`i'*(45735-15245) if av9`i'=="5"
				*Pareto coeff 2 for the last bracket	
				replace avie`i' = 45735*(uni`i'^(-1/2)) if av9`i'=="6"
				drop av9`i' uni`i'
			}
			gen patfin_av=avie1+avie2+avie3
			*summ patfin_av, de
			drop avie1-avie3
		
	* Housing assets & Business assets
	************************************
		* In 1986 no possible to disentagle between housing (owner-occupied or tenant-occupied) and business assets
			* Total housing (p102)		
			gen uni1=runiform() if lien=="1"
			gen patfonpro = 0
			replace patfonpro = uni1*30490 if im10=="1"
			replace patfonpro = 30490+uni1*(76225-30490) if im10=="2"
			replace patfonpro = 76225+uni1*(152449-76225) if im10=="3"
			replace patfonpro = 152449+uni1*(304898-152449) if im10=="4"
			*Pareto coeff 2 for the last bracket
			replace patfonpro = 304898*(uni1) if im10=="5"
			drop uni1 im10


* C.2) Decomposition of wealth by aggregate asset category
***********************************************************

	* Financial assets:
		* patfin_div: Equities and mutual funds 
		* patfin_int: Bonds and loans 
		* patfin_liqu: Deposits and savings accounts
		* patfin_av: Life insurance and pension funds	
			
	 * Non-Financial assets: Aggregate variable patfonpro
		
	
		* Deposits and savings accounts: 
			* Placement  vue et numraire (AF21+AF22+AF291)
			gen patfin_liqu=ccheque+ livret
		
		* Bonds, loans: 
			* Placement  chance (AF292), pargne contractuelle (AF293), Obligations (AF3) titres de creances (AF4) 
			gen patfin_int=caterme+epl+obli+bon
				
		* Equities and investment fund shares
			gen patfin_div=sicav+sicct+fcp+sci+fcpct+actnc+act
			* incl. Mututal funds (AF52)
			gen patfin_div_mut=sicav+sicct+fcp+sci+fcpct
			* incl. private equities (AF512+AF519)
			gen patfin_div_priv=actnc
			* incl. public equities (AF511)
			gen patfin_div_pub=act
		
		gen patfin=patfin_liqu+patfin_div+patfin_int+patfin_av
		* patfin_av: Life insurance and pension funds	

		drop caterme livret epl obli sicct sicav fcpct fcp act sci actnc bon
		tempfile temp
		save "`temp'",replace
	
* C.3) Income of the houshold
*******************************
	* Note: There is no consistency between total income and its components

	* Financial income p89 of lil-0124
		* Correction for non response
			keep if lien=="1" & patfin_int+patfin_div>0
			gen temp=patfin_int+patfin_div
			gen patfin_hot="0" 
			replace patfin_hot="1" if temp<1524 & temp>0
			replace patfin_hot="2" if temp>=1524 & temp<7623
			replace patfin_hot="3" if temp>=7623 & temp<15245
			replace patfin_hot="4" if temp>=15245 & temp<38112
			replace patfin_hot="5" if temp>=38112 & temp<152449
			replace patfin_hot="6" if temp>=152449 & temp~=.
			drop temp
			
			gen m09_hot=m09
			destring m09_hot,replace
			hotdeck m09_hot using hotdeck,store by(patfin_hot)  keep(ident idnum m09_hot) seed(65449) 			
			use "`temp'",clear
			erase "`temp'"
			merge 1:1 ident idnum using hotdeck1
			erase hotdeck1.dta
			tostring m09_hot,replace
			replace m09=m09_hot if m09==""
			drop _merge patfin_hot indpt m09_hot
		* Exact amount	
			capture drop uni
			gen uni=runiform() if lien=="1"
			gen rfin_irpp_foy=0 if lien=="1"
			replace rfin_irpp_foy=uni*152 if m09=="1" & lien=="1" 
			replace rfin_irpp_foy=152+uni*(762-152) if m09=="2" & lien=="1"
			replace rfin_irpp_foy=762+uni*(3049-762) if m09=="3" & lien=="1"
			replace rfin_irpp_foy=3049+uni*(7622-3049) if m09=="4" & lien=="1"
			replace rfin_irpp_foy=7622+uni*(30489-7622) if m09=="5" & lien=="1"
			*Pareto coef of 2 for the last bracket
			replace rfin_irpp_foy=30489*(uni^(-1/2)) if m09=="6" & lien=="1"
			bys ident : egen temp=min(rfin_irpp_foy)
			replace rfin_irpp_foy=temp if rfin_irpp_foy==. & lien~="1"
			drop temp uni

	* rental income: res5
		* No need of this variable
		
	* Labor income: wages+self-employed income+pensions p148 of lil-0124dfic
		*resp1 (resc1) : yearly wages for head of household (partner), 
		*resp2 (resc2) : yearly self-employment income (forfait) for head of household (partner),			
		*resp3 (resc3) : yearly self-employment income (benefice reel) for head of household (partner),			
		*resp4 (resc4) : yearly pension for head of household (partner)
		foreach var of varlist resp1 resp2 resp3 resp4 resc1 resc2 resc3 resc4{
			destring `var', replace
			replace `var'=0 if `var'==. | `var'<0 |  `var'==9999999
			sum `var',d
		}		
		gen rev_act_pens=0
		foreach var of varlist resp1 resp2 resp3 resp4 resc1 resc2 resc3 resc4{
			replace rev_act_pens=rev_act_pens+`var'/6.55957
		}
			
	* Total income: res4 (3.8% of non-response) p152 of lil-0124dfic
		capture drop uni
		gen uni=runiform() if lien=="1"
		gen rev_tot=0 if lien=="1"
		replace rev_tot=uni*4573 if res4=="1" & lien=="1"
		replace rev_tot=4573+uni*(7622-4573) if res4=="2" & lien=="1"
		replace rev_tot=7622+uni*(11434-7622) if res4=="3" & lien=="1"
		replace rev_tot=11434+uni*(15244-11434) if res4=="4" & lien=="1"
		replace rev_tot=15244+uni*(19818-15244) if res4=="5" & lien=="1"
		replace rev_tot=19818+uni*(30489-19818) if res4=="6" & lien=="1"
		replace rev_tot=30489+uni*(45734-30489) if res4=="7" & lien=="1"
		*Pareto coef of 2 for the last bracket
		replace rev_tot=45734*(uni^(-1/2)) if res4=="8" & lien=="1"
		bys ident : egen temp=min(rev_tot)
		replace rev_tot=temp if rev_tot==. & lien~="1"
		drop temp uni
		* For non-response total income(3.8%)
		replace rev_tot=rev_act_pens+rfin_irpp_foy if res4=="" 
		* For non-response labor income
		replace rev_act_pens=max(0,rev_tot-rfin_irpp_foy) if rev_act_pens==0
		* Consistent with labor and financial income
		replace rev_tot=rev_act_pens if rev_tot<rev_act_pens

		
* C.4) Liabilities (table endettement) (not in the data) 
**************************************************************
	

* C.5) Gross wealth consistent with its components 
***************************************************
	order patrimoine_men patfonpro patfin patfin_div patfin_div_mut patfin_div_priv patfin_div_pub patfin_int patfin_liqu ccheque patfin_av ,last
	foreach var of varlist patrimoine_men-patfin_av{
		replace `var'=0 if missing(`var')
	}		

	* Harmonisation

		* First method: Gross wealth is consistent and we adjust its components
		gen tot=patfin_int +patfin_liqu +patfin_div +patfin_av+ patfonpro
		foreach var of varlist  patfin_int patfin_liqu patfin_div patfin_av patfonpro  {
			replace `var'=`var'*patrimoine_men/tot 
			replace `var'=0 if patrimoine_men==0 | tot==0
		}
		gen tot2= patfin_div_mut +patfin_div_priv +patfin_div_pub
		foreach var of varlist  patfin_div_mut patfin_div_priv patfin_div_pub  {
			replace `var'=`var'*patfin_div/tot2  if tot2~=0
		}
		replace patfin=patfin_int +patfin_liqu +patfin_div +patfin_av 

		* For those with gross wealth >0 but missing components (9% of the case)
			sort lien patrimoine_men 
			gen prob=0
			foreach var of varlist  patfonpro patfin patfin_div patfin_div_mut patfin_div_priv patfin_div_pub patfin_int patfin_liqu ccheque patfin_av  {
				replace prob=1 if  tot==0 & patrimoine_men>0
				replace `var'=patrimoine_men*`var'[_n-1]/patrimoine_men[_n-1] if tot==0 & patrimoine_men>0 & lien=="1"
			}
			drop tot prob tot2
			sort ident 
	
		/* Check for consistency: gross wealth=sum of assets
			gen tot=patfin_int +patfin_liqu +patfin_div +patfin_av+ patfonpro
			gen diff =tot-patrimoine_men
			sum diff if lien=="1"  ,d
			drop diff tot */

			
		* Second method: the assets are consistent and we recompute net wealth
		
		
		* total gross wealth
		gen pat_brut=patfonpro+patfin
		
	* Amount at the household level
		foreach var of varlist rfin_irpp_foy rev_act_pens rev_tot patrimoine_men-patfin_av pat_brut {
			bys ident : egen `var'_men=sum(`var'*(lien=="1"))
			replace `var'=`var'_men
			drop `var'_men
		}
					
	
* D) File at the household or individual level
************************************************ 
	* Identifiants mnages et individuels
		sort ident lien idnum
		capture drop temp
		gen temp=1 if lien=="1"
		replace temp=0 if temp==.
		gen id_men=sum(temp)
		

		tempfile tabmen
		save "`tabmen'",replace
		
		keep if lien=="1"
		scalar drop _all
		keep year id_men  pondn sexe age aged lien nenf nenf01 mat pcs_ind pat_brut patfonpro patfin patfin_div patfin_int patfin_liqu patfin_av ccheque patfin_div_pub patfin_div_priv patfin_div_mut rev_act_pens     rfin_irpp_foy rev_tot
		order year id_men  pondn sexe age aged lien nenf nenf01 mat pcs_ind pat_brut patfonpro patfin patfin_div patfin_int patfin_liqu patfin_av ccheque patfin_div_pub patfin_div_priv patfin_div_mut rev_act_pens     rfin_irpp_foy rev_tot
			* Arrondi des valeurs montaires
				foreach var of varlist pat_brut-rev_tot {
					replace `var'=round(`var')
				}
				
		save "$wfpat/wfEP86.dta",replace			
			

	* Individual level
	*************************
		use "`tabmen'",clear
		
		* keep only adults (>20 years old) 
			*Suppression des moins de 20 ans qui ne sont pas la personne de rfrence ou le conjoint ou qui sont seuls dans le mnage ou qui sont en mnage avec des moins de 20 ans
			gen prob=1 if (lien=="1" | lien=="2") &(aged<=2)
			bys id_men : egen probis=sum(prob==1)
			replace probis=1 if probis~=0
			*bys ident : egen verif=sum(aged>2)
			drop if (aged <=2 & prob~=1) 
			drop prob probis 
			replace age=20 if age<20
			replace aged=3 if aged==2 
		
		* Individual Identifier
			sort id_men lien idnum
			gen id_indiv=_n
			sort id_men id_indiv
			drop temp ident idnum
			
		* Dummy bor being in couple 
			bys id_men : egen marie=sum(lien=="2")
			gen pac=0
			replace pac=1 if (lien~="1" & lien~="2")
			
		* Individual wealth	
			keep year id_men id_indiv  pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat_brut patfonpro patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut
			order year id_men id_indiv pondn sexe age aged lien pac marie nenf nenf01 mat pcs_ind pat_brut patfonpro patfin patfin_div  patfin_int patfin_liqu  patfin_av ccheque  patfin_div_pub patfin_div_priv patfin_div_mut 
		
			foreach var of varlist pat_brut-patfin_div_mut{
				replace `var'=`var'/2 if (lien=="1" | lien=="2") & marie==1
				replace `var' =0 if (lien~="1" & lien~="2") 
			}

		* Arrondi des valeurs montaires
			foreach var of varlist  pat_brut-patfin_div_mut {
				replace `var'=round(`var')
			}
			
		save "$wfpat/wfEP86_ind.dta",replace


			
			