/*****************************************************************************************
 do-file utilise pour convertir le fichier brut DMTG 1984-87 en un fichier 
corrig avec variables wf87succ.dta et wf87her.dta
******************************************************************************************/
* Note : liens homogniss sur le modle de 2006 lgrement modifi
* Note : dans mon mmoire je trouvais qu'il y avait bcp de frres et soeurs en 2000 compars  2006. C'est normal car les liens ont changs. Lien =4 en 94 = 11 en 2000. Voir ficheir xls 2006 pour avoir les nouceaux liens.
* Note : en 1994 et en 2000: exo assurance-vie = primes verses aprs 70 ans jusqu' abattement de 305000 euros ce qui explique pourquoi cette variable (f4) ne doit pas dpasser 30500 euros par hritier. Il se peut qu'il y ait un montant exo_avie trs lev alors que le nbre d'hritiers est faible. Hyptohse : pas de dclaration de succession pour les hritiers qui ne touchent que l'a-vie exonre. Il faudrait checker.

set more off

clear


* Retraitement et homognisation du fichier fiscal
	
	/* 
	Dans le fichier brut, pour chaque acte de succession, on dispose de diffrentes lignes correspondant :
					_ d'abord aux informations relatifs aux dfunts et  l'actif transmis
	On retraite le fichier de faon  avoir deux types de fichiers : 
					_ le premier correspond au niveau de la succession wf87succ wf84succ
					_ le second est au niveau des hritiers wf87her et wf84her mais incorpore toutes les informations du dfunt (qui sont donc communs  l'ensemble des hritiers d'une mme succession)
	
	
	*/

**********************************************************************************
* I) Cration du fichier au niveau de l'acte de succession : wf87.dta ou wf84.dta* 
**********************************************************************************
	
	forval j =1/2 {
	use "$dataDMTG/DMTG8487.dta", clear
	if `j'==1 {
				local annee = 1984 
	}
	if `j'==2 {
				local annee = 1987 
	}
	gen year=`annee'
	local anbis=`annee'-1900
	keep if s`anbis'==1
	
	
/* A) Retraitement des donnes */

	
	/* Characteristics of the estate */
	
		* Cration d'un identifiant par acte de succession (idsucc) et d'un identifiant hritier par acte (idher)
			gen idsuc=code
			gen x=0
			replace x=1 if idsuc~=idsuc[_n-1] | (idsuc== "2000150491002000" & adec~=adec[_n-1])
			gen idsucc=1 if _n==1
			replace idsucc=idsucc[_n-1]+x if _n>1
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
					
		* Pondration
			gen pondn=pond
			drop pond
			
		* poids d'chantillonage
			gen weight = 1 if pondn < 5
			replace weight = 50 if pondn > 5
		
		* PSU : direction des services fiscaux (centres dpartementaux)
			gen psu = substr(code,1,4)
			replace psu=substr(psu,1,3)+"0" if substr(psu,-1,1)~="0"
			
			
		* Nbre de bnficiaires
			bys idsucc : egen nher=max(idher)
			sort idsucc idher

		* Lien de parent : harmonisation des liens avec 2000 de l'hritier le plus proche au plus loign
			* 
			gen lien=real(lien1)
			replace lien=0 if lien==3
				
	/* Caractristiques du dfunt */

		* Anne du dcs : rien  recoder !
			gen yeardec = 1900+real(adec)
			
		* Anne de naissance et ge  la mort : rien  recoder
			gen birth =1000+real(naisd)
		
			gen age=yeardec-birth 

		* Nbre d'enfants
			sort idsucc
			bys idsucc : egen nenf=total(lien==0)
			sort idsucc idher
			gen nenf01=0 if nenf==0
			replace nenf01=1 if nenf>0
				
		* PCS
		* Voir annexe succession et hritiers 87 pour avoir les codes professions
		* Dans le fichier 1987 : signification du code
		/*	1) sans profession
			2) retrait
			3) agriculteur
			4) Catgorie trs faible qu'on regroupe avec les ouvriers 9 /* salari agricole */
			5) indpendants
			6) cadre sup incluant les prof librales
			7) cadre moyen
			8) employ
			9) ouvrier */
			* Recodage pour harmonsier avec fichier 94 et 2000. Note : Pas de pcs dtaille => pcs_d=pcs. 
			gen pcs = 8 if real(profd)==1
			replace pcs = 7 if real(profd)==2
			replace pcs = 1 if real(profd)==3
			replace pcs = 2 if real(profd)==5
			replace pcs = 3 if real(profd)==6
			replace pcs = 4 if real(profd)==7
			replace pcs = 5 if real(profd)==8
			replace pcs = 6 if real(profd)==4 | real(profd)==9
			replace pcs=0 if real(profd)==0
			gen pcs_d=pcs

			

		* sexe  

			* rien  recoder
			gen sexe=real(sexd)-1
			
		* Dpartement
			* rien  recoder
			gen dep=real(domid)
			replace dep = 0 if dep ==99 
			
		* Rgime et statut matrimonial
			gen mat=emd
			
			* Note : le rgime matrimonial est dans le questionnaire mais pas de variable dans les donnes :  voir 
			gen regmat=0
			
			
		* revenu fiscal du foyer 
			* rbg dispo seulement en 1987
			gen rbg=0
			replace rbg = vrev/6.55957 if vrev~=. | vrev>0 & `annee'==87
			gen ir=0
			replace ir=vir/6.55957 if vir~=. & vir>0
			
			
	/* Caractristique de l'actif de succession */
	
		* A prs plusieurs tentatives et comapraison avec le livre d'Anne lAferrre Successions et hritiers, il semble que le meilleur moyen de retrouver l'actif net, c'est de faire : somme des hritiers de part taxable (n4) + exoperso (w02)-don manuel (w03)
			* Actifs de succession 
				gen temp =n4+w02-w03
				bys idsucc : egen actnetimpos= sum(temp/6.55957)
				drop temp
				gen legs=0
				gen actnet= actnetimpos
				gen passif=v19/6.55957
				gen actbrut=actnet+passif
				replace actbrut=0 if actbrut<0
				replace actnetimpos=0 if actnetimpos<0
				replace actnet=0 if actnet<0
		
		* Composition de la succession (signification des codes dans successions et hritiers en 1987)
			* Retraitement des actifs exos
				replace v20=3*v13 if v13>0 & v20==0
				replace v21=3*v14 if v14>0 & v21==0
				replace v22=3*v12 if v12>0 & v22==0
			gen pat_exo=(v20+v21+v22+v23)/6.55957
			
			/* composante de biens exos */
					gen patfin_av_exo = 0
					gen patpro_exo = (v20+v21+v22)/6.55957
					gen patfin_div_exo = 0
					gen patfin_int_exo = 0
					gen patfon_brut_exo = 0
					gen patfin_liqu_exo =(v23)/6.55957
			
			
			/* Catgories d'actifs taxables
				patfon_brut : logement (housing assets) = immeubles  husages d'habitation et monuments historiques + forfait mobilier
				patpro : non-housing tangible assets (unincorporated business + land) = immeubles  usage prof (non agricoles) + exploitations agricoles + biens ruraux + part de groupement foncier agri + bois + autres immeubles non batis + fonds de commerce + clientles) + autres meubles corporels 
				patfin_div : public equity and mutual funds (valeurs mob ctes) + private equity (val mob non ctes)
				patfin_int : obligations  ; bons ngociables, droits sociaux divers  et parts de SCI de gestion ; creances
				patfin_av : life insurance (assurances-vie)
				patfin_liqu : savings & checking accounts,.. = liquidits 
				*/
			
			
			gen patfin_av = 0
			gen patfon_brut = (v16+v17+v09+v18)/6.55957
			gen patpro=(v10+v11+v12+v13+v14+v15+v01+v02)/6.55957
			gen patfin_div = (v03+max(v04-v05,0))/6.55957

			gen patfin_int= (v05+v06+v07)/6.55957
			gen patfin_liqu= (v08)/6.55957
			gen tot = patfin_av+patfon_brut+patpro+patfin_div+patfin_int+patfin_liqu
			foreach var of varlist patfin_av-patfin_liqu {
					replace `var'=`var'/tot*actbrut if tot~=0
					replace `var'=0 if actbrut==0 | tot==0
			}
			drop tot
		
			* n'existe qu'en 1994
			gen part_bienpro = 0
		
			
			gen dons10moins=v24/6.55957
			gen dons10plus=0
			gen donsman=v25/6.55957
			gen donations=dons10moins+donsman

			* Rajout par rapport  Piketty : n'existe pas en 84 et 87
			gen nb_donant = 0
			forval i = 1/4 {
				gen date_dons`i' = 0
			}
		
		
				/* petite verif  
				by idsucc : egen actnet2 = sum(w01/6.55957)
				sum actnet actnet2 [aw=pond] if idher==1
				order actnet2 actnet, last
				keep if idher==1
				gen verif = 1 if actnet2/actnet <1.02 & actnet2/actnet >0.98
				replace verif =0 if verif==.
				gen verif2=  actnet2/actnet
				sort verif2
				sum verif [aw=pond]
				gen verif3 =verif
				replace verif3 = 1 if verif==0 & actnet2/actnetimpos <1.02 & actnet2/actnetimpos >0.98 
				*drop actnetimpos2
				* Pour les annes 84 et 87, on a pas de donnes sur l'actif ent imposable donc on est oblig de remplacer actnet = somme des parts nettes
				*/
	
				
					
		* DMTG global
		* a faire
		by idsucc : egen droitsnets = sum(p7/6.55957)
		
		
		/* Caractristique des hritiers */
		
			* Infos socio-dmohraphiques
			
				* Indicatrice hritier = personne morale
				gen persmor = 0 
				replace persmor = 1 if real(natb)==2
				
				* 63 points  recoder pour 87, 103 en 84. 
				gen birthher=1000+real(naisb)
				replace birthher = 9999 if persmor == 1
				replace birthher=. if birthher ==1000
				
				* Un peu plus de 63 points  recoder pour 87, 88 en 84
				gen ageher=yeardec-birthher if persmor == 0
				replace ageher = 9999 if persmor ==1
				
				* Dpartement de naissance : depher_naiss, dpartement du domicile : depher
				* Pas d'info sur le dpartement de naissance
				gen depher_naiss = 0
				gen depher = real(domib)
				replace depher = 0 if depher ==99
				
				gen sexeher=real(sexb)-1 if sexb=="1" | sexb=="2"
				* Les points manquants sont des personnes morales : on mets 3
				replace sexeher=3 if sexeher==. & persmor==1
				
				* pcs : Pas de pcs_d => pcs=pcs_d 
				gen pcsher = 8 if real(profd)==1
				replace pcsher = 7 if real(profd)==2
				replace pcsher = 1 if real(profd)==3
				replace pcsher = 2 if real(profd)==5
				replace pcsher = 3 if real(profd)==6
				replace pcsher = 4 if real(profd)==7
				replace pcsher = 5 if real(profd)==8
				replace pcsher = 6 if real(profd)==4 | real(profd)==9
				gen pcsher_d=pcsher
				/* module vrif 
				sort idsucc idher
				egen tot_enf=sum(nenf*pondn) if  idher==1
				replace tot_enf= 457752 if tot_enf==.
				keep if lien==0
				tabulate pcsher, gen(pcsher)
				foreach var of varlist pcsher1-pcsher10 {
				replace `var'=0 if `var'==.
				egen prop_`var'=sum(`var'*pondn/tot_enf)
				}
				collapse 	prop_*
				gen tot=prop_pcsher1+prop_pcsher2+prop_pcsher3+prop_pcsher4+prop_pcsher5+prop_pcsher6+prop_pcsher7+prop_pcsher8+prop_pcsher9+prop_pcsher10
				*/
				
				*gen nbenf_her = 0
				*replace nbenf_her = real(l8) if real(l8)~=99 &  real(l8)~=.
				
				
							
			* DMTG et actifs des hritiers
							
							
				gen partnet=w01/6.55957
				gen exosperso=w02/6.55957
				replace exosperso=0 if exosperso<0

				gen donman=w03/6.55957
				gen don10moins=w05/6.55957
				gen don10plus=0
				gen don=donman+don10moins+don10plus
				gen parttaxable=n4/6.55957
				gen abatdons=n6/6.55957
				gen parttaxeedonant=n7/6.55957
				gen abat=n8/6.55957
				gen parttaxee=n9/6.55957
				gen droitsbruts=p1/6.55957
				replace droitsbruts=0 if droitsbruts<0

				gen dtsnets=p7/6.55957
			
			keep year-dtsnets
			sort idsucc lien birthher
	
	
	
/* B)  Recodage des donnes manquantes ou abrrantes */
	
	/* Reprage des donnes abrrantes qu'on remplace par un . */
	
		* Date de naissance
			* Pas de problme d'ge du dfunt incohrent en 1984 : les dfunts ont entre 18 et 103 ans, ni en 1987 : les dfunts ont entre 17 et 106 ans
				
			
		
		* controle de cohrence date de naissance des hritiers et du dfunt
			* Seulement quelques successions avec enfant qui pose problme en 1984, aucune en 1987
		
			gen prob=1 if birth> birthher & birth~=. & lien==0
			replace prob=0 if prob==.
			bys idsucc : egen a =sum(prob)
			bys idsucc : egen age_fr = mean(birthher-birth) if prob~=1 &lien==0 & a==1
			bys idsucc : egen age_fr2=min(age_fr) if  a == 1
			*order birth birthher sexe lien idsucc, last
			replace birthher=. if prob==1 & age_fr2 > 15 & age_fr2~=.
			replace birth=. if a==1 & age_fr2 < 15
			drop prob a age_fr*
			
			replace age =yeardec-birth 
			
			
		* Classement des individus
			sort idsucc lien birthher
			drop idher x
			gen x=0
			replace x=1 if idsuc~=idsuc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
			
		
	/* Imputation des dates de naissance manquantes */
		
		
		* Pour les dfunts
			* Pas de recodage ncessaire
			
		* Pour les hritiers
			gen cible=0
			replace cible =1 if birthher~=. & birthher~=9999
			xi:reg birthher i.lien*birth i.pcs i.sexe i.mat rbg if cible==1 [aw=pondn], cluster(idsucc)
			predict birth2
			replace birthher = round(birth2) if birthher==.
			drop cible-birth2
			* Note : Avec cette mthode tous les fils d'un dfunt auront le mme age.
			
	
		* Recodage de l'age
			replace age=yeardec-birth 
			replace ageher = yeardec-birthher
			replace ageher = 0 if birthher==9999	
	
		
		* Recodage du sexe
			replace sexe=1 if idsucc==2691 & year==1987
	
		
		* On vire les individus sans patrimoine
			gen temp=pat_exo+actbrut
			drop if temp==0
			drop temp

		* Reclassement des individus par idsucc puis lien puis birther
			sort idsucc lien birthher
			drop idher x idsuc
			gen x=0
			replace x=1 if idsucc~=idsucc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
			drop x 


	* PCS du 1er enfant pour matching donation
			bys idsucc : egen pcsenf=sum(pcsher*(idher==1)*(lien==0))
	
#delimit;
order year idsucc idher pondn weight psu yeardec birth
 nher age nenf nenf01 pcs pcs_d pcsenf sexe dep mat regmat rbg  ir 
 pat_exo patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo patfon_brut patpro patfin_div patfin_div patfin_int patfin_liqu patfin_av 
 part_bienpro  actbrut passif actnet legs actnetimpos droitsnets
 donations dons10moins dons10plus donsman nb_donant date_dons1 date_dons2 date_dons3 date_dons4 ;
 #delimit cr
*save "${wfDMTG}/wf`annee'her.dta", replace

keep if idher ==1
drop lien-dtsnets idher
*ds idsucc mat, not
save "${wfDMTG}/MTG/wf`annee'succ.dta", replace
}






