/*****************************************************************************************
 do-file utilis pour convertir le fichier brut DMTG 2000 en un fichier 
corrig avec variables wf00succ.dta et wf00her.dta
******************************************************************************************/

set more off


clear
set memory 500000


* Retraitement et homognisation du fichier fiscal
	
	/* 
	Dans le fichier brut, pour chaque acte de succession, on dispose de diffrentes lignes correspondant :
					_ d'abord aux informations relatifs aux dfunts et  l'actif transmis
	On retraite le fichier de faon  avoir deux types de fichiers : 
					_ le premier correspond au niveau de la succession wf00succ
					_ le second est au niveau des hritiers wf00her mais incorpore toutes les informations du dfunt (qui sont donc communs  l'ensemble des hritiers d'une mme succession)
	
	
	*/

***********************************************************************
* I) Cration du fichier au niveau de l'acte de succession : wf00.dta* 
***********************************************************************
	
	use "$dataDMTG/DMTG00.dta", clear
		
	gen year=2000
	
	
/* A) Retraitement des donnes */

	/* Characteristics of the estate */
	
		* Cration d'un identifiant par acte de succession (idsucc) et d'un identifiant hritier par acte (idher)
			gen idsuc=substr(ident,1,15)
			* La succession avec ident =0600553801S036300 et 0600553801S036301 est  supprimer car aucune variable n'est renseigne
			* 2 successions sans pondrations supprimes
			drop if ident=="0600553801S036301" | ident=="0600553801S036300" | pond==.
			gen idh=real(substr(ident,16,2))
			replace s_b1="1" if  idh==0 & s_b1~="1"
			
			destring s_b1, replace
			replace s_b1 = 0 if s_b1==.
			gen idsucc = sum(s_b1)
			drop idh
			
			tempfile a
			save `a', replace

			keep if s_b1==1
			keep idsucc  pond year ident-s_i24
			sort idsucc 
			tempfile b
			save `b', replace			
			
			use "`a'", clear
			keep if s_b1==0
			sort idsucc			
			gen x=0
			replace x=1 if idsucc~=idsucc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
			
			drop pond ident-s_i24
			merge idsucc using "`b'"
			* tab _merge : il faut que _merge == 3
			drop _merge
			*save "$DMTG/Fichiers simuls/wf00succ.dta", replace
			
					
		* Pondration
			gen pondn = pond
			drop pond
			
			
		* PSU
			* PSU : direction des services fiscaux (centres dpartementaux). L'enqute 2000 n'a pas t ralis dans tous les dpartements comme les prcdentes
			gen psu = substr(sages,1,4)
			
		* Nbre de bnficiaires
			bys idsucc : egen nher=max(idher)
			sort idsucc idher
		
		* Lien de parent : harmonisation des liens avec 2000 de l'hritier le plus proche au plus loign
			gen lien=real(s_l2)
			replace lien=0 if real(s_l2)==3
			replace lien = lien-1 if real(s_l2)== 4 | real(s_l2)==5
			replace lien = 5 if real(s_l2)== 11
			replace lien = 9 if real(s_l2)==10
			*bys idsuc : egen tot=total(lien==1)		
			* 1 liens abrrant  recoder : un dfunt polygames 
				*bys idsuc : egen tot=total(lien==1)		
				*sort tot idsuc
				*order lien s_c2 s_l4,last 
			replace lien = 0 if idsuc=="5000351821S0543" & s_l4=="15101984"
				
							
				
	/* Caractristiques du dfunt */

		* Anne du dcs
			gen yeardec = real(substr(s_c1,5,4)) if length(s_c1)==8 & (real(substr(s_c1,5,2))==19 | real(substr(s_c1,5,2))==20)
			replace yeardec = real(substr(s_c1,5,4))+800 if length(s_c1)==8 & real(substr(s_c1,5,2))==11 & yeardec==.
			replace yeardec = real(substr(s_c1,-4,4)) if length(s_c1)==7 & (real(substr(s_c1,-4,2))==19 | real(substr(s_c1,-4,2))==20) & yeardec==.
			replace yeardec = 2000 if length(s_c1)==6 & real(substr(s_c1,-2,2))==00 & yeardec==.
			replace yeardec = 1900+real(substr(s_c1,-2,2)) if real(substr(s_c1,-2,2))> 90 & real(substr(s_c1,-2,2))<100 & yeardec==.
			replace yeardec = 2000 if yeardec==. & (real(substr(s_c1,-2,2))==00 | real(substr(s_c1,-2,2))==20)
			* Il reste 26 succ (82 observations avec des yeardec ==. => valeurs abbrantes)
			* Il y a aussi des yeardec == 1906-1957 sans doute une inversion avec la date de naissance. on les remplace par des .
			* On les remplace par l'anne 2000
			replace yeardec = 2000 if yeardec ==. | yeardec < 1990
			
		* Anne de naissance et ge  la mort
			gen birth=real(substr(s_c2,5,4)) if length(s_c2)==8 & (real(substr(s_c2,5,2))==19 | real(substr(s_c2,5,2))==20 | real(substr(s_c2,5,2))==18)
			replace birth= 1900 +real(substr(s_c2,-2,2)) if length(s_c2)==6 & birth == .
			replace birth= real(substr(s_c2,-4,4)) if length(s_c2)==7 & birth == . & (real(substr(s_c2,-4,2))==19 | real(substr(s_c2,-4,2))==20 | real(substr(s_c2,-4,2))==18)
			replace birth= real(s_c2) if length(s_c2)==4 & birth == . & real(s_c2)>=1900 & real(s_c2)<1930 
			replace birth= 1000 + real(substr(s_c2,-4,4)) if length(s_c2)==8 & birth == . & substr(s_c2,-4,2)=="09" 
			replace birth = real(substr(s_c2,-2,2))*100+real(substr(s_c2,-4,2)) if birth == . & length(s_c2)==8  & real(substr(s_c2,-2,2))==19
			replace birth = real(substr(s_c2,-3,3))*10+real(substr(s_c2,-4,1)) if birth == . & length(subinstr(s_c2," ","",.))==8  & real(substr(s_c2,-3,2))==19 & length(subinstr(s_c2,"/","",.))==8
			gen prob = 1 if birth == . & real(substr(s_c2,-3,2))==19 & (length(subinstr(s_c2,"/","",.))==7 | length(subinstr(s_c2," ","",.))==7 )
			replace birth = real(substr(s_c2,-3,3))*10 + int(uniform()*10) if  prob==1 & idsucc[_n-1]~= idsucc[_n]
			replace birth = birth[_n-1]  if prob==1 & idsucc[_n-1]== idsucc[_n]
			drop prob
			* une centaine d'observations nait en 1999-2000 sans doute une inversion avec la date du dcs. A voir.
			*replace birth=1000+birth if birth>900 & birth<1000;
			*replace birth=1890+int(40*uniform()) if birth<1897 | birth>2000 | birth==.;
			
			gen age=yeardec-birth 

		

		* Nbre d'enfants
			sort idsucc
			bys idsucc : egen nenf=total(lien==0)
			sort idsucc idher
			gen nenf01=0 if nenf==0
			replace nenf01=1 if nenf>0
			
			
		
		* PCS
			* Note : en grande majorit les PCS = retraits
			gen pcs_d=real(s_c3)
			replace pcs_d = int(pcs_d/10)*10 if substr(s_c3,-1,1)=="9"
			replace pcs_d = pcs_d/10 if pcs_d/10 == int(pcs_d/10)
			replace pcs_d = 0 if pcs_d ==.
			gen pcs = pcs_d
			replace pcs=int(pcs_d/10) if pcs_d>=10
			replace pcs=0 if pcs==.

					
		* Dpartement	
			gen dep=real(s_c4)
			replace dep = 0 if dep ==99 | dep==.
			* On a 64 00. Cela peut dire tranger ou non renseign. on laisse 00.
			
		* Rgime et statut matrimonial
			* Par rapport  94 : il y a S = spare
			gen mat=s_c6
			replace mat="D" if mat=="S"
			* Quelques observations manquantes qu'on recode
			replace mat="V" if mat=="" /* Aucun hritier de ces mat manquants n'est un conjoint donc le dfunt n'est pas mari */
			
			gen regmat=real(s_c7)+1
			replace regmat=3 if regmat==4 | regmat==5
			replace regmat=0 if mat~="M"
			replace regmat=1 if regmat==. /* 1 observation qu'on recode dans le regime le plus courant*/
		
		* sexe 
			* Quelques valeurs manquantes
			gen sexe=0 if s_c5=="1"
			replace sexe=1 if s_c5=="2"
			* pour les valeurs manquantes, imputation alatoire quand non mari, sexe oppos du conjoint quand mari
			replace sexe=int(uniform()+0.5) if sexe==. & mat~="M" & idher==1
			replace sexe = 0 if sexe==. & mat=="M" & lien==1 & real(s_l3)==2
			replace sexe = 1 if sexe==. & mat=="M" & lien==1 & real(s_l3)==1
			by idsucc : egen sexe2 = min(sexe) 
			replace sexe = sexe2 if sexe==.
			drop sexe2
			
			
		* revenu fiscal du foyer
			* Pas disponible en 2000
			gen rbg=0
			gen ir=0
	
		
	/* Caractristique de l'actif de succession */
	
			* Actifs de succession : on part de l'actif net imposable pour remonter jusqu' l'actif brut. Cela permet d'avoir actif net imposable ~= somme des parts nettes reues par les hritiers. Dans les faits, somme des parts nettes est compris entre actif net imposable et actif net car une partie des legs ne font pas l'objet d'une dclaration de succession.
				replace s_i26 = 2023728 if s_i26 == 20237728 & idsuc =="8800551801S0462" /* petit recodage  */
				gen actnetimpos=s_i26/6.55957
				gen legs=s_i25/6.55957
				replace legs = (s_i22-s_i23-s_i26)/6.55957 if legs==.
				gen actnet= actnetimpos+legs
				* quand il n'y pas de liquidation de communaut
				gen passif = s_i23/6.55957
				* quand il y a liquidation de communaut : le passif = passif du dfunt + moti du passif de la communaut
				replace s_i24=0 if s_i24==.
				replace passif = passif +(s_i14/2+s_i24)/6.55957	if s_i14~=.
				gen actbrut= actnet+passif
				replace actbrut=0 if actbrut<0
				replace actnetimpos=0 if actnetimpos<0
				replace actnet=0 if actnet<0
				
				/* petite verif 
				by idsucc : egen actnet2 = sum(s_m1/6.55957)
				sum actnet actnet2 [aw=pond] if idher==1
				order actnet2 actnet, last
				keep if idher==1
				gen verif = 1 if actnet2/actnet <1.02 & actnet2/actnet >0.98
				replace verif =0 if verif==.
				gen verif2=  actnet2/actnet
				sort verif2
				sum verif [aw=pond]
				gen verif3 =verif
				replace verif3 = 1 if verif==0 & actnet2/actnetimpos <1.02 & actnet2/actnetimpos >0.98
				sum verif3 [aw=pond]
				*drop actnetimpos2 verif*
				* On obtient une galit presque parfaite entre la somme des parts nettes et l'actif net 100.8%. Quand on prend l'actif net imposable, on a 99.3% 
				* Quand on calculait l'actif net imposable en partant de la dcomposition par type d'actif, on avait un cart de 10% entre les deux. Voir module vrif. 
				* Dsormais dans 97% des cas, actif net imposable = somme des parts nettes. Si on tient compte des diffrences dues aux legs le ratio monte  98% contre seulement 77% quand on partait de la composition de l'actif !
				*/
	
			* Composition dde la succession 
				* Attention, la somme des composantes de l'actif brut n'est pas gal  l'actif brut dans 23% des cas. Voir fin du do-file pour plus de dtail. 
				* On ne prend donc pas les montants reports mais la part de chaque type d'actif dans le total multipli ensuite par l'actif brut sauf pour les biens exos videmment.
					
				* recodage d'une succession avec des . pour certaines valeurs de variables
				foreach var of varlist s_d1-s_i21 {
				replace `var' = 0 if `var'==. & idsuc =="0600553801S0129"
				}
				
				* Retraitement des actifs exos (les actifs exos ne sont pas reports)
					replace s_d10=s_d9 if s_d9>0 & s_d10==0
					replace s_d12=s_d11 if s_d11>0 & s_d12==0
					replace s_e2=s_e1 if s_e1>0 & s_e2==0
					replace s_e6=3*s_e5 if s_e5>0 & s_e6==0
					replace s_e8=3*s_e7 if s_e7>0 & s_e8==0
					replace s_e10=3*s_e9 if s_e9>0 & s_e10==0
				gen pat_exo=(s_d10+s_d12+s_d18+s_d19+s_e6+s_e8+s_e10+s_e12+s_e2)/6.55957
				
				/* composante de biens exos */
					gen patfin_av_exo = s_d18/6.55957 
					gen patpro_exo = (s_d12+s_e2+s_e6+s_e8+s_e10)/6.55957
					gen patfin_div_exo = s_d10/6.55957
					gen patfin_int_exo = 0
					gen patfon_brut_exo = (s_e12)/6.55957
					gen patfin_liqu_exo = (s_d19)/6.55957

				/* Catgories d'actifs taxables
				patfon_brut : logement (housing assets) = immeubles  husages d'habitation et monuments historiques + forfait mobilier
				patpro : non-housing tangible assets (unincorporated business + land) = immeubles  usage prof (non agricoles) + exploitations agricoles + biens ruraux + part de groupement foncier agri + bois + autres immeubles non batis + fonds de commerce + clientles) + autres meubles corporels 
				patfin_div : public equity and mutual funds (valeurs mob ctes) + private equity (val mob non ctes)
				patfin_int : obligations  ; bons ngociables, droits sociaux divers  et parts de SCI de gestion ; creances
				patfin_av : life insurance (assurances-vie)
				patfin_liqu : savings & checking accounts,.. = liquidits 
				*/
			
	
				gen patfin_av = s_d17/6.55957
				gen patfon_brut = (s_e11+s_e14+s_e15+s_d16+s_i21)/6.55957
				gen patpro=(s_d11+s_d13+s_d14+s_e1+s_e3+s_e4 +s_e5+s_e7+s_e9+s_e13)/6.55957
				gen patfin_div = (s_d7+s_d9)/6.55957
				replace patfin_div=0 if patfin_div<0 
				gen patfin_int= (s_d8+s_d15)/6.55957
				replace patfin_int=0 if patfin_int<0
				gen patfin_liqu=(s_d1)/6.55957
				gen tot = patfon_brut+patpro+patfin_int+patfin_div+patfin_av+patfin_liqu
				foreach var of varlist patfon_brut patpro patfin_int patfin_div patfin_liqu patfin_av {
						replace `var'=`var'/tot*actbrut if tot~=0
						replace `var'=0 if actbrut==0 | tot==0
					}
				drop tot
				* n'existe qu'en 1994
				gen part_bienpro = 0
			
				
			
		* Rappel des donations antrieures et dons manuels 
			* Certaines donations ne sont pas reports en s_m5 mais le sont en s_m9 +s_m10. Mais parfois s_m10 rempli la place de s_m11
			gen prob=1 if (s_m5==0 & s_m6==0) & s_m10 >0 & s_m11 >0
			replace s_m5=s_m10 if prob==1 & s_m9==0
			drop prob
			gen prob=1 if (s_m5==0 & s_m6==0) &s_m9>0 & s_m13>0
			replace s_m5=s_m9+s_m10 if prob==1 & s_m9~=s_m10
			replace s_m5=s_m9 if prob==1 & s_m9==s_m10
			drop prob
			
			* Erreur de report
			replace s_m5=0 if s_m5<50
			
			bys idsucc : egen dons10moins=sum(s_m5/6.55957)
			bys idsucc : egen dons10plus=sum(s_m6/6.55957)
			bys idsucc : egen donsman=sum(s_m4/6.55957)
			gen donations=donsman+dons10moins+dons10plus
			
						
			gen nb_donant =0 /* n'existe pas en 2000 */
			forval i = 1/4 {
					gen date_dons`i' = 0
			} /*date_dons n'existe pas en 2000 */
					
		* DMTG global
		gen droitsnetsa=s_i27/6.55957 /* 1 observation manquante  recoder  partir des droits nets hritier */
		bys idsucc : egen droitsnetstemp = sum(s_m18/6.55957) 
		replace droitsnetsa = droitsnetstemp if droitsnetsa==.
		drop droitsnetstemp
		bys idsucc : egen droitsnets=max(droitsnetsa)
		drop droitsnetsa
		
	/* Caractristique des hritiers */
		
			* Infos socio-dmographiques
			
				* Indicatrice hritier = personne morale
				gen persmor = 0 
				replace persmor = 1 if real(s_l2)==10
				
				gen birthher=real(substr(s_l4,5,4)) if length(s_l4)==8 & (real(substr(s_l4,5,2))==19 | real(substr(s_l4,5,2))==18 | real(substr(s_l4,5,2))==20)
				replace birthher= 1900 +real(substr(s_l4,-2,2)) if length(s_l4)==6 & birthher == .
				replace birthher= real(substr(s_l4,-4,4)) if length(s_l4)==7 & birthher == . & (real(substr(s_l4,-4,2))==19 | real(substr(s_l4,-4,2))==20 | real(substr(s_l4,-4,2))==18)
				replace birthher= real(s_l4) if length(s_l4)==4 & birthher == . & real(s_l4)>=1900 & real(s_l4)<2001 
				replace birthher= 1000 + real(substr(s_l4,-4,4)) if length(s_l4)==8 & birthher == . & substr(s_l4,-4,2)=="09" 
				replace birthher = 9999 if persmor==1
				*replace birthher=1000+birthher if birthher>900 & birthher<1000;
				*replace birthher=1925+int(45*uniform()) if birthher<1898 | birthher>2000 | birthher==.;

				gen ageher=yeardec-birthher 
				replace ageher = 0 if birthher == 0 | birthher == 9999
				
				
		

				* Dpartement de naissance : depher_naiss, dpartement du domicile : depher
				gen depher_naiss = real(s_l5) 
				replace depher_naiss = 0 if depher_naiss ==99|depher_naiss==.
				gen depher = real(s_l6)
				replace depher = 0 if depher ==99|depher==.

				gen sexeher=0 if s_l3=="1"
				replace sexeher=1 if s_l3=="2"
				* recodage de sexeher : sexe oppos du conjoint et alatoire quand non conjoint
				replace sexeher = 0 if sexe ==1 & lien==1 & sexeher==.
				replace sexeher = 1 if sexe==0 & lien==0 & sexeher==.
				replace sexeher=int(uniform()+0.5) if sexeher==. 
				
				gen pcsher_d=real(s_l7)
				replace pcsher_d = int(pcsher_d/10)*10 if substr(s_l7,-1,1)=="9"
				replace pcsher_d = pcsher_d/10 if pcsher_d/10 == int(pcsher_d/10)
				replace pcsher_d = 0 if pcsher_d ==.
				gen pcsher = pcsher_d
				replace pcsher=int(pcsher_d/10) if pcsher_d>=10
				replace pcsher=0 if pcsher==.
				
				*gen nbenf_her = 0
				*replace nbenf_her = real(l8) if real(l8)~=99 &  real(l8)~=.
				
				
		
			
			* DMTG et actifs des hritiers
			
				gen partnet=s_m1/6.55957
				gen exosperso=s_m2/6.55957
				replace exosperso=0 if exosperso<0
				
				gen donman=s_m4/6.55957
				gen don10moins=s_m5/6.55957
				gen don10plus=s_m6/6.55957
				gen don=donman+don10moins+don10plus


				gen parttaxable=s_m8/6.55957
				replace exosperso = partnet-parttaxable if exosperso==.
				gen abatdons=s_m10/6.55957
				gen parttaxeedonant=s_m9/6.55957
				replace parttaxeedonant = don10moins-abatdons if parttaxeedonant==.
				gen abat=s_m11/6.55957
				gen parttaxee=s_m12/6.55957
				
				gen droitsbruts=s_m13/6.55957
				replace droitsbruts=0 if droitsbruts<0
				gen dtsnets=s_m18/6.55957
				
							
				keep year idsucc idher pondn-dtsnets
	
	
/* B)  Recodage des donnes manquantes ou abrrantes */
	
	/* Reprage des donnes abrrantes qu'on remplace par un . */
	
		* Date de naissance
			* Pour les gens ns aprs 1992 : problme s'ils ont des enfants ou sont marris
			* Problme si date de naissance > 1998
			replace birth=. if birth >=1992  & birth ~=. & nenf >0
			replace birth =. if birth >= 1999
			
			sort idsucc lien birthher
			
			

		* controle de cohrence date de naissance des hritiers et du dfunt
		
			gen prob=1 if birth> birthher & birth~=. & lien==0
			replace prob=0 if prob==.
			bys idsucc : egen a =sum(prob)
			bys idsucc : egen age_fr = mean(birthher-birth) if prob~=1 &lien==0 & a==1
			bys idsucc : egen age_fr2=min(age_fr) if  a == 1
			*order birth birthher sexe lien idsucc, last
			replace birthher=. if prob==1 & age_fr2 > 15 & age_fr2~=.
			replace birth=. if a==1 & age_fr2 < 15
			replace a = 0 if age_fr2 ~=.
			replace prob=0 if age_fr2 ~=.
			drop age_fr*
			bys idsucc : egen age_fr = mean(birthher-birth) if prob~=1 & (lien==5 | lien==1) & a==1 
			bys idsucc : egen age_fr2=min(age_fr) if a ==1
			replace birthher=. if prob==1 & age_fr2 < 15 & age_fr2~=.
			replace birth=. if prob==1 & age_fr2 < 15
			drop prob a age_fr*
			
			replace age =yeardec-birth 
			
		* Classement des individus
			sort idsucc lien birthher
			drop idher 
			gen x=0
			replace x=1 if idsuc~=idsuc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
			
	tempfile a
	save "`a'", replace
		
	/* Imputation des dates de naissance manquantes */
		
		* Pour les dfunts
			* On fait un petit reshape maison pour pouvoir avoir une ligne par succession avec les hritiers qui nous intresse en colonne
			
		
			gen femmetemp=1 if lien==1
			replace femmetemp=0 if femme==.
			gen birthtemp =birthher if femmetemp==1
			replace birthtemp=0 if birthtemp==.
			bys idsucc :  egen femme = sum(femmetemp)
			bys idsucc :  egen birthfemme = sum(birthtemp)
			drop birthtemp femmetemp
			
			forval i =1/2 {
				gen enftemp`i'=0
				gen birthenftemp`i'=0
				replace enftemp`i'=1 if idher==`i' & nenf>=`i'
				replace birthenftemp`i'=birthher if idher==`i' & nenf>=`i'
				bys idsucc :  egen enf`i' = sum(enftemp`i')
				bys idsucc :  egen birthenf`i' = sum(birthenftemp`i')
			}
			drop birthenftemp* enftemp*
			
			forval i =1/2 {
				gen freretemp`i'=0
				gen birthfreretemp`i'=0
			}
			replace freretemp1=1 if lien==5 & lien ~= lien[_n-1]
			replace freretemp2=1 if lien==5 & lien == lien[_n-1] & lien[_n-1] ~= lien[_n-2]
			replace birthfreretemp1=birthher if lien==5 & lien ~= lien[_n-1]
			replace birthfreretemp2=birthher if lien==5 & lien == lien[_n-1] & lien[_n-1] ~= lien[_n-2]
			forval i =1/2 {
				bys idsucc :  egen frere`i' = sum(freretemp`i')
				bys idsucc :  egen birthfrere`i' = sum(birthfreretemp`i')
			}
			drop birthfreretemp* freretemp*
			keep if idher==1
			
			foreach var of varlist femme frere? enf? {
			replace `var'=0 if birth`var'==0
			}
			
			gen cible = 0
			replace cible=1 if birth ~=. & (enf1 >0 | enf2 >0 | frere1>0 | frere2>0 |  femme >0)
			xi:reg birth i.femme*birthfemme i.enf1*birthenf1  i.enf2*birthenf2 i.frere1*birthfrere1 i.frere2*birthfrere2 if cible==1 [aw=pondn]
			predict birth2
			
			replace birth = round(birth2) if birth==.
			keep birth idsucc
			sort idsucc
			merge idsucc using "`a'"
			drop _merge
			sort idsucc idher
			
		* Pour les hritiers
			gen cible=0
			replace cible =1 if birthher~=. & birthher~=9999
			xi:reg birthher i.lien*birth i.pcs i.sexe i.mat rbg if cible==1 [aw=pondn], cluster(idsucc)
			predict birth2
			replace birthher = round(birth2) if birthher==.
			drop cible-birth2
			* Note : Avec cette mthode tous les fils d'un dfunt auront le mme age.
			
	
		* Recodage de l'age
			replace age=yeardec-birth 
			replace ageher = yeardec-birthher
			replace ageher = 0 if birthher==9999

		* On vire les individus sans patrimoine
			gen temp=pat_exo+actbrut
			drop if temp==0
			drop temp



		* Reclassement des individus par idsucc puis lien puis birther
			order year idsucc idher pondn 
			sort idsucc lien birthher
			drop idher x
			gen x=0
			replace x=1 if idsuc~=idsuc[_n-1]
			gen idher=1 if x==1
			replace idher=idher[_n-1]+1 if x==0
			sort idsucc idher
			drop x 
		
		* PCS du 1er enfant pour matching donation
			bys idsucc : egen pcsenf=sum(pcsher*(idher==1)*(lien==0))
			
		* Arrondi
			foreach var of varlist rbg-patfin_liqu dons10moins donations partnet-dtsnets {
				replace `var'=round(`var')
			}



#delimit;
order year idsucc idher pondn psu yeardec birth
 nher age nenf nenf01 pcs pcs_d pcsenf sexe dep mat regmat rbg  ir 
 pat_exo patfon_brut_exo patpro_exo patfin_div_exo patfin_int_exo patfin_liqu_exo patfin_av_exo patfon_brut patpro patfin_div patfin_int patfin_liqu patfin_av
  part_bienpro  actbrut passif actnet legs actnetimpos droitsnets
 donations dons10moins dons10plus donsman nb_donant date_dons1 date_dons2 date_dons3 date_dons4 ;
 #delimit cr


*save "${wfDMTG}/wf00her.dta", replace

keep if idher ==1
drop lien-dtsnets idher
*ds idsucc mat, not
save "${wfDMTG}/MTG/wf2000succ.dta", replace


* Note : en 1994 et en 2000: exo assurance-vie = primes verses aprs 70 ans jusqu' abattement de 305000 euros ce qui explique pourquoi cette variable (f4) ne doit pas dpasser 30500 euros par hritier. Il se peut qu'il y ait un montant exo_avie trs lev alors que le nbre d'hritiers est faible. Hyptohse : pas de dclaration de succession pour les hritiers qui ne touchent que l'a-vie exonre. Il faudrait checker.


	/*

* Module de vrification

	
	* stats des
		* Somme des parts nettes
		egen tot = sum(parnet*pond)
		* somme des actifs nets reports dans les donnes
		 egen totactnet2 = sum(actnetimpos2*pond) if idher==1
		* somme des actifs nets calculs  partir de la dcomposition par type d'actifs
		egen totactnet = sum(actnetimpos*pond) if idher==1
		* Rsultat :totactnet2 colle assez bien au niveau agrg avec partnet (-0,58% d'cart par rapport  partnette) mais +10% d'cart entre tranche par actifs et partnette.
		
	/* Le total meuble et immeuble ne correspond pas toujouts  l'actif brut de succession-forfait mobilier alors que a devrait tre le cas 
	
	* Etude  et explication de ce phnomne
	
	keep if idher==1
		* part des successions avec communaut : 41%
				gen ind=1 if s_i12 > 0 & s_i12~=.
				replace ind=0 if ind==.
				sum ind [aw=pond]

	
		* Quand il n'y a pas de liquidation de communaut :
			
			*s_h1 (total meuble et immeuble = actif brut-forfait mobilier) 99.7% des cas ie 59% des successions
				
			* Dans le cas o il n'y pas de communaut
				gen actbrutverif=s_i22-s_i21
				gen verif3=1 if ind==0 & actbrutverif/s_h1 >= 0.98 & actbrutverif/s_h1 <= 1.02
				gen prob3=0 if ind==0 & verif3~=1
				replace prob3=1 if ind==0 & verif3==1
				sum prob3 [aw=pond] if ind==0
				
			* Quand il y a liquidation de la communaut
				keep if s_i12 > 0 & s_i12 ~=.
				drop verif3 prob3
				* Biens communs/2 + biens propres du dfunt
				gen tot2=s_i12/2+ s_i18
				* Part de la communaut revenant au dfunt (aprs prise en compte des rcompenses et reprises) + moiti du passif + bien propre
				gen tot3=s_i20 +s_i14/2	
				gen verif = 0
				replace verif=1 if tot/tot2 >= 0.98 & tot/tot2 <= 1.02
				sum verif [aw=pond]
				gen verif2 = tot-tot2 if verif==0
				gen var = tot/tot2
				* Biens communs
				gen tot4=s_i12
				gen verif4 = 0
				replace verif4=1 if tot/tot4 >= 0.98 & tot/tot4 <= 1.02
				sum verif4 [aw=pond]
				gen var4 = tot/tot4
				drop if verif==1|verif4==1
				* Quand communaut > 0, tot2 correspond  tot dans 44% des cas. tot4 correspond  tot dans 42% des cas ie 17% des successions alors que a ne devrait pas tre le cas.
*/
